# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.scalar_tree import ScalarTree


class SpanSpace(ScalarTree):
    """
    SpanSpace - organize data according to scalar span space
    
    Superclass: ScalarTree
    
    This is a helper class used to accelerate contouring operations.
    Given an dataset, it organizes the dataset cells into a 2D binned
    space, with coordinate axes (scalar_min,scalar_max). This so-called
    span space can then be traversed quickly to find the cells that
    intersect a specified contour value.
    
    This class has an API that supports both serial and parallel
    operation.  The parallel API enables the using class to grab arrays
    (or batches) of cells that lie along a particular row in the span
    space. These arrays can then be processed separately or in parallel.
    
    Learn more about span space in these two publications: 1) "A Near
    Optimal Isosorface Extraction Algorithm Using the Span Space." Yarden
    Livnat et al. and 2) Isosurfacing in Span Space with Utmost
    Efficiency." Han-Wei Shen et al.
    
    @sa
    ScalarTree SimpleScalarTree
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSpanSpace, obj, update, **traits)
    
    compute_resolution = tvtk_base.true_bool_trait(desc=\
        """
        Boolean controls whether the resolution of span space is computed
        automatically from the average number of cells falling in each
        bucket.
        """
    )

    def _compute_resolution_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeResolution,
                        self.compute_resolution_)

    compute_scalar_range = tvtk_base.true_bool_trait(desc=\
        """
        This boolean controls whether the determination of the scalar
        range is computed from the input scalar data. By default this is
        enabled.
        """
    )

    def _compute_scalar_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeScalarRange,
                        self.compute_scalar_range_)

    batch_size = traits.Trait(100, traits.Range(100, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the size of the cell batches when processing in parallel.
        By default the batch size = 100 cells in each batch.
        """
    )

    def _batch_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBatchSize,
                        self.batch_size)

    number_of_cells_per_bucket = traits.Trait(5, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        Specify the average number of cells in each bucket. This is used
        to indirectly control the resolution if compute_resolution is
        enabled.
        """
    )

    def _number_of_cells_per_bucket_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfCellsPerBucket,
                        self.number_of_cells_per_bucket)

    resolution = traits.Trait(100, traits.Range(1, 10000), enter_set=True, auto_set=False, desc=\
        """
        Set/Get the resolution N of the span space. The span space can be
        envisioned as a rectangular lattice of NXN buckets/bins (i.e., N
        rows and N columns), where each bucket stores a list of cell ids.
        The i-j coordinate of each cell (hence its location in the
        lattice) is determined from the cell's 2-tuple (smin,smax) scalar
        range.  By default Resolution = 100, with a clamp of 10,000.
        """
    )

    def _resolution_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetResolution,
                        self.resolution)

    scalar_range = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(0.0, 1.0), cols=2, desc=\
        """
        Specify the scalar range in terms of minimum and maximum values
        (smin,smax). These values are used to build the span space. Note
        that setting the range can have significant impact on the
        performance of the span space as it controls the effective
        resolution near important isocontour values. By default the range
        is computed automatically; turn off compute_scalar_range is you
        wish to manually specify it.
        """
    )

    def _scalar_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScalarRange,
                        self.scalar_range)

    _updateable_traits_ = \
    (('compute_resolution', 'GetComputeResolution'),
    ('compute_scalar_range', 'GetComputeScalarRange'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('batch_size', 'GetBatchSize'), ('number_of_cells_per_bucket',
    'GetNumberOfCellsPerBucket'), ('resolution', 'GetResolution'),
    ('scalar_range', 'GetScalarRange'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ('resolution',)
    
    _full_traitnames_list_ = \
    (['compute_resolution', 'compute_scalar_range', 'debug',
    'global_warning_display', 'batch_size', 'number_of_cells_per_bucket',
    'resolution', 'scalar_range'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SpanSpace, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SpanSpace properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compute_resolution', 'compute_scalar_range'], [],
            ['batch_size', 'number_of_cells_per_bucket', 'resolution',
            'scalar_range']),
            title='Edit SpanSpace properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SpanSpace properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

