# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class RuledSurfaceFilter(PolyDataAlgorithm):
    """
    RuledSurfaceFilter - generates a surface from a set of lines
    
    Superclass: PolyDataAlgorithm
    
    RuledSurfaceFilter is a filter that generates a surface from a set
    of lines. The lines are assumed to be "parallel" in the sense that
    they do not intersect and remain somewhat close to one another. A
    surface is generated by connecting the points defining each pair of
    lines with straight lines. This creates a strip for each pair of
    lines (i.e., a triangulation is created from two generating lines).
    The filter can handle an arbitrary number of lines, with lines i and
    i+1 assumed connected. Note that there are several different
    approaches for creating the ruled surface, the method for creating
    the surface can either use the input points or resample from the
    polylines (using a user-specified resolution).
    
    This filter offers some other important features. A distance_factor
    ivar is used to decide when two lines are too far apart to connect.
    (The factor is a multiple of the distance between the first two
    points of the two lines defining the strip.) If the distance between
    the two generating lines becomes too great, then the surface is not
    generated in that region. (Note: if the lines separate and then
    merge, then a hole can be generated in the surface.) In addition, the
    Offset and on_ration ivars can be used to create nifty striped
    surfaces. Closed surfaces (e.g., tubes) can be created by setting the
    close_surface ivar. (The surface can be closed in the other direction
    by repeating the first and last point in the polylines defining the
    surface.)
    
    An important use of this filter is to combine it with StreamTracer
    to generate stream surfaces. It can also be used to create surfaces
    from contours.
    
    @warning
    The number of lines must be greater than two if a surface is to be
    generated.  sides (i.e., a ribbon), use RibbonFilter.
    
    @sa
    RibbonFilter StreamTracer
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkRuledSurfaceFilter, obj, update, **traits)
    
    close_surface = tvtk_base.false_bool_trait(desc=\
        """
        Indicate whether the surface is to be closed. If this boolean is
        on, then the first and last polyline are used to generate a
        stripe that closes the surface. (Note: to close the surface in
        the other direction, repeat the first point in the polyline as
        the last point in the polyline.)
        """
    )

    def _close_surface_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCloseSurface,
                        self.close_surface_)

    orient_loops = tvtk_base.false_bool_trait(desc=\
        """
        Indicate whether the starting points of the loops need to be
        determined. If set to 0, then its assumes that the 0th point of
        each loop should be always connected By default the loops are not
        oriented.
        """
    )

    def _orient_loops_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOrientLoops,
                        self.orient_loops_)

    pass_lines = tvtk_base.false_bool_trait(desc=\
        """
        Indicate whether the generating lines are to be passed to the
        output. By default lines are not passed to the output.
        """
    )

    def _pass_lines_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassLines,
                        self.pass_lines_)

    ruled_mode = tvtk_base.RevPrefixMap({'resample': 0, 'point_walk': 1}, default_value='resample', desc=\
        """
        Set the mode by which to create the ruled surface. (Dramatically
        different results are possible depending on the chosen mode.) The
        resample mode evenly resamples the polylines (based on length)
        and generates triangle strips. The point walk mode uses the
        existing points and walks around the polyline using existing
        points.
        """
    )

    def _ruled_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRuledMode,
                        self.ruled_mode_)

    distance_factor = traits.Trait(3.0, traits.Range(1.0, 1e+299, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the factor that controls tearing of the surface.
        """
    )

    def _distance_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDistanceFactor,
                        self.distance_factor)

    offset = traits.Trait(0, traits.Range(0, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        Control the striping of the ruled surface. The offset sets the
        first stripe that is visible. Offset is generally used with
        on_ratio to create nifty striping effects.
        """
    )

    def _offset_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOffset,
                        self.offset)

    on_ratio = traits.Trait(1, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        Control the striping of the ruled surface. If on_ratio is greater
        than 1, then every nth strip is turned on, beginning with the
        Offset strip.
        """
    )

    def _on_ratio_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOnRatio,
                        self.on_ratio)

    resolution = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int64", value=(1, 1), cols=2, desc=\
        """
        If the ruled surface generation mode is RESAMPLE, then these
        parameters are used to determine the resample rate. Resolution[0]
        defines the resolution in the direction of the polylines;
        Resolution[1] defines the resolution across the polylines (i.e.,
        direction orthogonal to Resolution[0]).
        """
    )

    def _resolution_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetResolution,
                        self.resolution)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('close_surface', 'GetCloseSurface'), ('orient_loops',
    'GetOrientLoops'), ('pass_lines', 'GetPassLines'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('ruled_mode', 'GetRuledMode'),
    ('distance_factor', 'GetDistanceFactor'), ('offset', 'GetOffset'),
    ('on_ratio', 'GetOnRatio'), ('resolution', 'GetResolution'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'close_surface', 'debug', 'global_warning_display',
    'orient_loops', 'pass_lines', 'release_data_flag', 'ruled_mode',
    'distance_factor', 'offset', 'on_ratio', 'progress_text',
    'resolution'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(RuledSurfaceFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit RuledSurfaceFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['close_surface', 'orient_loops', 'pass_lines'], ['ruled_mode'],
            ['distance_factor', 'offset', 'on_ratio', 'resolution']),
            title='Edit RuledSurfaceFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit RuledSurfaceFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

