# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.window import Window


class RenderWindow(Window):
    """
    RenderWindow - create a window for renderers to draw into
    
    Superclass: Window
    
    RenderWindow is an abstract object to specify the behavior of a
    rendering window. A rendering window is a window in a graphical user
    interface where renderers draw their images. Methods are provided to
    synchronize the rendering process, set window size, and control
    double buffering.  The window also allows rendering in stereo.  The
    interlaced render stereo type is for output to a VRex stereo
    projector.  All of the odd horizontal lines are from the left eye,
    and the even lines are from the right eye.  The user has to make the
    render window aligned with the VRex projector, or the eye will be
    swapped.
    
    @warning
    In VTK versions 4 and later, the WindowToImageFilter class is part
    of the canonical way to output an image of a window to a file
    (replacing the obsolete save_image_as_ppm method for RenderWindows
    that existed in 3.2 and earlier).  Connect one of these filters to
    the output of the window, and filter's output to a writer such as
    PNGWriter.
    
    @sa
    Renderer RenderWindowInteractor WindowToImageFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkRenderWindow, obj, update, **traits)
    
    borders = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off window manager borders. Typically, you shouldn't turn
        the borders off, because that bypasses the window manager and can
        cause undesirable behavior.
        """
    )

    def _borders_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBorders,
                        self.borders_)

    full_screen = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off rendering full screen window size.
        """
    )

    def _full_screen_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFullScreen,
                        self.full_screen_)

    is_picking = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _is_picking_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIsPicking,
                        self.is_picking_)

    line_smoothing = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off line smoothing. Default is off. This must be applied
        before the first Render.
        """
    )

    def _line_smoothing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLineSmoothing,
                        self.line_smoothing_)

    point_smoothing = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off point smoothing. Default is off. This must be applied
        before the first Render.
        """
    )

    def _point_smoothing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPointSmoothing,
                        self.point_smoothing_)

    polygon_smoothing = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off polygon smoothing. Default is off. This must be
        applied before the first Render.
        """
    )

    def _polygon_smoothing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolygonSmoothing,
                        self.polygon_smoothing_)

    stencil_capable = tvtk_base.false_bool_trait(desc=\
        """
        Set / Get the availability of the stencil buffer.
        """
    )

    def _stencil_capable_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStencilCapable,
                        self.stencil_capable_)

    stereo_capable_window = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _stereo_capable_window_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStereoCapableWindow,
                        self.stereo_capable_window_)

    stereo_render = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _stereo_render_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStereoRender,
                        self.stereo_render_)

    swap_buffers = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off buffer swapping between images.
        """
    )

    def _swap_buffers_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSwapBuffers,
                        self.swap_buffers_)

    use_srgb_color_space = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _use_srgb_color_space_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseSRGBColorSpace,
                        self.use_srgb_color_space_)

    stereo_type = tvtk_base.RevPrefixMap({'crystal_eyes': 1, 'anaglyph': 7, 'checkerboard': 8, 'dresden': 6, 'emulate': 11, 'fake': 10, 'interlaced': 3, 'left': 4, 'red_blue': 2, 'right': 5, 'split_viewport_horizontal': 9}, default_value='crystal_eyes', desc=\
        """
        
        """
    )

    def _stereo_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStereoType,
                        self.stereo_type_)

    abort_render = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _abort_render_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAbortRender,
                        self.abort_render)

    alpha_bit_planes = traits.Int(8, enter_set=True, auto_set=False, desc=\
        """
        Turn on/off the use of alpha bitplanes.
        """
    )

    def _alpha_bit_planes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAlphaBitPlanes,
                        self.alpha_bit_planes)

    anaglyph_color_mask = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int64", value=(4, 3), cols=2, desc=\
        """
        Set/get the anaglyph color mask values.  These two numbers are
        bits mask that control which color channels of the original
        stereo images are used to produce the final anaglyph image.  The
        first value is the color mask for the left view, the second the
        mask for the right view.  If a bit in the mask is on for a
        particular color for a view, that color is passed on to the final
        view; if it is not set, that channel for that view is ignored.
        The bits are arranged as r, g, and b, so r = 4, g = 2, and b = 1.
        By default, the first value (the left view) is set to 4, and the
        second value is set to 3.  That means that the red output channel
        comes from the left view, and the green and blue values come from
        the right view.
        """
    )

    def _anaglyph_color_mask_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAnaglyphColorMask,
                        self.anaglyph_color_mask)

    anaglyph_color_saturation = traits.Trait(0.6499999761581421, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        """
        Set/get the anaglyph color saturation factor.  This number ranges
        from 0.0 to 1.0:  0.0 means that no color from the original
        object is maintained, 1.0 means all of the color is maintained. 
        The default value is 0.65.  Too much saturation can produce
        uncomfortable 3D viewing because anaglyphs also use color to
        encode 3D.
        """
    )

    def _anaglyph_color_saturation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAnaglyphColorSaturation,
                        self.anaglyph_color_saturation)

    current_cursor = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Change the shape of the cursor.
        """
    )

    def _current_cursor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCurrentCursor,
                        self.current_cursor)

    cursor_file_name = tvtk_base.vtk_file_name("", desc=\
        """
        Set/Get the full path to the custom cursor. This is used when the
        current cursor is set to VTK_CURSOR_CUSTOM.
        """
    )

    def _cursor_file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCursorFileName,
                        self.cursor_file_name)

    desired_update_rate = traits.Float(0.0001, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the desired update rate. This is used with the
        LODActor class. When using level of detail actors you need to
        specify what update rate you require. The LODActors then will
        pick the correct resolution to meet your desired update rate in
        frames per second. A value of zero indicates that they can use
        all the time they want to.
        """
    )

    def _desired_update_rate_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDesiredUpdateRate,
                        self.desired_update_rate)

    device_index = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        If there are several graphics card installed on a system, this
        index can be used to specify which card you want to render to.
        the default is 0. This may not work on all derived render window
        and it may need to be set before the first render.
        """
    )

    def _device_index_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDeviceIndex,
                        self.device_index)

    in_abort_check = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _in_abort_check_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInAbortCheck,
                        self.in_abort_check)

    def _get_interactor(self):
        return wrap_vtk(self._vtk_obj.GetInteractor())
    def _set_interactor(self, arg):
        old_val = self._get_interactor()
        self._wrap_call(self._vtk_obj.SetInteractor,
                        deref_vtk(arg))
        self.trait_property_changed('interactor', old_val, arg)
    interactor = traits.Property(_get_interactor, _set_interactor, desc=\
        """
        Get the interactor associated with this render window
        """
    )

    multi_samples = traits.Int(8, enter_set=True, auto_set=False, desc=\
        """
        Set / Get the number of multisamples to use for hardware
        antialiasing. A value of 1 will be set to 0.
        """
    )

    def _multi_samples_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMultiSamples,
                        self.multi_samples)

    number_of_layers = traits.Trait(1, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        
        """
    )

    def _number_of_layers_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfLayers,
                        self.number_of_layers)

    def get_pixel_data(self, *args):
        """
        get_pixel_data(self, __a:int, __b:int, __c:int, __d:int, __e:int,
            __f:int) -> Pointer
        C++: virtual unsigned char *get_pixel_data(int, int, int, int, int,
            int=0)
        get_pixel_data(self, __a:int, __b:int, __c:int, __d:int, __e:int,
            __f:UnsignedCharArray, __g:int) -> int
        C++: virtual int get_pixel_data(int, int, int, int, int,
            UnsignedCharArray *, int=0)
        Get the pixel data of an image, transmitted as RGBRGBRGB. The
        front argument indicates if the front buffer should be used or
        the back buffer. It is the caller's responsibility to delete the
        resulting array. It is very important to realize that the memory
        in this array is organized from the bottom of the window to the
        top. The origin of the screen is in the lower left corner. The y
        axis increases as you go up the screen. So the storage of pixels
        is from left to right and from bottom to top. (x,y) is any corner
        of the rectangle. (x2,y2) is its opposite corner on the diagonal.
        """
        my_args = deref_array(args, [('int', 'int', 'int', 'int', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'vtkUnsignedCharArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.GetPixelData, *my_args)
        return ret

    def set_pixel_data(self, *args):
        """
        set_pixel_data(self, __a:int, __b:int, __c:int, __d:int, __e:[int,
            ...], __f:int, __g:int) -> int
        C++: virtual int set_pixel_data(int, int, int, int, unsigned char *,
             int, int=0)
        set_pixel_data(self, __a:int, __b:int, __c:int, __d:int,
            __e:UnsignedCharArray, __f:int, __g:int) -> int
        C++: virtual int set_pixel_data(int, int, int, int,
            UnsignedCharArray *, int, int=0)
        Set/Get the pixel data of an image, transmitted as RGBRGBRGB. The
        front argument indicates if the front buffer should be used or
        the back buffer. It is the caller's responsibility to delete the
        resulting array. It is very important to realize that the memory
        in this array is organized from the bottom of the window to the
        top. The origin of the screen is in the lower left corner. The y
        axis increases as you go up the screen. So the storage of pixels
        is from left to right and from bottom to top. (x,y) is any corner
        of the rectangle. (x2,y2) is its opposite corner on the diagonal.
        """
        my_args = deref_array(args, [('int', 'int', 'int', 'int', ['int', Ellipsis], 'int', 'int'), ('int', 'int', 'int', 'int', 'vtkUnsignedCharArray', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.SetPixelData, *my_args)
        return ret

    def get_rgba_char_pixel_data(self, *args):
        """
        get_rgba_char_pixel_data(self, __a:int, __b:int, __c:int, __d:int,
            __e:int, __f:int) -> Pointer
        C++: virtual unsigned char *get_rgba_char_pixel_data(int, int, int,
            int, int, int=0)
        get_rgba_char_pixel_data(self, __a:int, __b:int, __c:int, __d:int,
            __e:int, __f:UnsignedCharArray, __g:int) -> int
        C++: virtual int get_rgba_char_pixel_data(int, int, int, int, int,
            UnsignedCharArray *, int=0)"""
        my_args = deref_array(args, [('int', 'int', 'int', 'int', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'vtkUnsignedCharArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.GetRGBACharPixelData, *my_args)
        return ret

    def set_rgba_char_pixel_data(self, *args):
        """
        set_rgba_char_pixel_data(self, __a:int, __b:int, __c:int, __d:int,
            __e:[int, ...], __f:int, __g:int, __h:int) -> int
        C++: virtual int set_rgba_char_pixel_data(int, int, int, int,
            unsigned char *, int, int=0, int=0)
        set_rgba_char_pixel_data(self, __a:int, __b:int, __c:int, __d:int,
            __e:UnsignedCharArray, __f:int, __g:int, __h:int) -> int
        C++: virtual int set_rgba_char_pixel_data(int, int, int, int,
            UnsignedCharArray *, int, int=0, int=0)"""
        my_args = deref_array(args, [('int', 'int', 'int', 'int', ['int', Ellipsis], 'int', 'int', 'int'), ('int', 'int', 'int', 'int', 'vtkUnsignedCharArray', 'int', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.SetRGBACharPixelData, *my_args)
        return ret

    def get_rgba_pixel_data(self, *args):
        """
        get_rgba_pixel_data(self, __a:int, __b:int, __c:int, __d:int,
            __e:int, __f:int) -> Pointer
        C++: virtual float *get_rgba_pixel_data(int, int, int, int, int,
            int=0)
        get_rgba_pixel_data(self, __a:int, __b:int, __c:int, __d:int,
            __e:int, __f:FloatArray, __g:int) -> int
        C++: virtual int get_rgba_pixel_data(int, int, int, int, int,
            FloatArray *, int=0)
        Same as Get/set_pixel_data except that the image also contains an
        alpha component. The image is transmitted as RGBARGBARGBA... each
        of which is a float value. The "blend" parameter controls whether
        the set_rgba_pixel_data method blends the data with the previous
        contents of the frame buffer or completely replaces the frame
        buffer data.
        """
        my_args = deref_array(args, [('int', 'int', 'int', 'int', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'vtkFloatArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.GetRGBAPixelData, *my_args)
        return ret

    def set_rgba_pixel_data(self, *args):
        """
        set_rgba_pixel_data(self, __a:int, __b:int, __c:int, __d:int,
            __e:[float, ...], __f:int, __g:int, __h:int) -> int
        C++: virtual int set_rgba_pixel_data(int, int, int, int, float *,
            int, int=0, int=0)
        set_rgba_pixel_data(self, __a:int, __b:int, __c:int, __d:int,
            __e:FloatArray, __f:int, __g:int, __h:int) -> int
        C++: virtual int set_rgba_pixel_data(int, int, int, int,
            FloatArray *, int, int=0, int=0)"""
        my_args = deref_array(args, [('int', 'int', 'int', 'int', 'tuple', 'int', 'int', 'int'), ('int', 'int', 'int', 'int', 'vtkFloatArray', 'int', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.SetRGBAPixelData, *my_args)
        return ret

    def _get_shared_render_window(self):
        return wrap_vtk(self._vtk_obj.GetSharedRenderWindow())
    def _set_shared_render_window(self, arg):
        old_val = self._get_shared_render_window()
        self._wrap_call(self._vtk_obj.SetSharedRenderWindow,
                        deref_vtk(arg))
        self.trait_property_changed('shared_render_window', old_val, arg)
    shared_render_window = traits.Property(_get_shared_render_window, _set_shared_render_window, desc=\
        """
        
        """
    )

    def get_zbuffer_data(self, *args):
        """
        get_zbuffer_data(self, __a:int, __b:int, __c:int, __d:int)
            -> Pointer
        C++: virtual float *get_zbuffer_data(int, int, int, int)
        get_zbuffer_data(self, __a:int, __b:int, __c:int, __d:int,
            __e:[float, ...]) -> int
        C++: virtual int get_zbuffer_data(int, int, int, int, float *)
        get_zbuffer_data(self, __a:int, __b:int, __c:int, __d:int,
            __e:FloatArray) -> int
        C++: virtual int get_zbuffer_data(int, int, int, int,
            FloatArray *)
        Set/Get the zbuffer data from the frame buffer. (x,y) is any
        corner of the rectangle. (x2,y2) is its opposite corner on the
        diagonal.
        """
        my_args = deref_array(args, [('int', 'int', 'int', 'int'), ('int', 'int', 'int', 'int', 'tuple'), ('int', 'int', 'int', 'int', 'vtkFloatArray')])
        ret = self._wrap_call(self._vtk_obj.GetZbufferData, *my_args)
        return ret

    def set_zbuffer_data(self, *args):
        """
        set_zbuffer_data(self, __a:int, __b:int, __c:int, __d:int,
            __e:[float, ...]) -> int
        C++: virtual int set_zbuffer_data(int, int, int, int, float *)
        set_zbuffer_data(self, __a:int, __b:int, __c:int, __d:int,
            __e:FloatArray) -> int
        C++: virtual int set_zbuffer_data(int, int, int, int,
            FloatArray *)"""
        my_args = deref_array(args, [('int', 'int', 'int', 'int', 'tuple'), ('int', 'int', 'int', 'int', 'vtkFloatArray')])
        ret = self._wrap_call(self._vtk_obj.SetZbufferData, *my_args)
        return ret

    def _get_capturing_gl2ps_special_props(self):
        return self._vtk_obj.GetCapturingGL2PSSpecialProps()
    capturing_gl2ps_special_props = traits.Property(_get_capturing_gl2ps_special_props, desc=\
        """
        Returns true if the render process is capturing text actors.
        """
    )

    def get_color_buffer_sizes(self, *args):
        """
        get_color_buffer_sizes(self, __a:[int, ...]) -> int
        C++: virtual int get_color_buffer_sizes(int *)
        Get the size of the color buffer. Returns 0 if not able to
        determine otherwise sets R G B and A into buffer.
        """
        ret = self._wrap_call(self._vtk_obj.GetColorBufferSizes, *args)
        return ret

    def _get_depth_buffer_size(self):
        return self._vtk_obj.GetDepthBufferSize()
    depth_buffer_size = traits.Property(_get_depth_buffer_size, desc=\
        """
        This method should be defined by the subclass. How many bits of
        precision are there in the zbuffer?
        """
    )

    def _get_event_pending(self):
        return self._vtk_obj.GetEventPending()
    event_pending = traits.Property(_get_event_pending, desc=\
        """
        Check to see if a mouse button has been pressed.  All other
        events are ignored by this method.  Ideally, you want to abort
        the render on any event which causes the desired_update_rate to
        switch from a high-quality rate to a more interactive rate.
        """
    )

    def _get_never_rendered(self):
        return self._vtk_obj.GetNeverRendered()
    never_rendered = traits.Property(_get_never_rendered, desc=\
        """
        This flag is set if the window hasn't rendered since it was
        created
        """
    )

    def _get_number_of_devices(self):
        return self._vtk_obj.GetNumberOfDevices()
    number_of_devices = traits.Property(_get_number_of_devices, desc=\
        """
        Returns the number of devices (graphics cards) on a system. This
        may not work on all derived render windows.
        """
    )

    def _get_platform_supports_render_window_sharing(self):
        return self._vtk_obj.GetPlatformSupportsRenderWindowSharing()
    platform_supports_render_window_sharing = traits.Property(_get_platform_supports_render_window_sharing, desc=\
        """
        
        """
    )

    def _get_render_library(self):
        return self._vtk_obj.GetRenderLibrary()
    render_library = traits.Property(_get_render_library, desc=\
        """
        What rendering library has the user requested
        """
    )

    def _get_render_timer(self):
        return wrap_vtk(self._vtk_obj.GetRenderTimer())
    render_timer = traits.Property(_get_render_timer, desc=\
        """
        Get the render timer log for this window.
        """
    )

    def _get_renderers(self):
        return wrap_vtk(self._vtk_obj.GetRenderers())
    renderers = traits.Property(_get_renderers, desc=\
        """
        Return the collection of renderers in the render window.
        """
    )

    def _get_rendering_backend(self):
        return self._vtk_obj.GetRenderingBackend()
    rendering_backend = traits.Property(_get_rendering_backend, desc=\
        """
        What rendering backend has the user requested
        """
    )

    def get_zbuffer_data_at_point(self, *args):
        """
        get_zbuffer_data_at_point(self, x:int, y:int) -> float
        C++: float get_zbuffer_data_at_point(int x, int y)"""
        ret = self._wrap_call(self._vtk_obj.GetZbufferDataAtPoint, *args)
        return ret

    def add_renderer(self, *args):
        """
        add_renderer(self, __a:Renderer) -> None
        C++: virtual void add_renderer(Renderer *)
        Add a renderer to the list of renderers.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddRenderer, *my_args)
        return ret

    def alpha_bit_planes_off(self):
        """
        alpha_bit_planes_off(self) -> None
        C++: virtual void alpha_bit_planes_off()"""
        ret = self._vtk_obj.AlphaBitPlanesOff()
        return ret
        

    def alpha_bit_planes_on(self):
        """
        alpha_bit_planes_on(self) -> None
        C++: virtual void alpha_bit_planes_on()"""
        ret = self._vtk_obj.AlphaBitPlanesOn()
        return ret
        

    def capture_gl2ps_special_props(self, *args):
        """
        capture_gl2ps_special_props(self, specialProps:Collection) -> None
        C++: void capture_gl2ps_special_props(Collection *specialProps)
        The Gl2ps exporter must handle certain props in a special way
        (e.g. text). This method performs a render and captures all
        "Gl2ps-special" props in the specified collection. The collection
        will contain a PropCollection for each Renderer in
        this->get_renderers(), each containing the special props rendered
        by the corresponding renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CaptureGL2PSSpecialProps, *my_args)
        return ret

    def check_abort_status(self):
        """
        check_abort_status(self) -> int
        C++: virtual int check_abort_status()"""
        ret = self._vtk_obj.CheckAbortStatus()
        return ret
        

    def check_in_render_status(self):
        """
        check_in_render_status(self) -> int
        C++: virtual int check_in_render_status()
        Are we rendering at the moment
        """
        ret = self._vtk_obj.CheckInRenderStatus()
        return ret
        

    def clear_in_render_status(self):
        """
        clear_in_render_status(self) -> None
        C++: virtual void clear_in_render_status()
        Clear status (after an exception was thrown for example)
        """
        ret = self._vtk_obj.ClearInRenderStatus()
        return ret
        

    def copy_result_frame(self):
        """
        copy_result_frame(self) -> None
        C++: virtual void copy_result_frame()
        Performed at the end of the rendering process to generate image.
        This is typically done right before swapping buffers.
        """
        ret = self._vtk_obj.CopyResultFrame()
        return ret
        

    def end(self):
        """
        end(self) -> None
        C++: virtual void end()
        Update the system, if needed, at end of render process
        """
        ret = self._vtk_obj.End()
        return ret
        

    def finalize(self):
        """
        finalize(self) -> None
        C++: virtual void finalize()
        Finalize the rendering process.
        """
        ret = self._vtk_obj.Finalize()
        return ret
        

    def frame(self):
        """
        frame(self) -> None
        C++: virtual void frame()
        A termination method performed at the end of the rendering
        process to do things like swapping buffers (if necessary) or
        similar actions.
        """
        ret = self._vtk_obj.Frame()
        return ret
        

    def has_renderer(self, *args):
        """
        has_renderer(self, __a:Renderer) -> int
        C++: int has_renderer(Renderer *)
        Query if a renderer is in the list of renderers.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HasRenderer, *my_args)
        return ret

    def hide_cursor(self):
        """
        hide_cursor(self) -> None
        C++: virtual void hide_cursor()
        Hide or Show the mouse cursor, it is nice to be able to hide the
        default cursor if you want VTK to display a 3D cursor instead.
        Set cursor position in window (note that (0,0) is the lower left
        corner).
        """
        ret = self._vtk_obj.HideCursor()
        return ret
        

    def initialize_from_current_context(self):
        """
        initialize_from_current_context(self) -> bool
        C++: virtual bool initialize_from_current_context()
        Initialize the render window from the information associated with
        the currently activated open_gl context.
        """
        ret = self._vtk_obj.InitializeFromCurrentContext()
        return ret
        

    def is_current(self):
        """
        is_current(self) -> bool
        C++: virtual bool is_current()
        Tells if this window is the current graphics context for the
        calling thread.
        """
        ret = self._vtk_obj.IsCurrent()
        return ret
        

    def is_direct(self):
        """
        is_direct(self) -> int
        C++: virtual TypeBool is_direct()
        Is this render window using hardware acceleration? 0-false,
        1-true
        """
        ret = self._vtk_obj.IsDirect()
        return ret
        

    def is_drawable(self):
        """
        is_drawable(self) -> bool
        C++: virtual bool is_drawable()
        Test if the window has a valid drawable. This is currently only
        an issue on Mac OS X Cocoa where rendering to an invalid drawable
        results in all open_gl calls to fail with "invalid framebuffer
        operation".
        """
        ret = self._vtk_obj.IsDrawable()
        return ret
        

    def make_render_window_interactor(self):
        """
        make_render_window_interactor(self) -> RenderWindowInteractor
        C++: virtual RenderWindowInteractor *make_render_window_interactor(
            )
        Create an interactor to control renderers in this window. We need
        to know what type of interactor to create, because we might be in
        X Windows or MS Windows.
        """
        ret = wrap_vtk(self._vtk_obj.MakeRenderWindowInteractor())
        return ret
        

    def release_rgba_pixel_data(self, *args):
        """
        release_rgba_pixel_data(self, __a:[float, ...]) -> None
        C++: virtual void release_rgba_pixel_data(float *)"""
        ret = self._wrap_call(self._vtk_obj.ReleaseRGBAPixelData, *args)
        return ret

    def remove_renderer(self, *args):
        """
        remove_renderer(self, __a:Renderer) -> None
        C++: void remove_renderer(Renderer *)
        Remove a renderer from the list of renderers.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveRenderer, *my_args)
        return ret

    def report_capabilities(self):
        """
        report_capabilities(self) -> str
        C++: virtual const char *report_capabilities()
        Get report of capabilities for the render window
        """
        ret = self._vtk_obj.ReportCapabilities()
        return ret
        

    def set_cursor_position(self, *args):
        """
        set_cursor_position(self, __a:int, __b:int) -> None
        C++: virtual void set_cursor_position(int, int)"""
        ret = self._wrap_call(self._vtk_obj.SetCursorPosition, *args)
        return ret

    def set_force_make_current(self):
        """
        set_force_make_current(self) -> None
        C++: virtual void set_force_make_current()
        If called, allow make_current() to skip cache-check when called.
        make_current() reverts to original behavior of cache-checking on
        the next render.
        """
        ret = self._vtk_obj.SetForceMakeCurrent()
        return ret
        

    def set_next_window_id(self, *args):
        """
        set_next_window_id(self, __a:Pointer) -> None
        C++: virtual void set_next_window_id(void *)"""
        ret = self._wrap_call(self._vtk_obj.SetNextWindowId, *args)
        return ret

    def set_next_window_info(self, *args):
        """
        set_next_window_info(self, __a:str) -> None
        C++: virtual void set_next_window_info(const char *)"""
        ret = self._wrap_call(self._vtk_obj.SetNextWindowInfo, *args)
        return ret

    def show_cursor(self):
        """
        show_cursor(self) -> None
        C++: virtual void show_cursor()"""
        ret = self._vtk_obj.ShowCursor()
        return ret
        

    def start(self):
        """
        start(self) -> None
        C++: virtual void start()
        Start the rendering process for a frame
        """
        ret = self._vtk_obj.Start()
        return ret
        

    def stereo_midpoint(self):
        """
        stereo_midpoint(self) -> None
        C++: virtual void stereo_midpoint()
        Intermediate method performs operations required between the
        rendering of the left and right eye.
        """
        ret = self._vtk_obj.StereoMidpoint()
        return ret
        

    def stereo_render_complete(self):
        """
        stereo_render_complete(self) -> None
        C++: virtual void stereo_render_complete()
        Handles work required once both views have been rendered when
        using stereo rendering.
        """
        ret = self._vtk_obj.StereoRenderComplete()
        return ret
        

    def stereo_update(self):
        """
        stereo_update(self) -> None
        C++: virtual void stereo_update()
        Update the system, if needed, due to stereo rendering. For some
        stereo methods, subclasses might need to switch some hardware
        settings here.
        """
        ret = self._vtk_obj.StereoUpdate()
        return ret
        

    def supports_open_gl(self):
        """
        supports_open_gl(self) -> int
        C++: virtual int supports_open_gl()
        Does this render window support open_gl? 0-false, 1-true
        """
        ret = self._vtk_obj.SupportsOpenGL()
        return ret
        

    def wait_for_completion(self):
        """
        wait_for_completion(self) -> None
        C++: virtual void wait_for_completion()
        Block the thread until the actual rendering is finished(). Useful
        for measurement only.
        """
        ret = self._vtk_obj.WaitForCompletion()
        return ret
        

    def window_remap(self):
        """
        window_remap(self) -> None
        C++: virtual void window_remap()
        Remap the rendering window. This probably only works on UNIX
        right now. It is useful for changing properties that can't
        normally be changed once the window is up.
        """
        ret = self._vtk_obj.WindowRemap()
        return ret
        

    _updateable_traits_ = \
    (('borders', 'GetBorders'), ('full_screen', 'GetFullScreen'),
    ('is_picking', 'GetIsPicking'), ('line_smoothing',
    'GetLineSmoothing'), ('point_smoothing', 'GetPointSmoothing'),
    ('polygon_smoothing', 'GetPolygonSmoothing'), ('stencil_capable',
    'GetStencilCapable'), ('stereo_capable_window',
    'GetStereoCapableWindow'), ('stereo_render', 'GetStereoRender'),
    ('swap_buffers', 'GetSwapBuffers'), ('use_srgb_color_space',
    'GetUseSRGBColorSpace'), ('double_buffer', 'GetDoubleBuffer'),
    ('erase', 'GetErase'), ('off_screen_rendering',
    'GetOffScreenRendering'), ('show_window', 'GetShowWindow'),
    ('use_off_screen_buffers', 'GetUseOffScreenBuffers'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('stereo_type', 'GetStereoType'), ('abort_render', 'GetAbortRender'),
    ('alpha_bit_planes', 'GetAlphaBitPlanes'), ('anaglyph_color_mask',
    'GetAnaglyphColorMask'), ('anaglyph_color_saturation',
    'GetAnaglyphColorSaturation'), ('current_cursor', 'GetCurrentCursor'),
    ('cursor_file_name', 'GetCursorFileName'), ('desired_update_rate',
    'GetDesiredUpdateRate'), ('device_index', 'GetDeviceIndex'),
    ('in_abort_check', 'GetInAbortCheck'), ('multi_samples',
    'GetMultiSamples'), ('number_of_layers', 'GetNumberOfLayers'), ('dpi',
    'GetDPI'), ('position', 'GetPosition'), ('size', 'GetSize'),
    ('tile_scale', 'GetTileScale'), ('tile_viewport', 'GetTileViewport'),
    ('window_name', 'GetWindowName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['borders', 'debug', 'double_buffer', 'erase', 'full_screen',
    'global_warning_display', 'is_picking', 'line_smoothing',
    'off_screen_rendering', 'point_smoothing', 'polygon_smoothing',
    'show_window', 'stencil_capable', 'stereo_capable_window',
    'stereo_render', 'swap_buffers', 'use_off_screen_buffers',
    'use_srgb_color_space', 'stereo_type', 'abort_render',
    'alpha_bit_planes', 'anaglyph_color_mask',
    'anaglyph_color_saturation', 'current_cursor', 'cursor_file_name',
    'desired_update_rate', 'device_index', 'dpi', 'in_abort_check',
    'multi_samples', 'number_of_layers', 'position', 'size', 'tile_scale',
    'tile_viewport', 'window_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(RenderWindow, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit RenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['borders', 'double_buffer', 'erase', 'full_screen',
            'is_picking', 'line_smoothing', 'off_screen_rendering',
            'point_smoothing', 'polygon_smoothing', 'show_window',
            'stencil_capable', 'stereo_capable_window', 'stereo_render',
            'swap_buffers', 'use_off_screen_buffers', 'use_srgb_color_space'],
            ['stereo_type'], ['abort_render', 'alpha_bit_planes',
            'anaglyph_color_mask', 'anaglyph_color_saturation', 'current_cursor',
            'cursor_file_name', 'desired_update_rate', 'device_index', 'dpi',
            'in_abort_check', 'multi_samples', 'number_of_layers', 'position',
            'size', 'tile_scale', 'tile_viewport', 'window_name']),
            title='Edit RenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit RenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

