# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.unstructured_grid_algorithm import UnstructuredGridAlgorithm


class RemoveUnusedPoints(UnstructuredGridAlgorithm):
    """
    RemoveUnusedPoints - remove points not used by any cell.
    
    Superclass: UnstructuredGridAlgorithm
    
    RemoveUnusedPoints is a filter that removes any points that are
    not used by the cells. Currently, this filter only supports
    UnstructuredGrid.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkRemoveUnusedPoints, obj, update, **traits)
    
    generate_original_point_ids = tvtk_base.true_bool_trait(desc=\
        """
        Enable adding a `vtkoriginal_point_ids` array to the point data
        which identifies the original point index. Default is true.
        """
    )

    def _generate_original_point_ids_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateOriginalPointIds,
                        self.generate_original_point_ids_)

    original_point_ids_array_name = traits.String('vtkOriginalPointIds', enter_set=True, auto_set=False, desc=\
        """
        Choose the name to use for the original point ids array. Default
        is `vtkoriginal_point_ids`. This is used only when
        `generate_original_point_ids` is true.
        """
    )

    def _original_point_ids_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOriginalPointIdsArrayName,
                        self.original_point_ids_array_name)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)
        get_input(self) -> DataObject
        C++: DataObject *get_input()"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('generate_original_point_ids', 'GetGenerateOriginalPointIds'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('original_point_ids_array_name', 'GetOriginalPointIdsArrayName'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'generate_original_point_ids',
    'global_warning_display', 'release_data_flag',
    'original_point_ids_array_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(RemoveUnusedPoints, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit RemoveUnusedPoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['generate_original_point_ids'], [],
            ['original_point_ids_array_name']),
            title='Edit RemoveUnusedPoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit RemoveUnusedPoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

