# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.archiver import Archiver


class PythonArchiver(Archiver):
    """
    PythonArchiver - A version of Archiver that can be implemented
    in Python
    
    Superclass: Archiver
    
    PythonArchiver is an implementation of Archiver that calls a
    Python object to do the actual work. It defers the following methods
    to Python:
    - open_archive()
    - close_archive()
    - insert_into_archive()
    - Contains()
    
    Python signature of these methods is as follows:
    - open_archive(self, vtkself) : vtkself is the vtk object
    - close_archive(self, vtkself)
    - insert_into_archive(self, vtkself, relativePath, data, size)
    - Contains()
    
    @sa
    PythonArchiver
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPythonArchiver, obj, update, **traits)
    
    def set_python_object(self, *args):
        """
        set_python_object(self, obj:PyObject) -> None
        C++: void set_python_object(PyObject *obj)
        Specify the Python object to use to perform the archiving. A
        reference will be taken on the object.
        """
        ret = self._wrap_call(self._vtk_obj.SetPythonObject, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('archive_name', 'GetArchiveName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'archive_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PythonArchiver, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PythonArchiver properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['archive_name']),
            title='Edit PythonArchiver properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PythonArchiver properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

