# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.context_item import ContextItem


class PolyDataItem(ContextItem):
    """
    PolyDataItem - Filter that translate a PolyData 2D mesh into
    ContextItems.
    
    Superclass: ContextItem
    
    @warning
    The input PolyData should be a 2D mesh.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPolyDataItem, obj, update, **traits)
    
    def _get_poly_data(self):
        return wrap_vtk(self._vtk_obj.GetPolyData())
    def _set_poly_data(self, arg):
        old_val = self._get_poly_data()
        self._wrap_call(self._vtk_obj.SetPolyData,
                        deref_vtk(arg))
        self.trait_property_changed('poly_data', old_val, arg)
    poly_data = traits.Property(_get_poly_data, _set_poly_data, desc=\
        """
        Get the image of the item.
        """
    )

    def set_mapped_colors(self, *args):
        """
        set_mapped_colors(self, colors:UnsignedCharArray) -> None
        C++: void set_mapped_colors(UnsignedCharArray *colors)
        Set mapped colors. User-selected scalars are mapped to a color
        lookup table externally.
        """
        my_args = deref_array(args, [['vtkUnsignedCharArray']])
        ret = self._wrap_call(self._vtk_obj.SetMappedColors, *my_args)
        return ret

    def set_position(self, *args):
        """
        set_position(self, _arg1:float, _arg2:float) -> None
        C++: virtual void set_position(float _arg1, float _arg2)
        set_position(self, _arg:(float, float)) -> None
        C++: void set_position(const float _arg[2])
        Set the position of the bottom corner of the image.
        """
        ret = self._wrap_call(self._vtk_obj.SetPosition, *args)
        return ret

    def set_scalar_mode(self, *args):
        """
        set_scalar_mode(self, _arg:int) -> None
        C++: virtual void set_scalar_mode(int _arg)
        Set the data scalar mode.
        """
        ret = self._wrap_call(self._vtk_obj.SetScalarMode, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('opacity', 'GetOpacity'), ('interactive',
    'GetInteractive'), ('visible', 'GetVisible'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'interactive', 'opacity',
    'visible'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PolyDataItem, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PolyDataItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['interactive', 'opacity', 'visible']),
            title='Edit PolyDataItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PolyDataItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

