# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class OpenGLVertexBufferObjectGroup(Object):
    """
    OpenGLVertexBufferObjectGroup - manage vertex buffer objects
    shared within a mapper
    
    Superclass: Object
    
    This class holds onto the VBOs that a mapper is using. The basic
    operation is that during the render process the mapper may cache a
    number of dataArrays as VBOs associated with attributes. This class
    keep track of freeing VBOs no longer used by the mapper and uploading
    new data as needed.
    
    When using cache_cata_array the same array can be set each time and
    this class will not rebuild or upload unless needed.
    
    When using the append_data_array API no caching is done and the VBOs
    will be rebuilt and uploaded each time. So when appending th emapper
    need to handle checking if the VBO should be updated.
    
    Use case:
      make this an ivar of your mapper
      vbg->cache_data_array("vertexMC", DataArray);
      vbg->build_all_vb_os();
      if (vbg->get_m_time() > your VAO update time)
      {
        vbg->add_all_attributes_to_vao(...);
      }
    
    Appended Use case:
      make this an ivar of your mapper
      if (you need to update your VBOs)
      {
        vbg->clear_all_vb_os();
        vbg->append_data_array("vertexMC", DataArray1);
        vbg->append_data_array("vertexMC", DataArray2);
        vbg->append_data_array("vertexMC", DataArray3);
        vbg->build_all_vb_os();
        vbg->add_all_attributes_to_vao(...);
      }
    
    use VAO
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLVertexBufferObjectGroup, obj, update, **traits)
    
    def get_number_of_components(self, *args):
        """
        get_number_of_components(self, attribute:str) -> int
        C++: int get_number_of_components(const char *attribute)
        Returns the number of components for this attribute zero if the
        attribute does not exist
        """
        ret = self._wrap_call(self._vtk_obj.GetNumberOfComponents, *args)
        return ret

    def get_number_of_tuples(self, *args):
        """
        get_number_of_tuples(self, attribute:str) -> int
        C++: int get_number_of_tuples(const char *attribute)
        Returns the number of tuples for this attribute zero if the
        attribute does not exist
        """
        ret = self._wrap_call(self._vtk_obj.GetNumberOfTuples, *args)
        return ret

    def get_vbo(self, *args):
        """
        get_vbo(self, attribute:str) -> OpenGLVertexBufferObject
        C++: OpenGLVertexBufferObject *get_vbo(const char *attribute)
        Returns the VBO for an attribute, NULL if it is not present.
        """
        ret = self._wrap_call(self._vtk_obj.GetVBO, *args)
        return wrap_vtk(ret)

    def add_all_attributes_to_vao(self, *args):
        """
        add_all_attributes_to_vao(self, program:ShaderProgram,
            vao:OpenGLVertexArrayObject) -> None
        C++: void add_all_attributes_to_vao(ShaderProgram *program,
            OpenGLVertexArrayObject *vao)
        Attach all VBOs to their attributes
        """
        my_args = deref_array(args, [('vtkShaderProgram', 'vtkOpenGLVertexArrayObject')])
        ret = self._wrap_call(self._vtk_obj.AddAllAttributesToVAO, *my_args)
        return ret

    def append_data_array(self, *args):
        """
        append_data_array(self, attribute:str, da:DataArray,
            destType:int) -> None
        C++: void append_data_array(const char *attribute, DataArray *da,
             int destType)
        Append a data array for an attribute in the VBO Group registers
        the data array until build is called
        """
        my_args = deref_array(args, [('string', 'vtkDataArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.AppendDataArray, *my_args)
        return ret

    def array_exists(self, *args):
        """
        array_exists(self, attribute:str, da:DataArray, offset:int,
            totalOffset:int) -> bool
        C++: bool array_exists(const char *attribute, DataArray *da,
            IdType &offset, IdType &totalOffset)
        Check if the array already exists. offset is the index of the
        first vertex of the array if it exists. totalOffset is the total
        number of vertices in the appended arrays. Note that if the array
        does not exist, offset is equal to totalOffset.
        """
        my_args = deref_array(args, [('string', 'vtkDataArray', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.ArrayExists, *my_args)
        return ret

    def build_all_vb_os(self, *args):
        """
        build_all_vb_os(self, __a:OpenGLVertexBufferObjectCache) -> None
        C++: void build_all_vb_os(OpenGLVertexBufferObjectCache *)
        build_all_vb_os(self, __a:Viewport) -> None
        C++: void build_all_vb_os(Viewport *)
        using the data arrays in this group build all the VBOs, once this
        has been called the reference to the data arrays will be freed.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.BuildAllVBOs, *my_args)
        return ret

    def cache_data_array(self, *args):
        """
        cache_data_array(self, attribute:str, da:DataArray,
            cache:OpenGLVertexBufferObjectCache, destType:int) -> None
        C++: void cache_data_array(const char *attribute, DataArray *da,
            OpenGLVertexBufferObjectCache *cache, int destType)
        cache_data_array(self, attribute:str, da:DataArray,
            vp:Viewport, destType:int) -> None
        C++: void cache_data_array(const char *attribute, DataArray *da,
            Viewport *vp, int destType)
        Set the data array for an attribute in the VBO Group registers
        the data array until build is called once this is called a valid
        VBO will exist
        """
        my_args = deref_array(args, [('string', 'vtkDataArray', 'vtkOpenGLVertexBufferObjectCache', 'int'), ('string', 'vtkDataArray', 'vtkViewport', 'int')])
        ret = self._wrap_call(self._vtk_obj.CacheDataArray, *my_args)
        return ret

    def clear_all_data_arrays(self):
        """
        clear_all_data_arrays(self) -> None
        C++: void clear_all_data_arrays()
        Clear all the data arrays. Typically an internal method.
        Automatically called at the end of build_all_vb_os to prepare for
        the next set of attributes.
        """
        ret = self._vtk_obj.ClearAllDataArrays()
        return ret
        

    def clear_all_vb_os(self):
        """
        clear_all_vb_os(self) -> None
        C++: void clear_all_vb_os()
        Force all the VBOs to be freed from this group. Call this prior
        to starting appending operations. Not needed for single array
        caching.
        """
        ret = self._vtk_obj.ClearAllVBOs()
        return ret
        

    def release_graphics_resources(self, *args):
        """
        release_graphics_resources(self, __a:Window) -> None
        C++: void release_graphics_resources(Window *)
        Release any graphics resources that are being consumed by this
        mapper. The parameter window could be used to determine which
        graphic resources to release.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReleaseGraphicsResources, *my_args)
        return ret

    def remove_attribute(self, *args):
        """
        remove_attribute(self, attribute:str) -> None
        C++: void remove_attribute(const char *attribute)
        used to remove a no longer needed attribute Calling
        cache_data_array with a nullptr attribute will also work.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveAttribute, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLVertexBufferObjectGroup, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLVertexBufferObjectGroup properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit OpenGLVertexBufferObjectGroup properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLVertexBufferObjectGroup properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

