# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class OpenGLState(Object):
    """
    OpenGLState - open_gl state storage
    
    Superclass: Object
    
    OpenGLState is a class designed to keep track of the state of an
    open_gl context. Applications using VTK have so much control over the
    rendering process that is can be difficult in VTK code to know if the
    open_gl state is correct for your code. The two traditional solutions
    have been to set everything yourself and to save and restore open_gl
    state that you change. The former makes your code work, the latter
    helps prevent your code from breaking something else. The problem is
    that the former results in tons of redundant open_gl calls and the
    later is done by querying the open_gl state which can cause a pipeline
    sync/stall which is very slow.
    
    To address these issues this class stores open_gl state for commonly
    used functions. Requests made to change state to the current state
    become no-ops. Queries of state can be done by querying the state
    stored in this class without impacting the open_gl driver.
    
    This class is designed to hold all context related values and could
    just as well be considered a representation of the open_gl context.
    
    To facilitate saving state and restoring it this class contains a
    number of nested classes named Scopedthat store the state of that
    glFunction and when they go out of scope they restore it. This is
    useful when you want to change the open_gl state and then
    automatically restore it when done. They can be used as follows
    
    {
      OpenGLState *ostate = renWin->get_state();
      OpenGLState::ScopedglDepthMask dmsaved(ostate);
      // the prior state is now saved
      ...
      ostate->gldepth_mask(GL_TRUE);  // maybe change the state
      ... etc } // prior state will be restored here as it goes out of
    scope
    
    You must use this class to make state changing open_gl class otherwise
    the results will be undefined.
    
    For convenience some open_gl calls that do not impact state are also
    provided.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLState, obj, update, **traits)
    
    def get_enum_state(self, *args):
        """
        get_enum_state(self, name:int) -> bool
        C++: bool get_enum_state(unsigned int name)"""
        ret = self._wrap_call(self._vtk_obj.GetEnumState, *args)
        return ret

    def set_enum_state(self, *args):
        """
        set_enum_state(self, name:int, value:bool) -> None
        C++: void set_enum_state(unsigned int name, bool value)"""
        ret = self._wrap_call(self._vtk_obj.SetEnumState, *args)
        return ret

    def _get_texture_unit_manager(self):
        return wrap_vtk(self._vtk_obj.GetTextureUnitManager())
    def _set_texture_unit_manager(self, arg):
        old_val = self._get_texture_unit_manager()
        self._wrap_call(self._vtk_obj.SetTextureUnitManager,
                        arg)
        self.trait_property_changed('texture_unit_manager', old_val, arg)
    texture_unit_manager = traits.Property(_get_texture_unit_manager, _set_texture_unit_manager, desc=\
        """
        Returns its texture unit manager object. A new one will be
        created if one hasn't already been set up.
        """
    )

    def _get_vbo_cache(self):
        return wrap_vtk(self._vtk_obj.GetVBOCache())
    def _set_vbo_cache(self, arg):
        old_val = self._get_vbo_cache()
        self._wrap_call(self._vtk_obj.SetVBOCache,
                        deref_vtk(arg))
        self.trait_property_changed('vbo_cache', old_val, arg)
    vbo_cache = traits.Property(_get_vbo_cache, _set_vbo_cache, desc=\
        """
        
        """
    )

    def get_blend_func_state(self, *args):
        """
        get_blend_func_state(self, __a:[int, ...]) -> None
        C++: void get_blend_func_state(int *)"""
        ret = self._wrap_call(self._vtk_obj.GetBlendFuncState, *args)
        return ret

    def get_current_draw_framebuffer_state(self, *args):
        """
        get_current_draw_framebuffer_state(self, drawBinding:int,
            drawBuffer:int) -> None
        C++: void get_current_draw_framebuffer_state(
            unsigned int &drawBinding, unsigned int &drawBuffer)
        Get the current stored state of the draw buffer and binding
        """
        ret = self._wrap_call(self._vtk_obj.GetCurrentDrawFramebufferState, *args)
        return ret

    def get_default_texture_internal_format(self, *args):
        """
        get_default_texture_internal_format(self, vtktype:int,
            numComponents:int, needInteger:bool, needFloat:bool,
            needSRGB:bool) -> int
        C++: int get_default_texture_internal_format(int vtktype,
            int numComponents, bool needInteger, bool needFloat,
            bool needSRGB)
        Get a mapping of vtk data types to native texture formats for
        this window we put this on the render_window so that every texture
        does not have to build these structures themselves
        """
        ret = self._wrap_call(self._vtk_obj.GetDefaultTextureInternalFormat, *args)
        return ret

    def _get_renderer(self):
        return self._vtk_obj.GetRenderer()
    renderer = traits.Property(_get_renderer, desc=\
        """
        Return the opengl renderer for this context. Note this is the
        renderer opengl property, not a vtk renderer.
        """
    )

    def _get_shader_cache(self):
        return wrap_vtk(self._vtk_obj.GetShaderCache())
    shader_cache = traits.Property(_get_shader_cache, desc=\
        """
        
        """
    )

    def get_texture_unit_for_texture(self, *args):
        """
        get_texture_unit_for_texture(self, __a:TextureObject) -> int
        C++: int get_texture_unit_for_texture(TextureObject *)
        Get the texture unit for a given texture object
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetTextureUnitForTexture, *my_args)
        return ret

    def _get_vendor(self):
        return self._vtk_obj.GetVendor()
    vendor = traits.Property(_get_vendor, desc=\
        """
        Return the opengl vendor for this context
        """
    )

    def _get_version(self):
        return self._vtk_obj.GetVersion()
    version = traits.Property(_get_version, desc=\
        """
        Return the opengl version for this context
        """
    )

    def activate_texture(self, *args):
        """
        activate_texture(self, __a:TextureObject) -> None
        C++: void activate_texture(TextureObject *)
        Activate a texture unit for this texture
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ActivateTexture, *my_args)
        return ret

    def deactivate_texture(self, *args):
        """
        deactivate_texture(self, __a:TextureObject) -> None
        C++: void deactivate_texture(TextureObject *)
        Deactivate a previously activated texture
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeactivateTexture, *my_args)
        return ret

    def initialize(self, *args):
        """
        initialize(self, __a:OpenGLRenderWindow) -> None
        C++: void initialize(OpenGLRenderWindow *)
        Initialize open_gl context using current state
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Initialize, *my_args)
        return ret

    def pop(self):
        """
        pop(self) -> None
        C++: void pop()
        Pop the state stack to restore a previous state. At the end of
        this method open_gl state will be set to the new popped state.
        """
        ret = self._vtk_obj.Pop()
        return ret
        

    def pop_draw_framebuffer_binding(self):
        """
        pop_draw_framebuffer_binding(self) -> None
        C++: void pop_draw_framebuffer_binding()"""
        ret = self._vtk_obj.PopDrawFramebufferBinding()
        return ret
        

    def pop_framebuffer_bindings(self):
        """
        pop_framebuffer_bindings(self) -> None
        C++: void pop_framebuffer_bindings()"""
        ret = self._vtk_obj.PopFramebufferBindings()
        return ret
        

    def pop_read_framebuffer_binding(self):
        """
        pop_read_framebuffer_binding(self) -> None
        C++: void pop_read_framebuffer_binding()"""
        ret = self._vtk_obj.PopReadFramebufferBinding()
        return ret
        

    def push(self):
        """
        push(self) -> None
        C++: void push()
        Push all the recorded state onto the stack. Typically called
        after a Reset. Not generally used internally in VTK as it is
        rarely required to save more than a couple state settings within
        VTKs render process.
        """
        ret = self._vtk_obj.Push()
        return ret
        

    def push_draw_framebuffer_binding(self):
        """
        push_draw_framebuffer_binding(self) -> None
        C++: void push_draw_framebuffer_binding()"""
        ret = self._vtk_obj.PushDrawFramebufferBinding()
        return ret
        

    def push_framebuffer_bindings(self):
        """
        push_framebuffer_bindings(self) -> None
        C++: void push_framebuffer_bindings()
        Store/Restore the current framebuffer bindings and buffers.
        """
        ret = self._vtk_obj.PushFramebufferBindings()
        return ret
        

    def push_read_framebuffer_binding(self):
        """
        push_read_framebuffer_binding(self) -> None
        C++: void push_read_framebuffer_binding()"""
        ret = self._vtk_obj.PushReadFramebufferBinding()
        return ret
        

    def reset(self):
        """
        reset(self) -> None
        C++: void reset()
        Record the open_gl state into this class. Lots of get calls so
        probably a pipeline stall. This method is most useful when
        integrating VTK with something else that touches open_gl such as a
        GUI library or external open_gl code. As open_gl has a lot of state
        it is easy for VTK and external libraries to interfere with each
        other by changing that state. When extrnal code is calling VTK
        you would typically call Reset() Push() Pop() Reset will record
        the current state from open_gl. Push saves it on the stack. Pop
        pops it from the stack and reapplies it to open_gl so that the
        state is the same as when Pushed. Note that open_gl has an
        incredible amount of state. This class only handles the values
        that VTK is known to touch. If you find other values that need
        saving please feel free to report an issue or provide an MR.
        """
        ret = self._vtk_obj.Reset()
        return ret
        

    def reset_enum_state(self, *args):
        """
        reset_enum_state(self, name:int) -> None
        C++: void reset_enum_state(unsigned int name)
        convenience method to reset an enum state from current openGL
        context
        """
        ret = self._wrap_call(self._vtk_obj.ResetEnumState, *args)
        return ret

    def reset_framebuffer_bindings(self):
        """
        reset_framebuffer_bindings(self) -> None
        C++: void reset_framebuffer_bindings()"""
        ret = self._vtk_obj.ResetFramebufferBindings()
        return ret
        

    def reset_gl_active_texture(self):
        """
        reset_gl_active_texture(self) -> None
        C++: void reset_gl_active_texture()"""
        ret = self._vtk_obj.ResetGLActiveTexture()
        return ret
        

    def reset_gl_blend_equation_state(self):
        """
        reset_gl_blend_equation_state(self) -> None
        C++: void reset_gl_blend_equation_state()"""
        ret = self._vtk_obj.ResetGLBlendEquationState()
        return ret
        

    def reset_gl_blend_func_state(self):
        """
        reset_gl_blend_func_state(self) -> None
        C++: void reset_gl_blend_func_state()"""
        ret = self._vtk_obj.ResetGLBlendFuncState()
        return ret
        

    def reset_gl_clear_color_state(self):
        """
        reset_gl_clear_color_state(self) -> None
        C++: void reset_gl_clear_color_state()"""
        ret = self._vtk_obj.ResetGLClearColorState()
        return ret
        

    def reset_gl_clear_depth_state(self):
        """
        reset_gl_clear_depth_state(self) -> None
        C++: void reset_gl_clear_depth_state()"""
        ret = self._vtk_obj.ResetGLClearDepthState()
        return ret
        

    def reset_gl_color_mask_state(self):
        """
        reset_gl_color_mask_state(self) -> None
        C++: void reset_gl_color_mask_state()"""
        ret = self._vtk_obj.ResetGLColorMaskState()
        return ret
        

    def reset_gl_cull_face_state(self):
        """
        reset_gl_cull_face_state(self) -> None
        C++: void reset_gl_cull_face_state()"""
        ret = self._vtk_obj.ResetGLCullFaceState()
        return ret
        

    def reset_gl_depth_func_state(self):
        """
        reset_gl_depth_func_state(self) -> None
        C++: void reset_gl_depth_func_state()"""
        ret = self._vtk_obj.ResetGLDepthFuncState()
        return ret
        

    def reset_gl_depth_mask_state(self):
        """
        reset_gl_depth_mask_state(self) -> None
        C++: void reset_gl_depth_mask_state()"""
        ret = self._vtk_obj.ResetGLDepthMaskState()
        return ret
        

    def reset_gl_scissor_state(self):
        """
        reset_gl_scissor_state(self) -> None
        C++: void reset_gl_scissor_state()"""
        ret = self._vtk_obj.ResetGLScissorState()
        return ret
        

    def reset_gl_viewport_state(self):
        """
        reset_gl_viewport_state(self) -> None
        C++: void reset_gl_viewport_state()"""
        ret = self._vtk_obj.ResetGLViewportState()
        return ret
        

    def verify_no_active_textures(self):
        """
        verify_no_active_textures(self) -> None
        C++: void verify_no_active_textures()
        Check to make sure no textures have been left active
        """
        ret = self._vtk_obj.VerifyNoActiveTextures()
        return ret
        

    def vtk_bind_framebuffer(self, *args):
        """
        BindFramebuffer(self, target:int,
            fo:OpenGLFramebufferObject) -> None
        C++: void BindFramebuffer(unsigned int target,
            OpenGLFramebufferObject *fo)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.vtkBindFramebuffer, *my_args)
        return ret

    def vtk_draw_buffers(self, *args):
        """
        DrawBuffers(self, n:int, __b:[int, ...],
            __c:OpenGLFramebufferObject) -> None
        C++: void DrawBuffers(unsigned int n, unsigned int *,
            OpenGLFramebufferObject *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.vtkDrawBuffers, *my_args)
        return ret

    def vtk_read_buffer(self, *args):
        """
        ReadBuffer(self, __a:int, __b:OpenGLFramebufferObject)
            -> None
        C++: void ReadBuffer(unsigned int,
            OpenGLFramebufferObject *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.vtkReadBuffer, *my_args)
        return ret

    def vtkgl_active_texture(self, *args):
        """
        vtkgl_active_texture(self, __a:int) -> None
        C++: void vtkgl_active_texture(unsigned int)"""
        ret = self._wrap_call(self._vtk_obj.vtkglActiveTexture, *args)
        return ret

    def vtkgl_bind_framebuffer(self, *args):
        """
        vtkgl_bind_framebuffer(self, target:int, fb:int) -> None
        C++: void vtkgl_bind_framebuffer(unsigned int target,
            unsigned int fb)"""
        ret = self._wrap_call(self._vtk_obj.vtkglBindFramebuffer, *args)
        return ret

    def vtkgl_blend_equation(self, *args):
        """
        vtkgl_blend_equation(self, val:int) -> None
        C++: void vtkgl_blend_equation(unsigned int val)"""
        ret = self._wrap_call(self._vtk_obj.vtkglBlendEquation, *args)
        return ret

    def vtkgl_blend_equation_separate(self, *args):
        """
        vtkgl_blend_equation_separate(self, col:int, alpha:int) -> None
        C++: void vtkgl_blend_equation_separate(unsigned int col,
            unsigned int alpha)"""
        ret = self._wrap_call(self._vtk_obj.vtkglBlendEquationSeparate, *args)
        return ret

    def vtkgl_blend_func(self, *args):
        """
        vtkgl_blend_func(self, sfactor:int, dfactor:int) -> None
        C++: void vtkgl_blend_func(unsigned int sfactor,
            unsigned int dfactor)"""
        ret = self._wrap_call(self._vtk_obj.vtkglBlendFunc, *args)
        return ret

    def vtkgl_blend_func_separate(self, *args):
        """
        vtkgl_blend_func_separate(self, sfactorRGB:int, dfactorRGB:int,
            sfactorAlpha:int, dfactorAlpha:int) -> None
        C++: void vtkgl_blend_func_separate(unsigned int sfactorRGB,
            unsigned int dfactorRGB, unsigned int sfactorAlpha,
            unsigned int dfactorAlpha)"""
        ret = self._wrap_call(self._vtk_obj.vtkglBlendFuncSeparate, *args)
        return ret

    def vtkgl_blit_framebuffer(self, *args):
        """
        vtkgl_blit_framebuffer(self, __a:int, __b:int, __c:int, __d:int,
            __e:int, __f:int, __g:int, __h:int, __i:int, __j:int) -> None
        C++: void vtkgl_blit_framebuffer(int, int, int, int, int, int, int,
            int, unsigned int, unsigned int)
        Perform a blit but handle some driver bugs safely. Use this
        instead of directly calling glblit_frambuffer.
        """
        ret = self._wrap_call(self._vtk_obj.vtkglBlitFramebuffer, *args)
        return ret

    def vtkgl_clear(self, *args):
        """
        vtkgl_clear(self, mask:int) -> None
        C++: void vtkgl_clear(unsigned int mask)"""
        ret = self._wrap_call(self._vtk_obj.vtkglClear, *args)
        return ret

    def vtkgl_clear_color(self, *args):
        """
        vtkgl_clear_color(self, red:float, green:float, blue:float,
            alpha:float) -> None
        C++: void vtkgl_clear_color(float red, float green, float blue,
            float alpha)"""
        ret = self._wrap_call(self._vtk_obj.vtkglClearColor, *args)
        return ret

    def vtkgl_clear_depth(self, *args):
        """
        vtkgl_clear_depth(self, depth:float) -> None
        C++: void vtkgl_clear_depth(double depth)"""
        ret = self._wrap_call(self._vtk_obj.vtkglClearDepth, *args)
        return ret

    def vtkgl_color_mask(self, *args):
        """
        vtkgl_color_mask(self, r:int, g:int, b:int, a:int) -> None
        C++: void vtkgl_color_mask(unsigned char r, unsigned char g,
            unsigned char b, unsigned char a)"""
        ret = self._wrap_call(self._vtk_obj.vtkglColorMask, *args)
        return ret

    def vtkgl_cull_face(self, *args):
        """
        vtkgl_cull_face(self, val:int) -> None
        C++: void vtkgl_cull_face(unsigned int val)"""
        ret = self._wrap_call(self._vtk_obj.vtkglCullFace, *args)
        return ret

    def vtkgl_depth_func(self, *args):
        """
        vtkgl_depth_func(self, val:int) -> None
        C++: void vtkgl_depth_func(unsigned int val)"""
        ret = self._wrap_call(self._vtk_obj.vtkglDepthFunc, *args)
        return ret

    def vtkgl_depth_mask(self, *args):
        """
        vtkgl_depth_mask(self, flag:int) -> None
        C++: void vtkgl_depth_mask(unsigned char flag)"""
        ret = self._wrap_call(self._vtk_obj.vtkglDepthMask, *args)
        return ret

    def vtkgl_disable(self, *args):
        """
        vtkgl_disable(self, cap:int) -> None
        C++: void vtkgl_disable(unsigned int cap)"""
        ret = self._wrap_call(self._vtk_obj.vtkglDisable, *args)
        return ret

    def vtkgl_draw_buffer(self, *args):
        """
        vtkgl_draw_buffer(self, __a:int) -> None
        C++: void vtkgl_draw_buffer(unsigned int)"""
        ret = self._wrap_call(self._vtk_obj.vtkglDrawBuffer, *args)
        return ret

    def vtkgl_draw_buffers(self, *args):
        """
        vtkgl_draw_buffers(self, n:int, __b:[int, ...]) -> None
        C++: void vtkgl_draw_buffers(unsigned int n, unsigned int *)"""
        ret = self._wrap_call(self._vtk_obj.vtkglDrawBuffers, *args)
        return ret

    def vtkgl_enable(self, *args):
        """
        vtkgl_enable(self, cap:int) -> None
        C++: void vtkgl_enable(unsigned int cap)"""
        ret = self._wrap_call(self._vtk_obj.vtkglEnable, *args)
        return ret

    def vtkgl_get_booleanv(self, *args):
        """
        vtkgl_get_booleanv(self, pname:int, params:[int, ...]) -> None
        C++: void vtkgl_get_booleanv(unsigned int pname,
            unsigned char *params)"""
        ret = self._wrap_call(self._vtk_obj.vtkglGetBooleanv, *args)
        return ret

    def vtkgl_get_doublev(self, *args):
        """
        vtkgl_get_doublev(self, pname:int, params:[float, ...]) -> None
        C++: void vtkgl_get_doublev(unsigned int pname, double *params)"""
        ret = self._wrap_call(self._vtk_obj.vtkglGetDoublev, *args)
        return ret

    def vtkgl_get_floatv(self, *args):
        """
        vtkgl_get_floatv(self, pname:int, params:[float, ...]) -> None
        C++: void vtkgl_get_floatv(unsigned int pname, float *params)"""
        ret = self._wrap_call(self._vtk_obj.vtkglGetFloatv, *args)
        return ret

    def vtkgl_get_integerv(self, *args):
        """
        vtkgl_get_integerv(self, pname:int, params:[int, ...]) -> None
        C++: void vtkgl_get_integerv(unsigned int pname, int *params)"""
        ret = self._wrap_call(self._vtk_obj.vtkglGetIntegerv, *args)
        return ret

    def vtkgl_line_width(self, *args):
        """
        vtkgl_line_width(self, __a:float) -> None
        C++: void vtkgl_line_width(float)"""
        ret = self._wrap_call(self._vtk_obj.vtkglLineWidth, *args)
        return ret

    def vtkgl_pixel_storei(self, *args):
        """
        vtkgl_pixel_storei(self, __a:int, __b:int) -> None
        C++: void vtkgl_pixel_storei(unsigned int, int)"""
        ret = self._wrap_call(self._vtk_obj.vtkglPixelStorei, *args)
        return ret

    def vtkgl_point_size(self, *args):
        """
        vtkgl_point_size(self, __a:float) -> None
        C++: void vtkgl_point_size(float)"""
        ret = self._wrap_call(self._vtk_obj.vtkglPointSize, *args)
        return ret

    def vtkgl_read_buffer(self, *args):
        """
        vtkgl_read_buffer(self, __a:int) -> None
        C++: void vtkgl_read_buffer(unsigned int)"""
        ret = self._wrap_call(self._vtk_obj.vtkglReadBuffer, *args)
        return ret

    def vtkgl_scissor(self, *args):
        """
        vtkgl_scissor(self, x:int, y:int, width:int, height:int) -> None
        C++: void vtkgl_scissor(int x, int y, int width, int height)"""
        ret = self._wrap_call(self._vtk_obj.vtkglScissor, *args)
        return ret

    def vtkgl_stencil_func(self, *args):
        """
        vtkgl_stencil_func(self, func:int, ref:int, mask:int) -> None
        C++: void vtkgl_stencil_func(unsigned int func, int ref,
            unsigned int mask)"""
        ret = self._wrap_call(self._vtk_obj.vtkglStencilFunc, *args)
        return ret

    def vtkgl_stencil_func_separate(self, *args):
        """
        vtkgl_stencil_func_separate(self, face:int, func:int, ref:int,
            mask:int) -> None
        C++: void vtkgl_stencil_func_separate(unsigned int face,
            unsigned int func, int ref, unsigned int mask)"""
        ret = self._wrap_call(self._vtk_obj.vtkglStencilFuncSeparate, *args)
        return ret

    def vtkgl_stencil_mask(self, *args):
        """
        vtkgl_stencil_mask(self, mask:int) -> None
        C++: void vtkgl_stencil_mask(unsigned int mask)"""
        ret = self._wrap_call(self._vtk_obj.vtkglStencilMask, *args)
        return ret

    def vtkgl_stencil_mask_separate(self, *args):
        """
        vtkgl_stencil_mask_separate(self, face:int, mask:int) -> None
        C++: void vtkgl_stencil_mask_separate(unsigned int face,
            unsigned int mask)"""
        ret = self._wrap_call(self._vtk_obj.vtkglStencilMaskSeparate, *args)
        return ret

    def vtkgl_stencil_op(self, *args):
        """
        vtkgl_stencil_op(self, sfail:int, dpfail:int, dppass:int) -> None
        C++: void vtkgl_stencil_op(unsigned int sfail, unsigned int dpfail,
            unsigned int dppass)"""
        ret = self._wrap_call(self._vtk_obj.vtkglStencilOp, *args)
        return ret

    def vtkgl_stencil_op_separate(self, *args):
        """
        vtkgl_stencil_op_separate(self, face:int, sfail:int, dpfail:int,
            dppass:int) -> None
        C++: void vtkgl_stencil_op_separate(unsigned int face,
            unsigned int sfail, unsigned int dpfail, unsigned int dppass)"""
        ret = self._wrap_call(self._vtk_obj.vtkglStencilOpSeparate, *args)
        return ret

    def vtkgl_viewport(self, *args):
        """
        vtkgl_viewport(self, x:int, y:int, width:int, height:int) -> None
        C++: void vtkgl_viewport(int x, int y, int width, int height)"""
        ret = self._wrap_call(self._vtk_obj.vtkglViewport, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLState, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLState properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit OpenGLState properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLState properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

