# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.open_gl_poly_data_mapper import OpenGLPolyDataMapper


class OpenGLSphereMapper(OpenGLPolyDataMapper):
    """
    OpenGLSphereMapper - draw spheres using imposters
    
    Superclass: OpenGLPolyDataMapper
    
    An open_gl mapper that uses imposters to draw spheres. Supports
    transparency and picking as well.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLSphereMapper, obj, update, **traits)
    
    radius = traits.Float(0.30000001192092896, enter_set=True, auto_set=False, desc=\
        """
        This value will be used for the radius is the scale array is not
        provided.
        """
    )

    def _radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRadius,
                        self.radius)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Get the input as a DataSet.  This method is overridden in the
        specialized mapper classes to return more specific data types.
        """
    )

    def set_scale_array(self, *args):
        """
        set_scale_array(self, _arg:str) -> None
        C++: virtual void set_scale_array(const char *_arg)
        Convenience method to set the array to scale with.
        """
        ret = self._wrap_call(self._vtk_obj.SetScaleArray, *args)
        return ret

    _updateable_traits_ = \
    (('pause_shift_scale', 'GetPauseShiftScale'), ('seamless_u',
    'GetSeamlessU'), ('seamless_v', 'GetSeamlessV'),
    ('interpolate_scalars_before_mapping',
    'GetInterpolateScalarsBeforeMapping'), ('scalar_visibility',
    'GetScalarVisibility'), ('static', 'GetStatic'),
    ('use_lookup_table_scalar_range', 'GetUseLookupTableScalarRange'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('color_mode',
    'GetColorMode'), ('resolve_coincident_topology',
    'GetResolveCoincidentTopology'), ('scalar_mode', 'GetScalarMode'),
    ('radius', 'GetRadius'), ('cell_id_array_name', 'GetCellIdArrayName'),
    ('composite_id_array_name', 'GetCompositeIdArrayName'),
    ('fragment_shader_code', 'GetFragmentShaderCode'),
    ('geometry_shader_code', 'GetGeometryShaderCode'),
    ('point_id_array_name', 'GetPointIdArrayName'),
    ('populate_selection_settings', 'GetPopulateSelectionSettings'),
    ('process_id_array_name', 'GetProcessIdArrayName'),
    ('vbo_shift_scale_method', 'GetVBOShiftScaleMethod'),
    ('vertex_shader_code', 'GetVertexShaderCode'), ('ghost_level',
    'GetGhostLevel'), ('number_of_pieces', 'GetNumberOfPieces'),
    ('number_of_sub_pieces', 'GetNumberOfSubPieces'), ('piece',
    'GetPiece'), ('array_access_mode', 'GetArrayAccessMode'),
    ('array_component', 'GetArrayComponent'), ('array_id', 'GetArrayId'),
    ('array_name', 'GetArrayName'), ('field_data_tuple_id',
    'GetFieldDataTupleId'), ('render_time', 'GetRenderTime'),
    ('resolve_coincident_topology_polygon_offset_faces',
    'GetResolveCoincidentTopologyPolygonOffsetFaces'),
    ('resolve_coincident_topology_z_shift',
    'GetResolveCoincidentTopologyZShift'), ('scalar_range',
    'GetScalarRange'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'interpolate_scalars_before_mapping', 'pause_shift_scale',
    'release_data_flag', 'scalar_visibility', 'seamless_u', 'seamless_v',
    'static', 'use_lookup_table_scalar_range', 'color_mode',
    'resolve_coincident_topology', 'scalar_mode', 'array_access_mode',
    'array_component', 'array_id', 'array_name', 'cell_id_array_name',
    'composite_id_array_name', 'field_data_tuple_id',
    'fragment_shader_code', 'geometry_shader_code', 'ghost_level',
    'number_of_pieces', 'number_of_sub_pieces', 'piece',
    'point_id_array_name', 'populate_selection_settings',
    'process_id_array_name', 'progress_text', 'radius', 'render_time',
    'resolve_coincident_topology_polygon_offset_faces',
    'resolve_coincident_topology_z_shift', 'scalar_range',
    'vbo_shift_scale_method', 'vertex_shader_code'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLSphereMapper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLSphereMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['interpolate_scalars_before_mapping', 'pause_shift_scale',
            'scalar_visibility', 'seamless_u', 'seamless_v', 'static',
            'use_lookup_table_scalar_range'], ['color_mode',
            'resolve_coincident_topology', 'scalar_mode'], ['array_access_mode',
            'array_component', 'array_id', 'array_name', 'cell_id_array_name',
            'composite_id_array_name', 'field_data_tuple_id',
            'fragment_shader_code', 'geometry_shader_code', 'ghost_level',
            'number_of_pieces', 'number_of_sub_pieces', 'piece',
            'point_id_array_name', 'populate_selection_settings',
            'process_id_array_name', 'radius', 'render_time',
            'resolve_coincident_topology_polygon_offset_faces',
            'resolve_coincident_topology_z_shift', 'scalar_range',
            'vbo_shift_scale_method', 'vertex_shader_code']),
            title='Edit OpenGLSphereMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLSphereMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

