# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class OpenGLShaderCache(Object):
    """
    OpenGLShaderCache - manage Shader Programs within a context
    
    Superclass: Object
    
    OpenGLShaderCache manages shader program compilation and binding
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLShaderCache, obj, update, **traits)
    
    def _get_last_shader_bound(self):
        return wrap_vtk(self._vtk_obj.GetLastShaderBound())
    last_shader_bound = traits.Property(_get_last_shader_bound, desc=\
        """
        
        """
    )

    def clear_last_shader_bound(self):
        """
        clear_last_shader_bound(self) -> None
        C++: virtual void clear_last_shader_bound()
        Get/Clear the last Shader bound, called by shaders as they
        release their graphics resources
        """
        ret = self._vtk_obj.ClearLastShaderBound()
        return ret
        

    def ready_shader_program(self, *args):
        """
        ready_shader_program(self, vertexCode:str, fragmentCode:str,
            geometryCode:str, cap:TransformFeedback=...)
            -> ShaderProgram
        C++: virtual ShaderProgram *ready_shader_program(
            const char *vertexCode, const char *fragmentCode,
            const char *geometryCode, TransformFeedback *cap=nullptr)
        ready_shader_program(self, shader:ShaderProgram,
            cap:TransformFeedback=...) -> ShaderProgram
        C++: virtual ShaderProgram *ready_shader_program(
            ShaderProgram *shader, TransformFeedback *cap=nullptr)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReadyShaderProgram, *my_args)
        return wrap_vtk(ret)

    def release_current_shader(self):
        """
        release_current_shader(self) -> None
        C++: void release_current_shader()
        Release the current shader.  Basically go back to having no
        shaders loaded.  This is useful for old legacy code that relies
        on no shaders being loaded.
        """
        ret = self._vtk_obj.ReleaseCurrentShader()
        return ret
        

    def release_graphics_resources(self, *args):
        """
        release_graphics_resources(self, win:Window) -> None
        C++: virtual void release_graphics_resources(Window *win)
        Free up any resources being used by the provided shader
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReleaseGraphicsResources, *my_args)
        return ret

    def set_elapsed_time(self, *args):
        """
        set_elapsed_time(self, val:float) -> None
        C++: void set_elapsed_time(float val)"""
        ret = self._wrap_call(self._vtk_obj.SetElapsedTime, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLShaderCache, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLShaderCache properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit OpenGLShaderCache properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLShaderCache properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

