# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.multi_block_data_set_algorithm import MultiBlockDataSetAlgorithm


class OpenFOAMReader(MultiBlockDataSetAlgorithm):
    """
    OpenFOAMReader - reads a dataset in open_foam format
    
    Superclass: MultiBlockDataSetAlgorithm
    
    OpenFOAMReader creates a multiblock dataset. It reads mesh
    information and time dependent data.  The polyMesh folders contain
    mesh information. The time folders contain transient data for the
    cells. Each folder can contain any number of data files.
    
    @par Thanks: Thanks to Terry Jordan (terry.jordan@sa.netl.doe.gov) of
    SAIC at the National Energy Technology Laboratory who originally
    developed this class.
    
    Takuya Oshima of Niigata University, Japan
    (oshima@eng.niigata-u.ac.jp) provided the major bulk of improvements
    (rewrite) that made the reader truly functional and icluded the
    following features: Token-based foam_file format lexer/parser,
    performance/stability/compatibility enhancements, gzipped file
    support, lagrangian field support, variable timestep support, builtin
    cell-to-point filter, pointField support, polyhedron decomposition
    support, multiregion support, parallelization support for decomposed
    cases in conjunction with POpenFOAMReader etc.
    
    Philippose Rajan (sarith@rocketmail.com) added GUI-based selection of
    mesh regions and fields available in the case, minor bug fixes,
    strict memory allocation checks,
    
    Mark Olesen (open_cfd Ltd.) www.openfoam.com has provided various
    bugfixes, improvements, cleanup
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenFOAMReader, obj, update, **traits)
    
    add_dimensions_to_array_names = tvtk_base.false_bool_trait(desc=\
        """
        Add dimensions to array names
        """
    )

    def _add_dimensions_to_array_names_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAddDimensionsToArrayNames,
                        self.add_dimensions_to_array_names_)

    cache_mesh = tvtk_base.true_bool_trait(desc=\
        """
        Set/Get whether mesh is to be cached.
        """
    )

    def _cache_mesh_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCacheMesh,
                        self.cache_mesh_)

    copy_data_to_cell_zones = tvtk_base.true_bool_trait(desc=\
        """
        
        """
    )

    def _copy_data_to_cell_zones_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCopyDataToCellZones,
                        self.copy_data_to_cell_zones_)

    create_cell_to_point = tvtk_base.true_bool_trait(desc=\
        """
        Set/Get whether to create cell-to-point translated data for
        cell-type data
        """
    )

    def _create_cell_to_point_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCreateCellToPoint,
                        self.create_cell_to_point_)

    decompose_polyhedra = tvtk_base.false_bool_trait(desc=\
        """
        Set/Get whether polyhedra are to be decomposed.
        """
    )

    def _decompose_polyhedra_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDecomposePolyhedra,
                        self.decompose_polyhedra_)

    list_time_steps_by_control_dict = tvtk_base.false_bool_trait(desc=\
        """
        Determine if time directories are to be listed according to
        controlDict
        """
    )

    def _list_time_steps_by_control_dict_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetListTimeStepsByControlDict,
                        self.list_time_steps_by_control_dict_)

    positions_is_in13_format = tvtk_base.true_bool_trait(desc=\
        """
        Set/Get whether the lagrangian/positions have additional data or
        not. For historical reasons, positions_is_in13_format is used to
        denote that the positions only have x,y,z value and the cell of
        the enclosing cell. In open_foam 1.4-2.4, positions included facei
        and stepFraction information.
        """
    )

    def _positions_is_in13_format_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPositionsIsIn13Format,
                        self.positions_is_in13_format_)

    read_zones = tvtk_base.false_bool_trait(desc=\
        """
        Set/Get whether zones will be read.
        """
    )

    def _read_zones_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReadZones,
                        self.read_zones_)

    skip_zero_time = tvtk_base.false_bool_trait(desc=\
        """
        Ignore 0/ time directory, which is normally missing Lagrangian
        fields and may have many dictionary functionality that we cannot
        easily handle.
        """
    )

    def _skip_zero_time_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSkipZeroTime,
                        self.skip_zero_time_)

    use64_bit_floats = tvtk_base.true_bool_trait(desc=\
        """
        If true, floats are expected to be 64-bit, rather than 32. Note
        that FloatArrays may still be used in the output if this is
        true. This flag is only used to ensure that binary data is
        correctly parsed.
        """
    )

    def _use64_bit_floats_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUse64BitFloats,
                        self.use64_bit_floats_)

    use64_bit_labels = tvtk_base.false_bool_trait(desc=\
        """
        If true, labels are expected to be 64-bit, rather than 32.
        """
    )

    def _use64_bit_labels_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUse64BitLabels,
                        self.use64_bit_labels_)

    def get_cell_array_status(self, *args):
        """
        get_cell_array_status(self, name:str) -> int
        C++: int get_cell_array_status(const char *name)
        Get/Set whether the cell array with the given name is to be read.
        """
        ret = self._wrap_call(self._vtk_obj.GetCellArrayStatus, *args)
        return ret

    def set_cell_array_status(self, *args):
        """
        set_cell_array_status(self, name:str, status:int) -> None
        C++: void set_cell_array_status(const char *name, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetCellArrayStatus, *args)
        return ret

    file_name = tvtk_base.vtk_file_name("", desc=\
        """
        Set/Get the filename.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    def get_lagrangian_array_status(self, *args):
        """
        get_lagrangian_array_status(self, name:str) -> int
        C++: int get_lagrangian_array_status(const char *name)
        Get/Set whether the Lagrangian array with the given name is to be
        read.
        """
        ret = self._wrap_call(self._vtk_obj.GetLagrangianArrayStatus, *args)
        return ret

    def set_lagrangian_array_status(self, *args):
        """
        set_lagrangian_array_status(self, name:str, status:int) -> None
        C++: void set_lagrangian_array_status(const char *name, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetLagrangianArrayStatus, *args)
        return ret

    def get_patch_array_status(self, *args):
        """
        get_patch_array_status(self, name:str) -> int
        C++: int get_patch_array_status(const char *name)
        Get/Set whether the Patch with the given name is to be read.
        """
        ret = self._wrap_call(self._vtk_obj.GetPatchArrayStatus, *args)
        return ret

    def set_patch_array_status(self, *args):
        """
        set_patch_array_status(self, name:str, status:int) -> None
        C++: void set_patch_array_status(const char *name, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetPatchArrayStatus, *args)
        return ret

    def get_point_array_status(self, *args):
        """
        get_point_array_status(self, name:str) -> int
        C++: int get_point_array_status(const char *name)
        Get/Set whether the point array with the given name is to be
        read.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointArrayStatus, *args)
        return ret

    def set_point_array_status(self, *args):
        """
        set_point_array_status(self, name:str, status:int) -> None
        C++: void set_point_array_status(const char *name, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetPointArrayStatus, *args)
        return ret

    time_value = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _time_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTimeValue,
                        self.time_value)

    def get_cell_array_name(self, *args):
        """
        get_cell_array_name(self, index:int) -> str
        C++: const char *get_cell_array_name(int index)
        Get the name of the cell array with the given index in the input.
        """
        ret = self._wrap_call(self._vtk_obj.GetCellArrayName, *args)
        return ret

    def get_lagrangian_array_name(self, *args):
        """
        get_lagrangian_array_name(self, index:int) -> str
        C++: const char *get_lagrangian_array_name(int index)
        Get the name of the Lagrangian array with the given index in the
        input.
        """
        ret = self._wrap_call(self._vtk_obj.GetLagrangianArrayName, *args)
        return ret

    def _get_number_of_cell_arrays(self):
        return self._vtk_obj.GetNumberOfCellArrays()
    number_of_cell_arrays = traits.Property(_get_number_of_cell_arrays, desc=\
        """
        Get the number of cell arrays available in the input.
        """
    )

    def _get_number_of_lagrangian_arrays(self):
        return self._vtk_obj.GetNumberOfLagrangianArrays()
    number_of_lagrangian_arrays = traits.Property(_get_number_of_lagrangian_arrays, desc=\
        """
        Get the number of Lagrangian arrays available in the input.
        """
    )

    def _get_number_of_patch_arrays(self):
        return self._vtk_obj.GetNumberOfPatchArrays()
    number_of_patch_arrays = traits.Property(_get_number_of_patch_arrays, desc=\
        """
        Get the number of Patches (including Internal Mesh) available in
        the input.
        """
    )

    def _get_number_of_point_arrays(self):
        return self._vtk_obj.GetNumberOfPointArrays()
    number_of_point_arrays = traits.Property(_get_number_of_point_arrays, desc=\
        """
        Get the number of point arrays available in the input.
        """
    )

    def get_patch_array_name(self, *args):
        """
        get_patch_array_name(self, index:int) -> str
        C++: const char *get_patch_array_name(int index)
        Get the name of the Patch with the given index in the input.
        """
        ret = self._wrap_call(self._vtk_obj.GetPatchArrayName, *args)
        return ret

    def get_point_array_name(self, *args):
        """
        get_point_array_name(self, index:int) -> str
        C++: const char *get_point_array_name(int index)
        Get the name of the point array with the given index in the
        input.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointArrayName, *args)
        return ret

    def _get_time_names(self):
        return wrap_vtk(self._vtk_obj.GetTimeNames())
    time_names = traits.Property(_get_time_names, desc=\
        """
        
        """
    )

    def _get_time_values(self):
        return wrap_vtk(self._vtk_obj.GetTimeValues())
    time_values = traits.Property(_get_time_values, desc=\
        """
        
        """
    )

    def can_read_file(self, *args):
        """
        can_read_file(self, __a:str) -> int
        C++: int can_read_file(const char *)
        Determine if the file can be read with this reader.
        """
        ret = self._wrap_call(self._vtk_obj.CanReadFile, *args)
        return ret

    def disable_all_cell_arrays(self):
        """
        disable_all_cell_arrays(self) -> None
        C++: void disable_all_cell_arrays()
        Turn on/off all cell arrays.
        """
        ret = self._vtk_obj.DisableAllCellArrays()
        return ret
        

    def disable_all_lagrangian_arrays(self):
        """
        disable_all_lagrangian_arrays(self) -> None
        C++: void disable_all_lagrangian_arrays()
        Turn on/off all Lagrangian arrays.
        """
        ret = self._vtk_obj.DisableAllLagrangianArrays()
        return ret
        

    def disable_all_patch_arrays(self):
        """
        disable_all_patch_arrays(self) -> None
        C++: void disable_all_patch_arrays()
        Turn on/off all Patches including the Internal Mesh.
        """
        ret = self._vtk_obj.DisableAllPatchArrays()
        return ret
        

    def disable_all_point_arrays(self):
        """
        disable_all_point_arrays(self) -> None
        C++: void disable_all_point_arrays()
        Turn on/off all point arrays.
        """
        ret = self._vtk_obj.DisableAllPointArrays()
        return ret
        

    def enable_all_cell_arrays(self):
        """
        enable_all_cell_arrays(self) -> None
        C++: void enable_all_cell_arrays()"""
        ret = self._vtk_obj.EnableAllCellArrays()
        return ret
        

    def enable_all_lagrangian_arrays(self):
        """
        enable_all_lagrangian_arrays(self) -> None
        C++: void enable_all_lagrangian_arrays()"""
        ret = self._vtk_obj.EnableAllLagrangianArrays()
        return ret
        

    def enable_all_patch_arrays(self):
        """
        enable_all_patch_arrays(self) -> None
        C++: void enable_all_patch_arrays()"""
        ret = self._vtk_obj.EnableAllPatchArrays()
        return ret
        

    def enable_all_point_arrays(self):
        """
        enable_all_point_arrays(self) -> None
        C++: void enable_all_point_arrays()"""
        ret = self._vtk_obj.EnableAllPointArrays()
        return ret
        

    def make_information_vector(self, *args):
        """
        make_information_vector(self, __a:InformationVector,
            procDirName:str, timeNames:StringArray=...,
            timeValues:DoubleArray=...) -> int
        C++: int make_information_vector(InformationVector *,
            const StdString &procDirName,
            StringArray *timeNames=nullptr,
            DoubleArray *timeValues=nullptr)"""
        my_args = deref_array(args, [('vtkInformationVector', 'string', 'vtkStringArray', 'vtkDoubleArray')])
        ret = self._wrap_call(self._vtk_obj.MakeInformationVector, *my_args)
        return ret

    def make_meta_data_at_time_step(self, *args):
        """
        make_meta_data_at_time_step(self, __a:bool) -> int
        C++: int make_meta_data_at_time_step(const bool)"""
        ret = self._wrap_call(self._vtk_obj.MakeMetaDataAtTimeStep, *args)
        return ret

    def set_parent(self, *args):
        """
        set_parent(self, parent:OpenFOAMReader) -> None
        C++: void set_parent(OpenFOAMReader *parent)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetParent, *my_args)
        return ret

    def set_refresh(self):
        """
        set_refresh(self) -> None
        C++: void set_refresh()"""
        ret = self._vtk_obj.SetRefresh()
        return ret
        

    _updateable_traits_ = \
    (('add_dimensions_to_array_names', 'GetAddDimensionsToArrayNames'),
    ('cache_mesh', 'GetCacheMesh'), ('copy_data_to_cell_zones',
    'GetCopyDataToCellZones'), ('create_cell_to_point',
    'GetCreateCellToPoint'), ('decompose_polyhedra',
    'GetDecomposePolyhedra'), ('list_time_steps_by_control_dict',
    'GetListTimeStepsByControlDict'), ('positions_is_in13_format',
    'GetPositionsIsIn13Format'), ('read_zones', 'GetReadZones'),
    ('skip_zero_time', 'GetSkipZeroTime'), ('use64_bit_floats',
    'GetUse64BitFloats'), ('use64_bit_labels', 'GetUse64BitLabels'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('file_name',
    'GetFileName'), ('time_value', 'GetTimeValue'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'add_dimensions_to_array_names', 'cache_mesh',
    'copy_data_to_cell_zones', 'create_cell_to_point', 'debug',
    'decompose_polyhedra', 'global_warning_display',
    'list_time_steps_by_control_dict', 'positions_is_in13_format',
    'read_zones', 'release_data_flag', 'skip_zero_time',
    'use64_bit_floats', 'use64_bit_labels', 'file_name', 'progress_text',
    'time_value'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenFOAMReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenFOAMReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['add_dimensions_to_array_names', 'cache_mesh',
            'copy_data_to_cell_zones', 'create_cell_to_point',
            'decompose_polyhedra', 'list_time_steps_by_control_dict',
            'positions_is_in13_format', 'read_zones', 'skip_zero_time',
            'use64_bit_floats', 'use64_bit_labels'], [], ['file_name',
            'time_value']),
            title='Edit OpenFOAMReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenFOAMReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

