# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class ObjectFactory(Object):
    """
    ObjectFactory - abstract base class for ObjectFactories
    
    Superclass: Object
    
    ObjectFactory is used to create vtk objects.   The base class
    ObjectFactory contains a static method create_instance which is
    used to create vtk objects from the list of registered
    ObjectFactory sub-classes.   The first time create_instance is
    called, all dll's or shared libraries in the environment variable
    VTK_AUTOLOAD_PATH are loaded into the current process.   The C
    functions Load, and GetFactoryVersion are called on each dll. 
    To implement these functions in a shared library or dll, use the
    macro: VTK_FACTORY_INTERFACE_IMPLEMENT. VTK_AUTOLOAD_PATH is an
    environment variable containing a colon separated (semi-colon on
    win32) list of paths.
    
    The ObjectFactory can be use to override the creation of any
    object in VTK with a sub-class of that object.  The factories can be
    registered either at run time with the VTK_AUTOLOAD_PATH, or at
    compile time with the ObjectFactory::RegisterFactory method.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkObjectFactory, obj, update, **traits)
    
    def get_enable_flag(self, *args):
        """
        get_enable_flag(self, index:int) -> int
        C++: virtual TypeBool get_enable_flag(int index)
        get_enable_flag(self, className:str, subclassName:str) -> int
        C++: virtual TypeBool get_enable_flag(const char *className,
            const char *subclassName)
        Return the enable flag for the class at the given index.
        """
        ret = self._wrap_call(self._vtk_obj.GetEnableFlag, *args)
        return ret

    def set_enable_flag(self, *args):
        """
        set_enable_flag(self, flag:int, className:str, subclassName:str)
            -> None
        C++: virtual void set_enable_flag(TypeBool flag,
            const char *className, const char *subclassName)
        Set and Get the Enable flag for the specific override of
        className. if subclassName is null, then it is ignored.
        """
        ret = self._wrap_call(self._vtk_obj.SetEnableFlag, *args)
        return ret

    def get_class_override_name(self, *args):
        """
        get_class_override_name(self, index:int) -> str
        C++: virtual const char *get_class_override_name(int index)
        Return the name of a class override at the given index.
        """
        ret = self._wrap_call(self._vtk_obj.GetClassOverrideName, *args)
        return ret

    def get_class_override_with_name(self, *args):
        """
        get_class_override_with_name(self, index:int) -> str
        C++: virtual const char *get_class_override_with_name(int index)
        Return the name of the class that will override the class at the
        given index
        """
        ret = self._wrap_call(self._vtk_obj.GetClassOverrideWithName, *args)
        return ret

    def _get_description(self):
        return self._vtk_obj.GetDescription()
    description = traits.Property(_get_description, desc=\
        """
        Return a descriptive string describing the factory.
        """
    )

    def _get_library_path(self):
        return self._vtk_obj.GetLibraryPath()
    library_path = traits.Property(_get_library_path, desc=\
        """
        This returns the path to a dynamically loaded factory.
        """
    )

    def _get_number_of_overrides(self):
        return self._vtk_obj.GetNumberOfOverrides()
    number_of_overrides = traits.Property(_get_number_of_overrides, desc=\
        """
        Return number of overrides this factory can create.
        """
    )

    def get_override_description(self, *args):
        """
        get_override_description(self, index:int) -> str
        C++: virtual const char *get_override_description(int index)
        Return the description for a the class override at the given
        index.
        """
        ret = self._wrap_call(self._vtk_obj.GetOverrideDescription, *args)
        return ret

    def get_override_information(self, *args):
        """
        get_override_information(name:str,
            __b:OverrideInformationCollection) -> None
        C++: static void get_override_information(const char *name,
            OverrideInformationCollection *)
        Fill the given collection with all the overrides for the class
        with the given name.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetOverrideInformation, *my_args)
        return ret

    def _get_registered_factories(self):
        return wrap_vtk(self._vtk_obj.GetRegisteredFactories())
    registered_factories = traits.Property(_get_registered_factories, desc=\
        """
        Return the list of all registered factories.  This is NOT a copy,
        do not remove items from this list!
        """
    )

    def _get_vtk_source_version(self):
        return self._vtk_obj.GetVTKSourceVersion()
    vtk_source_version = traits.Property(_get_vtk_source_version, desc=\
        """
        All sub-classes of ObjectFactory should must return the
        version of VTK they were built with.  This should be implemented
        with the macro VTK_SOURCE_VERSION and NOT a call to
        Version::GetVTKSourceVersion. As the version needs to be
        compiled into the file as a string constant. This is critical to
        determine possible incompatible dynamic factory loads.
        """
    )

    def create_all_instance(self, *args):
        """
        create_all_instance(vtkclassname:str, retList:Collection) -> None
        C++: static void create_all_instance(const char *vtkclassname,
            Collection *retList)
        Create all possible instances of the named vtk object. Each
        registered ObjectFactory will be asked, and the result will be
        stored in the user allocated Collection passed in to the
        function.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CreateAllInstance, *my_args)
        return ret

    def create_instance(self, *args):
        """
        create_instance(vtkclassname:str, isAbstract:bool=False)
            -> Object
        C++: static Object *create_instance(const char *vtkclassname,
            bool isAbstract=false)
        Create and return an instance of the named vtk object. Each
        loaded ObjectFactory will be asked in the order the factory
        was in the VTK_AUTOLOAD_PATH.  After the first factory returns
        the object no other factories are asked. isAbstract is no longer
        used. This method calls ObjectBase::InitializeObjectBase() on
        the instance when the return value is non-nullptr.
        """
        ret = self._wrap_call(self._vtk_obj.CreateInstance, *args)
        return ret

    def disable(self, *args):
        """
        disable(self, className:str) -> None
        C++: virtual void disable(const char *className)
        Set all enable flags for the given class to 0.  This will mean
        that the factory will stop producing class with the given name.
        """
        ret = self._wrap_call(self._vtk_obj.Disable, *args)
        return ret

    def has_override(self, *args):
        """
        has_override(self, className:str) -> int
        C++: virtual int has_override(const char *className)
        has_override(self, className:str, subclassName:str) -> int
        C++: virtual int has_override(const char *className,
            const char *subclassName)
        Return 1 if this factory overrides the given class name, 0
        otherwise.
        """
        ret = self._wrap_call(self._vtk_obj.HasOverride, *args)
        return ret

    def has_override_any(self, *args):
        """
        has_override_any(className:str) -> int
        C++: static int has_override_any(const char *className)
        return 1 if one of the registered factories overrides the given
        class name
        """
        ret = self._wrap_call(self._vtk_obj.HasOverrideAny, *args)
        return ret

    def re_hash(self):
        """
        re_hash() -> None
        C++: static void re_hash()
        Re-check the VTK_AUTOLOAD_PATH for new factory libraries. This
        calls un_register_all before re-loading
        """
        ret = self._vtk_obj.ReHash()
        return ret
        

    def register_factory(self, *args):
        """
        register_factory(__a:ObjectFactory) -> None
        C++: static void register_factory(ObjectFactory *)
        Register a factory so it can be used to create vtk objects
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RegisterFactory, *my_args)
        return ret

    def set_all_enable_flags(self, *args):
        """
        set_all_enable_flags(flag:int, className:str) -> None
        C++: static void set_all_enable_flags(TypeBool flag,
            const char *className)
        set_all_enable_flags(flag:int, className:str, subclassName:str)
            -> None
        C++: static void set_all_enable_flags(TypeBool flag,
            const char *className, const char *subclassName)
        Set the enable flag for a given named class for all registered
        factories.
        """
        ret = self._wrap_call(self._vtk_obj.SetAllEnableFlags, *args)
        return ret

    def un_register_all_factories(self):
        """
        un_register_all_factories() -> None
        C++: static void un_register_all_factories()
        Unregister all factories
        """
        ret = self._vtk_obj.UnRegisterAllFactories()
        return ret
        

    def un_register_factory(self, *args):
        """
        un_register_factory(__a:ObjectFactory) -> None
        C++: static void un_register_factory(ObjectFactory *)
        Remove a factory from the list of registered factories
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.UnRegisterFactory, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ObjectFactory, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ObjectFactory properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit ObjectFactory properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ObjectFactory properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

