# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Matrix4x4(Object):
    """
    Matrix4x4 - represent and manipulate 4x4 transformation matrices
    
    Superclass: Object
    
    Matrix4x4 is a class to represent and manipulate 4x4 matrices.
    Specifically, it is designed to work on 4x4 transformation matrices
    found in 3D rendering using homogeneous coordinates [x y z w]. Many
    of the methods take an array of 16 doubles in row-major format. Note
    that open_gl stores matrices in column-major format, so the matrix
    contents must be transposed when they are moved between open_gl and
    VTK.
    @sa
    Transform
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMatrix4x4, obj, update, **traits)
    
    def get_element(self, *args):
        """
        get_element(self, i:int, j:int) -> float
        C++: double get_element(int i, int j)
        Returns the element i,j from the matrix.
        """
        ret = self._wrap_call(self._vtk_obj.GetElement, *args)
        return ret

    def set_element(self, *args):
        """
        set_element(self, i:int, j:int, value:float) -> None
        C++: void set_element(int i, int j, double value)
        Sets the element i,j in the matrix.
        """
        ret = self._wrap_call(self._vtk_obj.SetElement, *args)
        return ret

    def _get_data(self):
        return self._vtk_obj.GetData()
    data = traits.Property(_get_data, desc=\
        """
        Returns the raw double array holding the matrix.
        """
    )

    def adjoint(self, *args):
        """
        adjoint(self, in_:Matrix4x4, out:Matrix4x4) -> None
        C++: void adjoint(const Matrix4x4 *in, Matrix4x4 *out)
        adjoint(inElements:(float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float), outElements:[float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float, float]) -> None
        C++: static void adjoint(const double inElements[16],
            double outElements[16])
        Compute adjoint of the matrix and put it into out.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Adjoint, *my_args)
        return ret

    def deep_copy(self, *args):
        """
        deep_copy(self, source:Matrix4x4) -> None
        C++: void deep_copy(const Matrix4x4 *source)
        deep_copy(destination:[float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float], source:Matrix4x4) -> None
        C++: static void deep_copy(double destination[16],
            const Matrix4x4 *source)
        deep_copy(destination:[float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float], source:(float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float)) -> None
        C++: static void deep_copy(double destination[16],
            const double source[16])
        deep_copy(self, elements:(float, float, float, float, float, float,
             float, float, float, float, float, float, float, float,
            float, float)) -> None
        C++: void deep_copy(const double elements[16])
        Set the elements of the matrix to the same values as the elements
        of the given source matrix.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeepCopy, *my_args)
        return ret

    def determinant(self, *args):
        """
        determinant(self) -> float
        C++: double determinant()
        determinant(elements:(float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float)) -> float
        C++: static double determinant(const double elements[16])
        Compute the determinant of the matrix and return it.
        """
        ret = self._wrap_call(self._vtk_obj.Determinant, *args)
        return ret

    def identity(self, *args):
        """
        identity(self) -> None
        C++: void identity()
        identity(elements:[float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float]) -> None
        C++: static void identity(double elements[16])
        Set equal to Identity matrix
        """
        ret = self._wrap_call(self._vtk_obj.Identity, *args)
        return ret

    def invert(self, *args):
        """
        invert(in_:Matrix4x4, out:Matrix4x4) -> None
        C++: static void invert(const Matrix4x4 *in, Matrix4x4 *out)
        invert(self) -> None
        C++: void invert()
        invert(inElements:(float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float), outElements:[float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float, float]) -> None
        C++: static void invert(const double inElements[16],
            double outElements[16])
        Matrix Inversion (adapted from Richard Carling in "Graphics
        Gems," Academic Press, 1990).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Invert, *my_args)
        return ret

    def is_identity(self):
        """
        is_identity(self) -> bool
        C++: bool is_identity()
        Returns true if this matrix is equal to the identity matrix.
        """
        ret = self._vtk_obj.IsIdentity()
        return ret
        

    def multiply4x4(self, *args):
        """
        multiply4x4(a:Matrix4x4, b:Matrix4x4, c:Matrix4x4)
            -> None
        C++: static void multiply4x4(const Matrix4x4 *a,
            const Matrix4x4 *b, Matrix4x4 *c)
        multiply4x4(a:(float, float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float)
            , b:(float, float, float, float, float, float, float, float,
            float, float, float, float, float, float, float, float),
            c:[float, float, float, float, float, float, float, float,
            float, float, float, float, float, float, float, float])
            -> None
        C++: static void multiply4x4(const double a[16],
            const double b[16], double c[16])
        Multiplies matrices a and b and stores the result in c.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Multiply4x4, *my_args)
        return ret

    def multiply_and_transpose4x4(self, *args):
        """
        multiply_and_transpose4x4(a:(float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float, float), b:(float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float), c:[float, float, float, float, float, float, float,
            float, float, float, float, float, float, float, float,
            float]) -> None
        C++: static void multiply_and_transpose4x4(const double a[16],
            const double b[16], float c[16])"""
        ret = self._wrap_call(self._vtk_obj.MultiplyAndTranspose4x4, *args)
        return ret

    def multiply_double_point(self, *args):
        """
        multiply_double_point(self, in_:(float, float, float, float)) -> (
            float, float, float, float)
        C++: double *multiply_double_point(const double in[4])"""
        ret = self._wrap_call(self._vtk_obj.MultiplyDoublePoint, *args)
        return ret

    def multiply_float_point(self, *args):
        """
        multiply_float_point(self, in_:(float, float, float, float)) -> (
            float, float, float, float)
        C++: float *multiply_float_point(const float in[4])"""
        ret = self._wrap_call(self._vtk_obj.MultiplyFloatPoint, *args)
        return ret

    def multiply_point(self, *args):
        """
        multiply_point(self, in_:(float, float, float, float), out:[float,
            float, float, float]) -> None
        C++: void multiply_point(const double in[4], double out[4])
        multiply_point(elements:(float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float), in_:(float, float, float, float), out:[float, float,
            float, float]) -> None
        C++: static void multiply_point(const double elements[16],
            const double in[4], double out[4])
        multiply_point(self, in_:(float, float, float, float)) -> (float,
            float, float, float)
        C++: double *multiply_point(const double in[4])"""
        ret = self._wrap_call(self._vtk_obj.MultiplyPoint, *args)
        return ret

    def transpose(self, *args):
        """
        transpose(in_:Matrix4x4, out:Matrix4x4) -> None
        C++: static void transpose(const Matrix4x4 *in,
            Matrix4x4 *out)
        transpose(self) -> None
        C++: void transpose()
        transpose(inElements:(float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float), outElements:[float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float, float]) -> None
        C++: static void transpose(const double inElements[16],
            double outElements[16])
        Transpose the matrix and put it into out.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Transpose, *my_args)
        return ret

    def zero(self, *args):
        """
        zero(self) -> None
        C++: void zero()
        zero(elements:[float, float, float, float, float, float, float,
            float, float, float, float, float, float, float, float,
            float]) -> None
        C++: static void zero(double elements[16])
        Set all of the elements to zero.
        """
        ret = self._wrap_call(self._vtk_obj.Zero, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Matrix4x4, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Matrix4x4 properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit Matrix4x4 properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Matrix4x4 properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            
    def __getstate__(self):
        d = tvtk_base.TVTKBase.__getstate__(self)
        obj = self._vtk_obj
        e = [obj.GetElement(i, j) for i in range(4) for j in range(4)]
        d['elements'] = e
        return d
    
    def __setstate__(self, dict):
        e = dict.pop('elements')
        tvtk_base.TVTKBase.__setstate__(self, dict)
        self._in_set = 1
        obj = self._vtk_obj
        [obj.SetElement(i, j, e[4*i+j]) for i in range(4) for j in range(4)]
        self._in_set = 0
        self.update_traits()
    
    def from_array(self, arr):
        '''Set the value of the matrix using the passed
        Numeric array or Python list.
        '''
        obj = self._vtk_obj
        [obj.SetElement(i, j, arr[i,j]) for i in range(4) for j in range(4)]
    
    def to_array(self):
        '''Return the object as a numpy array.'''
        obj = self._vtk_obj
        e = [obj.GetElement(i, j) for i in range(4) for j in range(4)]
        arr = array_handler.numpy.array(e, dtype=float)
        arr.shape = (4,4)
        return arr
    

