# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Math(Object):
    """
    Math - performs common math operations
    
    Superclass: Object
    
    Math provides methods to perform common math operations. These
    include providing constants such as Pi; conversion from degrees to
    radians; vector operations such as dot and cross products and vector
    norm; matrix determinant for 2x2 and 3x3 matrices; univariate
    polynomial solvers; and for random number generation (for backward
    compatibility only).
    @sa
    MinimalStandardRandomSequence, BoxMuellerRandomSequence,
    Quaternion
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMath, obj, update, **traits)
    
    def get_adjusted_scalar_range(self, *args):
        """
        get_adjusted_scalar_range(array:DataArray, comp:int, range:[float,
             float]) -> int
        C++: static TypeBool get_adjusted_scalar_range(
            DataArray *array, int comp, double range[2])
        Get a DataArray's scalar range for a given component. If the
        DataArray's data type is unsigned char (VTK_UNSIGNED_CHAR) the
        range is adjusted to the whole data type range [0, 255.0]. Same
        goes for unsigned short (VTK_UNSIGNED_SHORT) but the upper bound
        is also adjusted down to 4095.0 if was between ]255, 4095.0].
        Return 1 on success, 0 otherwise.
        """
        my_args = deref_array(args, [('vtkDataArray', 'int', ['float', 'float'])])
        ret = self._wrap_call(self._vtk_obj.GetAdjustedScalarRange, *my_args)
        return ret

    def get_scalar_type_fitting_range(self, *args):
        """
        get_scalar_type_fitting_range(range_min:float, range_max:float,
            scale:float=1.0, shift:float=0.0) -> int
        C++: static int get_scalar_type_fitting_range(double range_min,
            double range_max, double scale=1.0, double shift=0.0)
        Return the scalar type that is most likely to have enough
        precision to store a given range of data once it has been scaled
        and shifted (i.e. [range_min * scale + shift, range_max * scale +
        shift]. If any one of the parameters is not an integer number
        (decimal part != 0), the search will default to float types only
        (float or double) Return -1 on error or no scalar type found.
        """
        ret = self._wrap_call(self._vtk_obj.GetScalarTypeFittingRange, *args)
        return ret

    def _get_seed(self):
        return self._vtk_obj.GetSeed()
    seed = traits.Property(_get_seed, desc=\
        """
        Return the current seed used by the random number generator.
        
        * DON'T USE Random(), random_seed(), get_seed(), Gaussian()
        * THIS IS STATIC SO THIS IS PRONE TO ERRORS (SPECIALLY FOR
          REGRESSION TESTS)
        * THIS IS HERE FOR BACKWARD COMPATIBILITY ONLY.
        * Instead, for a sequence of random numbers with a uniform
          distribution
        * create a MinimalStandardRandomSequence object.
        * For a sequence of random numbers with a gaussian/normal
          distribution
        * create a BoxMuellerRandomSequence object.
        """
    )

    def add(self, *args):
        """
        add(a:(float, float, float), b:(float, float, float), c:[float,
            float, float]) -> None
        C++: static void add(const double a[3], const double b[3],
            double c[3])
        Addition of two 3-vectors (double version). Result is stored in c
        according to c = a + b.
        """
        ret = self._wrap_call(self._vtk_obj.Add, *args)
        return ret

    def angle_between_vectors(self, *args):
        """
        angle_between_vectors(v1:(float, float, float), v2:(float, float,
            float)) -> float
        C++: static double angle_between_vectors(const double v1[3],
            const double v2[3])
        Compute angle in radians between two vectors.
        """
        ret = self._wrap_call(self._vtk_obj.AngleBetweenVectors, *args)
        return ret

    def are_bounds_initialized(self, *args):
        """
        are_bounds_initialized(bounds:(float, float, float, float, float,
            float)) -> int
        C++: static TypeBool are_bounds_initialized(
            const double bounds[6])
        Are the bounds initialized?
        """
        ret = self._wrap_call(self._vtk_obj.AreBoundsInitialized, *args)
        return ret

    def assign(self, *args):
        """
        assign(a:(float, float, float), b:[float, float, float]) -> None
        C++: static void assign(const double a[3], double b[3])
        Assign values to a 3-vector (double version). Result is stored in
        b according to b = a.
        """
        ret = self._wrap_call(self._vtk_obj.Assign, *args)
        return ret

    def begin_combination(self, *args):
        """
        begin_combination(m:int, n:int) -> Pointer
        C++: static int *begin_combination(int m, int n)
        Start iterating over "m choose n" objects. This function returns
        an array of n integers, each from 0 to m-1. These integers
        represent the n items chosen from the set [0,m[.
        
        * You are responsible for calling Math::FreeCombination() once
        the iterator is no longer needed.
        
        * Warning: this gets large very quickly, especially when n nears
          m/2!
        * (Hint: think of Pascal's triangle.)
        """
        ret = self._wrap_call(self._vtk_obj.BeginCombination, *args)
        return ret

    def binomial(self, *args):
        """
        binomial(m:int, n:int) -> int
        C++: static TypeInt64 binomial(int m, int n)
        The number of combinations of n objects from a pool of m objects
        (m>n). This is commonly known as "m choose n" and sometimes
        denoted $_mC_n $ or $\\left(\\begin{array}{c}m \\
        n\\end{array}\\right) $.
        """
        ret = self._wrap_call(self._vtk_obj.Binomial, *args)
        return ret

    def bounds_is_within_other_bounds(self, *args):
        """
        bounds_is_within_other_bounds(bounds1:(float, float, float, float,
            float, float), bounds2:(float, float, float, float, float,
            float), delta:(float, float, float)) -> int
        C++: static TypeBool bounds_is_within_other_bounds(
            const double bounds1[6], const double bounds2[6],
            const double delta[3])
        Return true if first 3D bounds is within the second 3D bounds
        Bounds is x-min, x-max, y-min, y-max, z-min, z-max Delta is the
        error margin along each axis (usually a small number)
        """
        ret = self._wrap_call(self._vtk_obj.BoundsIsWithinOtherBounds, *args)
        return ret

    def ceil(self, *args):
        """
        ceil(x:float) -> int
        C++: static int ceil(double x)
        Rounds a double to the nearest integer not less than itself. This
        is faster than ceil() but provides undefined output on overflow.
        """
        ret = self._wrap_call(self._vtk_obj.Ceil, *args)
        return ret

    def ceil_log2(self, *args):
        """
        ceil_log2(x:int) -> int
        C++: static int ceil_log2(TypeUInt64 x)
        Gives the exponent of the lowest power of two not less than x. Or
        in mathspeak, return the smallest "i" for which 2^i >= x. If x is
        zero, then the return value will be zero.
        """
        ret = self._wrap_call(self._vtk_obj.CeilLog2, *args)
        return ret

    def clamp_and_normalize_value(self, *args):
        """
        clamp_and_normalize_value(value:float, range:(float, float)) -> float
        C++: static double clamp_and_normalize_value(double value,
            const double range[2])
        Clamp a value against a range and then normalize it between 0 and
        1. If range[0]==range[1], the result is 0.
        \\pre valid_range: range[0]<=range[1]
        \\post valid_result: result>=0.0 && result<=1.0
        """
        ret = self._wrap_call(self._vtk_obj.ClampAndNormalizeValue, *args)
        return ret

    def clamp_value(self, *args):
        """
        clamp_value(value:[float, ...], range:(float, float)) -> None
        C++: static void clamp_value(double *value, const double range[2])
        clamp_value(value:float, range:(float, float),
            clamped_value:[float, ...]) -> None
        C++: static void clamp_value(double value, const double range[2],
            double *clamped_value)
        Clamp some values against a range The method without
        'clamped_values' will perform in-place clamping.
        """
        ret = self._wrap_call(self._vtk_obj.ClampValue, *args)
        return ret

    def clamp_values(self, *args):
        """
        clamp_values(values:[float, ...], nb_values:int, range:(float,
            float)) -> None
        C++: static void clamp_values(double *values, int nb_values,
            const double range[2])
        clamp_values(values:(float, ...), nb_values:int, range:(float,
            float), clamped_values:[float, ...]) -> None
        C++: static void clamp_values(const double *values, int nb_values,
            const double range[2], double *clamped_values)"""
        ret = self._wrap_call(self._vtk_obj.ClampValues, *args)
        return ret

    def cross(self, *args):
        """
        cross(a:(float, float, float), b:(float, float, float), c:[float,
            float, float]) -> None
        C++: static void cross(const double a[3], const double b[3],
            double c[3])
        Cross product of two 3-vectors. Result (a x b) is stored in c.
        (double version)
        """
        ret = self._wrap_call(self._vtk_obj.Cross, *args)
        return ret

    def degrees_from_radians(self, *args):
        """
        degrees_from_radians(radians:float) -> float
        C++: static double degrees_from_radians(double radians)"""
        ret = self._wrap_call(self._vtk_obj.DegreesFromRadians, *args)
        return ret

    def determinant2x2(self, *args):
        """
        determinant2x2(a:float, b:float, c:float, d:float) -> float
        C++: static double determinant2x2(double a, double b, double c,
            double d)
        determinant2x2(c1:(float, float), c2:(float, float)) -> float
        C++: static double determinant2x2(const double c1[2],
            const double c2[2])
        Calculate the determinant of a 2x2 matrix: | a b | | c d |
        """
        ret = self._wrap_call(self._vtk_obj.Determinant2x2, *args)
        return ret

    def determinant3x3(self, *args):
        """
        determinant3x3(A:((float, float, float), (float, float, float), (
            float, float, float))) -> float
        C++: static double determinant3x3(const double A[3][3])
        determinant3x3(c1:(float, float, float), c2:(float, float, float),
             c3:(float, float, float)) -> float
        C++: static double determinant3x3(const double c1[3],
            const double c2[3], const double c3[3])
        determinant3x3(a1:float, a2:float, a3:float, b1:float, b2:float,
            b3:float, c1:float, c2:float, c3:float) -> float
        C++: static double determinant3x3(double a1, double a2, double a3,
             double b1, double b2, double b3, double c1, double c2,
            double c3)"""
        ret = self._wrap_call(self._vtk_obj.Determinant3x3, *args)
        return ret

    def diagonalize3x3(self, *args):
        """
        diagonalize3x3(A:((float, float, float), (float, float, float), (
            float, float, float)), w:[float, float, float], V:[[float,
            float, float], [float, float, float], [float, float, float]])
            -> None
        C++: static void diagonalize3x3(const double A[3][3], double w[3],
             double V[3][3])"""
        ret = self._wrap_call(self._vtk_obj.Diagonalize3x3, *args)
        return ret

    def distance2_between_points(self, *args):
        """
        distance2_between_points(p1:(float, float, float), p2:(float, float,
             float)) -> float
        C++: static double distance2_between_points(const double p1[3],
            const double p2[3])
        Compute distance squared between two points p1 and p2. (double
        version).
        """
        ret = self._wrap_call(self._vtk_obj.Distance2BetweenPoints, *args)
        return ret

    def dot(self, *args):
        """
        dot(a:(float, float, float), b:(float, float, float)) -> float
        C++: static double dot(const double a[3], const double b[3])
        Dot product of two 3-vectors (double version).
        """
        ret = self._wrap_call(self._vtk_obj.Dot, *args)
        return ret

    def dot2d(self, *args):
        """
        dot2d(x:(float, float), y:(float, float)) -> float
        C++: static double dot2d(const double x[2], const double y[2])
        Dot product of two 2-vectors. (double version).
        """
        ret = self._wrap_call(self._vtk_obj.Dot2D, *args)
        return ret

    def extent_is_within_other_extent(self, *args):
        """
        extent_is_within_other_extent(extent1:(int, int, int, int, int, int),
            extent2:(int, int, int, int, int, int)) -> int
        C++: static TypeBool extent_is_within_other_extent(
            const int extent1[6], const int extent2[6])
        Return true if first 3D extent is within second 3D extent Extent
        is x-min, x-max, y-min, y-max, z-min, z-max
        """
        ret = self._wrap_call(self._vtk_obj.ExtentIsWithinOtherExtent, *args)
        return ret

    def factorial(self, *args):
        """
        factorial(N:int) -> int
        C++: static TypeInt64 factorial(int N)
        Compute N factorial, N! = N*(N-1) * (N-2)...*3*2*1. 0! is taken
        to be 1.
        """
        ret = self._wrap_call(self._vtk_obj.Factorial, *args)
        return ret

    def floor(self, *args):
        """
        floor(x:float) -> int
        C++: static int floor(double x)
        Rounds a double to the nearest integer not greater than itself.
        This is faster than floor() but provides undefined output on
        overflow.
        """
        ret = self._wrap_call(self._vtk_obj.Floor, *args)
        return ret

    def free_combination(self, *args):
        """
        free_combination(combination:[int, ...]) -> None
        C++: static void free_combination(int *combination)
        Free the "iterator" array created by Math::BeginCombination.
        """
        ret = self._wrap_call(self._vtk_obj.FreeCombination, *args)
        return ret

    def gaussian(self, *args):
        """
        gaussian() -> float
        C++: static double gaussian()
        gaussian(mean:float, std:float) -> float
        C++: static double gaussian(double mean, double std)
        Generate pseudo-random numbers distributed according to the
        standard normal distribution.
        
        * DON'T USE Random(), random_seed(), get_seed(), Gaussian()
        * THIS IS STATIC SO THIS IS PRONE TO ERRORS (SPECIALLY FOR
          REGRESSION TESTS)
        * THIS IS HERE FOR BACKWARD COMPATIBILITY ONLY.
        * Instead, for a sequence of random numbers with a uniform
          distribution
        * create a MinimalStandardRandomSequence object.
        * For a sequence of random numbers with a gaussian/normal
          distribution
        * create a BoxMuellerRandomSequence object.
        """
        ret = self._wrap_call(self._vtk_obj.Gaussian, *args)
        return ret

    def gaussian_amplitude(self, *args):
        """
        gaussian_amplitude(variance:float, distanceFromMean:float) -> float
        C++: static double gaussian_amplitude(const double variance,
            const double distanceFromMean)
        gaussian_amplitude(mean:float, variance:float, position:float)
            -> float
        C++: static double gaussian_amplitude(const double mean,
            const double variance, const double position)
        Compute the amplitude of a Gaussian function with mean=0 and
        specified variance. That is, 1./(std::sqrt(2 Pi * variance)) *
        exp(-distancefrom_mean^2/(2.*variance)).
        """
        ret = self._wrap_call(self._vtk_obj.GaussianAmplitude, *args)
        return ret

    def gaussian_weight(self, *args):
        """
        gaussian_weight(variance:float, distanceFromMean:float) -> float
        C++: static double gaussian_weight(const double variance,
            const double distanceFromMean)
        gaussian_weight(mean:float, variance:float, position:float)
            -> float
        C++: static double gaussian_weight(const double mean,
            const double variance, const double position)
        Compute the amplitude of an unnormalized Gaussian function with
        mean=0 and specified variance. That is,
        exp(-distancefrom_mean^2/(2.*variance)). When distancefrom_mean =
        0, this function returns 1.
        """
        ret = self._wrap_call(self._vtk_obj.GaussianWeight, *args)
        return ret

    def hsv_to_rgb(self, *args):
        """
        hsv_to_rgb(hsv:(float, float, float), rgb:[float, float, float])
            -> None
        C++: static void hsv_to_rgb(const double hsv[3], double rgb[3])
        hsv_to_rgb(h:float, s:float, v:float, r:[float, ...], g:[float,
            ...], b:[float, ...]) -> None
        C++: static void hsv_to_rgb(double h, double s, double v, double *r,
             double *g, double *b)"""
        ret = self._wrap_call(self._vtk_obj.HSVToRGB, *args)
        return ret

    def identity3x3(self, *args):
        """
        identity3x3(A:[[float, float, float], [float, float, float],
            [float, float, float]]) -> None
        C++: static void identity3x3(double A[3][3])"""
        ret = self._wrap_call(self._vtk_obj.Identity3x3, *args)
        return ret

    def inf(self):
        """
        inf() -> float
        C++: static double inf()
        Special IEEE-754 number used to represent positive infinity.
        """
        ret = self._vtk_obj.Inf()
        return ret
        

    def invert3x3(self, *args):
        """
        invert3x3(A:((float, float, float), (float, float, float), (float,
             float, float)), AI:[[float, float, float], [float, float,
            float], [float, float, float]]) -> None
        C++: static void invert3x3(const double A[3][3], double AI[3][3])"""
        ret = self._wrap_call(self._vtk_obj.Invert3x3, *args)
        return ret

    def is_finite(self, *args):
        """
        is_finite(x:float) -> bool
        C++: static bool is_finite(double x)
        Test if a number has finite value i.e. it is normal, subnormal or
        zero, but not infinite or Nan.
        """
        ret = self._wrap_call(self._vtk_obj.IsFinite, *args)
        return ret

    def is_inf(self, *args):
        """
        is_inf(x:float) -> int
        C++: static TypeBool is_inf(double x)
        Test if a number is equal to the special floating point value
        infinity.
        """
        ret = self._wrap_call(self._vtk_obj.IsInf, *args)
        return ret

    def is_nan(self, *args):
        """
        is_nan(x:float) -> int
        C++: static TypeBool is_nan(double x)
        Test if a number is equal to the special floating point value
        Not-A-Number (Nan).
        """
        ret = self._wrap_call(self._vtk_obj.IsNan, *args)
        return ret

    def is_power_of_two(self, *args):
        """
        is_power_of_two(x:int) -> bool
        C++: static bool is_power_of_two(TypeUInt64 x)
        Returns true if integer is a power of two.
        """
        ret = self._wrap_call(self._vtk_obj.IsPowerOfTwo, *args)
        return ret

    def lu_factor3x3(self, *args):
        """
        lu_factor3x3(A:[[float, float, float], [float, float, float],
            [float, float, float]], index:[int, int, int]) -> None
        C++: static void lu_factor3x3(double A[3][3], int index[3])"""
        ret = self._wrap_call(self._vtk_obj.LUFactor3x3, *args)
        return ret

    def lu_solve3x3(self, *args):
        """
        lu_solve3x3(A:((float, float, float), (float, float, float), (
            float, float, float)), index:(int, int, int), x:[float, float,
             float]) -> None
        C++: static void lu_solve3x3(const double A[3][3],
            const int index[3], double x[3])"""
        ret = self._wrap_call(self._vtk_obj.LUSolve3x3, *args)
        return ret

    def lab_to_rgb(self, *args):
        """
        lab_to_rgb(lab:(float, float, float), rgb:[float, float, float])
            -> None
        C++: static void lab_to_rgb(const double lab[3], double rgb[3])
        lab_to_rgb(L:float, a:float, b:float, red:[float, ...],
            green:[float, ...], blue:[float, ...]) -> None
        C++: static void lab_to_rgb(double L, double a, double b,
            double *red, double *green, double *blue)
        Convert color from the CIE-L*ab system to RGB.
        """
        ret = self._wrap_call(self._vtk_obj.LabToRGB, *args)
        return ret

    def lab_to_xyz(self, *args):
        """
        lab_to_xyz(lab:(float, float, float), xyz:[float, float, float])
            -> None
        C++: static void lab_to_xyz(const double lab[3], double xyz[3])
        lab_to_xyz(L:float, a:float, b:float, x:[float, ...], y:[float,
            ...], z:[float, ...]) -> None
        C++: static void lab_to_xyz(double L, double a, double b, double *x,
             double *y, double *z)
        Convert color from the CIE-L*ab system to CIE XYZ.
        """
        ret = self._wrap_call(self._vtk_obj.LabToXYZ, *args)
        return ret

    def linear_solve3x3(self, *args):
        """
        linear_solve3x3(A:((float, float, float), (float, float, float), (
            float, float, float)), x:(float, float, float), y:[float,
            float, float]) -> None
        C++: static void linear_solve3x3(const double A[3][3],
            const double x[3], double y[3])"""
        ret = self._wrap_call(self._vtk_obj.LinearSolve3x3, *args)
        return ret

    def matrix3x3_to_quaternion(self, *args):
        """
        matrix3x3_to_quaternion(A:((float, float, float), (float, float,
            float), (float, float, float)), quat:[float, float, float,
            float]) -> None
        C++: static void matrix3x3_to_quaternion(const double A[3][3],
            double quat[4])"""
        ret = self._wrap_call(self._vtk_obj.Matrix3x3ToQuaternion, *args)
        return ret

    def multiply3x3(self, *args):
        """
        multiply3x3(A:((float, float, float), (float, float, float), (
            float, float, float)), v:(float, float, float), u:[float,
            float, float]) -> None
        C++: static void multiply3x3(const double A[3][3],
            const double v[3], double u[3])
        multiply3x3(A:((float, float, float), (float, float, float), (
            float, float, float)), B:((float, float, float), (float,
            float, float), (float, float, float)), C:[[float, float,
            float], [float, float, float], [float, float, float]]) -> None
        C++: static void multiply3x3(const double A[3][3],
            const double B[3][3], double C[3][3])"""
        ret = self._wrap_call(self._vtk_obj.Multiply3x3, *args)
        return ret

    def multiply_quaternion(self, *args):
        """
        multiply_quaternion(q1:(float, float, float, float), q2:(float,
            float, float, float), q:[float, float, float, float]) -> None
        C++: static void multiply_quaternion(const double q1[4],
            const double q2[4], double q[4])"""
        ret = self._wrap_call(self._vtk_obj.MultiplyQuaternion, *args)
        return ret

    def multiply_scalar(self, *args):
        """
        multiply_scalar(a:[float, float, float], s:float) -> None
        C++: static void multiply_scalar(double a[3], double s)
        Multiplies a 3-vector by a scalar (double version). This modifies
        the input 3-vector.
        """
        ret = self._wrap_call(self._vtk_obj.MultiplyScalar, *args)
        return ret

    def multiply_scalar2d(self, *args):
        """
        multiply_scalar2d(a:[float, float], s:float) -> None
        C++: static void multiply_scalar2d(double a[2], double s)
        Multiplies a 2-vector by a scalar (double version). This modifies
        the input 2-vector.
        """
        ret = self._wrap_call(self._vtk_obj.MultiplyScalar2D, *args)
        return ret

    def nan(self):
        """
        nan() -> float
        C++: static double nan()
        Special IEEE-754 number used to represent Not-A-Number (Nan).
        """
        ret = self._vtk_obj.Nan()
        return ret
        

    def nearest_power_of_two(self, *args):
        """
        nearest_power_of_two(x:int) -> int
        C++: static int nearest_power_of_two(int x)
        Compute the nearest power of two that is not less than x. The
        return value is 1 if x is less than or equal to zero, and is
        VTK_INT_MIN if result is too large to fit in an int.
        """
        ret = self._wrap_call(self._vtk_obj.NearestPowerOfTwo, *args)
        return ret

    def neg_inf(self):
        """
        neg_inf() -> float
        C++: static double neg_inf()
        Special IEEE-754 number used to represent negative infinity.
        """
        ret = self._vtk_obj.NegInf()
        return ret
        

    def next_combination(self, *args):
        """
        next_combination(m:int, n:int, combination:[int, ...]) -> int
        C++: static int next_combination(int m, int n, int *combination)
        Given m, n, and a valid combination of n integers in the range
        [0,m[, this function alters the integers into the next
        combination in a sequence of all combinations of n items from a
        pool of m.
        
        * If the combination is the last item in the sequence on input,
        * then combination is unaltered and 0 is returned.
        * Otherwise, 1 is returned and combination is updated.
        """
        ret = self._wrap_call(self._vtk_obj.NextCombination, *args)
        return ret

    def norm(self, *args):
        """
        norm(x:(float, ...), n:int) -> float
        C++: static double norm(const double *x, int n)
        norm(v:(float, float, float)) -> float
        C++: static double norm(const double v[3])"""
        ret = self._wrap_call(self._vtk_obj.Norm, *args)
        return ret

    def norm2d(self, *args):
        """
        norm2d(x:(float, float)) -> float
        C++: static double norm2d(const double x[2])
        Compute the norm of a 2-vector. (double version).
        """
        ret = self._wrap_call(self._vtk_obj.Norm2D, *args)
        return ret

    def normalize(self, *args):
        """
        normalize(v:[float, float, float]) -> float
        C++: static double normalize(double v[3])
        Normalize (in place) a 3-vector. Returns norm of vector (double
        version).
        """
        ret = self._wrap_call(self._vtk_obj.Normalize, *args)
        return ret

    def normalize2d(self, *args):
        """
        normalize2d(v:[float, float]) -> float
        C++: static double normalize2d(double v[2])
        Normalize (in place) a 2-vector. Returns norm of vector. (double
        version).
        """
        ret = self._wrap_call(self._vtk_obj.Normalize2D, *args)
        return ret

    def orthogonalize3x3(self, *args):
        """
        orthogonalize3x3(A:((float, float, float), (float, float, float),
            (float, float, float)), B:[[float, float, float], [float,
            float, float], [float, float, float]]) -> None
        C++: static void orthogonalize3x3(const double A[3][3],
            double B[3][3])"""
        ret = self._wrap_call(self._vtk_obj.Orthogonalize3x3, *args)
        return ret

    def outer(self, *args):
        """
        outer(a:(float, float, float), b:(float, float, float), c:[[float,
             float, float], [float, float, float], [float, float, float]])
             -> None
        C++: static void outer(const double a[3], const double b[3],
            double c[3][3])
        Outer product of two 3-vectors (double version).
        """
        ret = self._wrap_call(self._vtk_obj.Outer, *args)
        return ret

    def outer2d(self, *args):
        """
        outer2d(x:(float, float), y:(float, float), A:[[float, float],
            [float, float]]) -> None
        C++: static void outer2d(const double x[2], const double y[2],
            double A[2][2])
        Outer product of two 2-vectors (double version).
        """
        ret = self._wrap_call(self._vtk_obj.Outer2D, *args)
        return ret

    def perpendiculars(self, *args):
        """
        perpendiculars(v1:(float, float, float), v2:[float, float, float],
             v3:[float, float, float], theta:float) -> None
        C++: static void perpendiculars(const double v1[3], double v2[3],
            double v3[3], double theta)
        Given a unit vector v1, find two unit vectors v2 and v3 such that
        v1 cross v2 = v3 (i.e. the vectors are perpendicular to each
        other). There is an infinite number of such vectors, specify an
        angle theta to choose one set.  If you want only one
        perpendicular vector, specify nullptr for v3.
        """
        ret = self._wrap_call(self._vtk_obj.Perpendiculars, *args)
        return ret

    def pi(self):
        """
        pi() -> float
        C++: static constexpr double pi()
        A mathematical constant. This version is atan(1.0) * 4.0
        """
        ret = self._vtk_obj.Pi()
        return ret
        

    def plane_intersects_aabb(self, *args):
        """
        plane_intersects_aabb(bounds:(float, float, float, float, float,
            float), normal:(float, float, float), point:(float, float,
            float)) -> int
        C++: static int plane_intersects_aabb(const double bounds[6],
            const double normal[3], const double point[3])
        Implements Plane / Axis-Aligned Bounding-Box intersection as
        described in Graphics Gems IV, Ned Greene; pp. 75-76. Variable
        names are based on the description in the book. This function
        returns +1 if the box lies fully in the positive side of the
        plane (by convention, the side to which the plane's normal points
        to), -1 if the box fully lies in the negative side and 0 if the
        plane intersects the box.  -2 is returned if any of the arguments
        is invalid.
        """
        ret = self._wrap_call(self._vtk_obj.PlaneIntersectsAABB, *args)
        return ret

    def point_is_within_bounds(self, *args):
        """
        point_is_within_bounds(point:(float, float, float), bounds:(float,
            float, float, float, float, float), delta:(float, float,
            float)) -> int
        C++: static TypeBool point_is_within_bounds(const double point[3],
             const double bounds[6], const double delta[3])
        Return true if point is within the given 3D bounds Bounds is
        x-min, x-max, y-min, y-max, z-min, z-max Delta is the error
        margin along each axis (usually a small number)
        """
        ret = self._wrap_call(self._vtk_obj.PointIsWithinBounds, *args)
        return ret

    def project_vector(self, *args):
        """
        project_vector(a:(float, float, float), b:(float, float, float),
            projection:[float, float, float]) -> bool
        C++: static bool project_vector(const double a[3],
            const double b[3], double projection[3])"""
        ret = self._wrap_call(self._vtk_obj.ProjectVector, *args)
        return ret

    def project_vector2d(self, *args):
        """
        project_vector2d(a:(float, float), b:(float, float),
            projection:[float, float]) -> bool
        C++: static bool project_vector2d(const double a[2],
            const double b[2], double projection[2])"""
        ret = self._wrap_call(self._vtk_obj.ProjectVector2D, *args)
        return ret

    def quadratic_root(self, *args):
        """
        quadratic_root(a:float, b:float, c:float, min:float, max:float,
            u:[float, ...]) -> int
        C++: static int quadratic_root(double a, double b, double c,
            double min, double max, double *u)
        find roots of ax^2+bx+c=0  in the interval min,max. place the
        roots in u[2] and return how many roots found
        """
        ret = self._wrap_call(self._vtk_obj.QuadraticRoot, *args)
        return ret

    def quaternion_to_matrix3x3(self, *args):
        """
        quaternion_to_matrix3x3(quat:(float, float, float, float),
            A:[[float, float, float], [float, float, float], [float,
            float, float]]) -> None
        C++: static void quaternion_to_matrix3x3(const double quat[4],
            double A[3][3])"""
        ret = self._wrap_call(self._vtk_obj.QuaternionToMatrix3x3, *args)
        return ret

    def rgb_to_hsv(self, *args):
        """
        rgb_to_hsv(rgb:(float, float, float), hsv:[float, float, float])
            -> None
        C++: static void rgb_to_hsv(const double rgb[3], double hsv[3])
        rgb_to_hsv(r:float, g:float, b:float, h:[float, ...], s:[float,
            ...], v:[float, ...]) -> None
        C++: static void rgb_to_hsv(double r, double g, double b, double *h,
             double *s, double *v)"""
        ret = self._wrap_call(self._vtk_obj.RGBToHSV, *args)
        return ret

    def rgb_to_lab(self, *args):
        """
        rgb_to_lab(rgb:(float, float, float), lab:[float, float, float])
            -> None
        C++: static void rgb_to_lab(const double rgb[3], double lab[3])
        rgb_to_lab(red:float, green:float, blue:float, L:[float, ...],
            a:[float, ...], b:[float, ...]) -> None
        C++: static void rgb_to_lab(double red, double green, double blue,
            double *L, double *a, double *b)
        Convert color from the RGB system to CIE-L*ab. The input RGB must
        be values in the range [0, 1]. The output ranges of 'L' is [0,
        100]. The output range of 'a' and 'b' are approximately [-110,
        110].
        """
        ret = self._wrap_call(self._vtk_obj.RGBToLab, *args)
        return ret

    def rgb_to_xyz(self, *args):
        """
        rgb_to_xyz(rgb:(float, float, float), xyz:[float, float, float])
            -> None
        C++: static void rgb_to_xyz(const double rgb[3], double xyz[3])
        rgb_to_xyz(r:float, g:float, b:float, x:[float, ...], y:[float,
            ...], z:[float, ...]) -> None
        C++: static void rgb_to_xyz(double r, double g, double b, double *x,
             double *y, double *z)
        Convert color from the RGB system to CIE XYZ.
        """
        ret = self._wrap_call(self._vtk_obj.RGBToXYZ, *args)
        return ret

    def radians_from_degrees(self, *args):
        """
        radians_from_degrees(degrees:float) -> float
        C++: static double radians_from_degrees(double degrees)"""
        ret = self._wrap_call(self._vtk_obj.RadiansFromDegrees, *args)
        return ret

    def random(self, *args):
        """
        random() -> float
        C++: static double random()
        random(min:float, max:float) -> float
        C++: static double random(double min, double max)
        Generate pseudo-random numbers distributed according to the
        uniform distribution between 0.0 and 1.0. This is used to provide
        portability across different systems.
        
        * DON'T USE Random(), random_seed(), get_seed(), Gaussian()
        * THIS IS STATIC SO THIS IS PRONE TO ERRORS (SPECIALLY FOR
          REGRESSION TESTS)
        * THIS IS HERE FOR BACKWARD COMPATIBILITY ONLY.
        * Instead, for a sequence of random numbers with a uniform
          distribution
        * create a MinimalStandardRandomSequence object.
        * For a sequence of random numbers with a gaussian/normal
          distribution
        * create a BoxMuellerRandomSequence object.
        """
        ret = self._wrap_call(self._vtk_obj.Random, *args)
        return ret

    def random_seed(self, *args):
        """
        random_seed(s:int) -> None
        C++: static void random_seed(int s)
        Initialize seed value. NOTE: Random() has the bad property that
        the first random number returned after random_seed() is called is
        proportional to the seed value! To help solve this, call
        random_seed() a few times inside seed. This doesn't ruin the
        repeatability of Random().
        
        * DON'T USE Random(), random_seed(), get_seed(), Gaussian()
        * THIS IS STATIC SO THIS IS PRONE TO ERRORS (SPECIALLY FOR
          REGRESSION TESTS)
        * THIS IS HERE FOR BACKWARD COMPATIBILITY ONLY.
        * Instead, for a sequence of random numbers with a uniform
          distribution
        * create a MinimalStandardRandomSequence object.
        * For a sequence of random numbers with a gaussian/normal
          distribution
        * create a BoxMuellerRandomSequence object.
        """
        ret = self._wrap_call(self._vtk_obj.RandomSeed, *args)
        return ret

    def rotate_vector_by_normalized_quaternion(self, *args):
        """
        rotate_vector_by_normalized_quaternion(v:(float, float, float), q:(
            float, float, float, float), r:[float, float, float]) -> None
        C++: static void rotate_vector_by_normalized_quaternion(
            const double v[3], const double q[4], double r[3])"""
        ret = self._wrap_call(self._vtk_obj.RotateVectorByNormalizedQuaternion, *args)
        return ret

    def rotate_vector_by_wxyz(self, *args):
        """
        rotate_vector_by_wxyz(v:(float, float, float), q:(float, float,
            float, float), r:[float, float, float]) -> None
        C++: static void rotate_vector_by_wxyz(const double v[3],
            const double q[4], double r[3])"""
        ret = self._wrap_call(self._vtk_obj.RotateVectorByWXYZ, *args)
        return ret

    def round(self, *args):
        """
        round(f:float) -> int
        C++: static int round(double f)"""
        ret = self._wrap_call(self._vtk_obj.Round, *args)
        return ret

    def signed_angle_between_vectors(self, *args):
        """
        signed_angle_between_vectors(v1:(float, float, float), v2:(float,
            float, float), vn:(float, float, float)) -> float
        C++: static double signed_angle_between_vectors(const double v1[3],
            const double v2[3], const double vn[3])
        Compute signed angle in radians between two vectors with regard
        to a third orthogonal vector
        """
        ret = self._wrap_call(self._vtk_obj.SignedAngleBetweenVectors, *args)
        return ret

    def singular_value_decomposition3x3(self, *args):
        """
        singular_value_decomposition3x3(A:((float, float, float), (float,
            float, float), (float, float, float)), U:[[float, float,
            float], [float, float, float], [float, float, float]],
            w:[float, float, float], VT:[[float, float, float], [float,
            float, float], [float, float, float]]) -> None
        C++: static void singular_value_decomposition3x3(
            const double A[3][3], double U[3][3], double w[3],
            double VT[3][3])"""
        ret = self._wrap_call(self._vtk_obj.SingularValueDecomposition3x3, *args)
        return ret

    def solve3_point_circle(self, *args):
        """
        solve3_point_circle(p1:(float, float, float), p2:(float, float,
            float), p3:(float, float, float), center:[float, float,
            float]) -> float
        C++: static double solve3_point_circle(const double p1[3],
            const double p2[3], const double p3[3], double center[3])
        In Euclidean space, there is a unique circle passing through any
        given three non-collinear points P1, P2, and P3. Using Cartesian
        coordinates to represent these points as spatial vectors, it is
        possible to use the dot product and cross product to calculate
        the radius and center of the circle. See:
        http://en.wikipedia.org/wiki/Circumscribed_circle and more
        specifically the section Barycentric coordinates from cross- and
        dot-products
        """
        ret = self._wrap_call(self._vtk_obj.Solve3PointCircle, *args)
        return ret

    def solve_linear_system_gepp_2x2(self, *args):
        """
        solve_linear_system_gepp_2x2(a00:float, a01:float, a10:float,
            a11:float, b0:float, b1:float, x0:float, x1:float) -> int
        C++: static TypeBool solve_linear_system_gepp_2x2(double a00,
            double a01, double a10, double a11, double b0, double b1,
            double &x0, double &x1)
        Solve linear equation Ax = b using Gaussian Elimination with
        Partial Pivoting for a 2x2 system. If the matrix is found to be
        singular within a small numerical tolerance close to machine
        precision then 0 is returned. Note: Even if method succeeded the
        matrix A could be close to singular.
              The solution should be checked against relevant tolerance
        criteria.
        """
        ret = self._wrap_call(self._vtk_obj.SolveLinearSystemGEPP2x2, *args)
        return ret

    def subtract(self, *args):
        """
        subtract(a:(float, float, float), b:(float, float, float),
            c:[float, float, float]) -> None
        C++: static void subtract(const double a[3], const double b[3],
            double c[3])
        Subtraction of two 3-vectors (double version). Result is stored
        in c according to c = a - b.
        """
        ret = self._wrap_call(self._vtk_obj.Subtract, *args)
        return ret

    def transpose3x3(self, *args):
        """
        transpose3x3(A:((float, float, float), (float, float, float), (
            float, float, float)), AT:[[float, float, float], [float,
            float, float], [float, float, float]]) -> None
        C++: static void transpose3x3(const double A[3][3],
            double AT[3][3])"""
        ret = self._wrap_call(self._vtk_obj.Transpose3x3, *args)
        return ret

    def uninitialize_bounds(self, *args):
        """
        uninitialize_bounds(bounds:[float, float, float, float, float,
            float]) -> None
        C++: static void uninitialize_bounds(double bounds[6])
        Set the bounds to an uninitialized state
        """
        ret = self._wrap_call(self._vtk_obj.UninitializeBounds, *args)
        return ret

    def xyz_to_lab(self, *args):
        """
        xyz_to_lab(xyz:(float, float, float), lab:[float, float, float])
            -> None
        C++: static void xyz_to_lab(const double xyz[3], double lab[3])
        xyz_to_lab(x:float, y:float, z:float, L:[float, ...], a:[float,
            ...], b:[float, ...]) -> None
        C++: static void xyz_to_lab(double x, double y, double z, double *L,
             double *a, double *b)
        Convert Color from the CIE XYZ system to CIE-L*ab.
        """
        ret = self._wrap_call(self._vtk_obj.XYZToLab, *args)
        return ret

    def xyz_to_rgb(self, *args):
        """
        xyz_to_rgb(xyz:(float, float, float), rgb:[float, float, float])
            -> None
        C++: static void xyz_to_rgb(const double xyz[3], double rgb[3])
        xyz_to_rgb(x:float, y:float, z:float, r:[float, ...], g:[float,
            ...], b:[float, ...]) -> None
        C++: static void xyz_to_rgb(double x, double y, double z, double *r,
             double *g, double *b)
        Convert color from the CIE XYZ system to RGB.
        """
        ret = self._wrap_call(self._vtk_obj.XYZToRGB, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Math, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Math properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit Math properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Math properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

