# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object_base import ObjectBase


class Logger(ObjectBase):
    """
    Logger - logging framework for use in VTK and in applications
    based on VTK
    
    Superclass: ObjectBase
    
    Logger acts as the entry point to VTK's logging framework. The
    implementation uses the loguru (https://github.com/emilk/loguru).
    Logger provides some static API to initialize and configure
    logging together with a collection of macros that can be used to add
    items to the generated log.
    
    The logging framework is based on verbosity levels. Level 0-9 are
    supported in addition to named levels such as ERROR, WARNING, and
    INFO. When a log for a particular verbosity level is being generated,
    all log additions issued with verbosity level less than or equal to
    the requested verbosity level will get logged.
    
    When using any of the logging macros, it must be noted that unless a
    log output is requesting that verbosity provided (or higher), the
    call is a no-op and the message stream or printf-style arguments will
    not be evaluated.
    
    @section Setup Setup
    
    To initialize logging, in your application's `main()` you may call
    `Logger::Init(argv, argc)`. This is totally optional but useful to
    time-stamp the  start of the  log. Furthermore, it can optionally
    detect verbosity level on the command line as `-v` (or any another
    string pass as the optional argument to `Init`) that will be used as
    the verbosity level for logging on to `stderr`. By default, it is set
    to `0` (or `INFO`) unless changed by calling
    `Logger::set_stderr_verbosity`.
    
    In additional to logging to `stderr`, one can accumulate logs to one
    or more files using `Logger::log_to_file`. Each log file can be
    given its own verbosity level.
    
    For multithreaded applications, you may want to name each of the
    threads so that the generated log can use human readable names for
    the threads. For that, use `Logger::set_thread_name`. Calling
    `Logger::Init` will set the name for the main thread.
    
    To prevent the logging framework from intercepting signals from your
    application, you can set the static variable
    `Logger::enable_unsafe_signal_handler` to `false` prior to calling
    `Logger::Init(argc, argv)` or `Logger::Init()`.
    
    @section Logging Logging
    
    Logger provides several macros (again, based on `loguru`) that can
    be used to add the log. Both printf-style and stream-style is
    supported. All printf-style macros are suffixed with `F` to
    distinguish them from the stream macros. Another pattern in naming
    macros is the presence of `V` e.g. `VLog` vs `Log`. A macro
    with the `V` prefix takes a fully qualified verbosity enum e.g.
    `Logger::VERBOSITY_INFO` or `Logger::VERBOSITY_0`, while the
    non-`V` variant takes the verbosity name e.g. `INFO` or `0`.
    
    Following code snippet provides an overview of the available macros
    and their usage.
    
    {.cpp}
    
    
     // Optional, leaving this as the default value `true` will let the
    logging
     // framework log signals such as segmentation faults.
    
    
     Logger::EnableUnsafeSignalHandler = false;
    
    
     // Optional, but useful to time-stamp the start of the log.
     // Will also detect verbosity level on the command line as -v.
    
    
     Logger::Init(argc, argv);
    
    
     // Put every log message in "everything.log":
     Logger::LogToFile("everything.log", Logger::APPEND,
    Logger::VERBOSITY_MAX);
    
    
     // Only log INFO, WARNING, ERROR to "latest_readable.log":
     Logger::LogToFile("latest_readable.log", Logger::TRUNCATE,
    Logger::VERBOSITY_INFO);
    
    
     // Only show most relevant things on stderr:
     Logger::SetStderrVerbosity(vtkLogger::VERBOSITY_1);
    
    
     // add a line to log using the verbosity name.
     LogF(INFO, "I'm hungry for some %.3f!", 3.14159);
     LogF(0, "same deal");
    
    
     // add a line to log using the verbosity enum.
     VLogF(vtkLogger::VERBOSITY_INFO, "I'm hungry for some %.3f!",
    3.14159);
     VLogF(vtkLogger::VERBOSITY_0, "same deal");
    
    
     // to add an identifier for a ObjectBase or subclass
     LogF(INFO, "The object is %s", LogIdentifier(vtkobject));
    
    
     // add a line conditionally to log if the condition succeeds:
     LogIfF(INFO, ptr == nullptr, "ptr is nullptr (some number:
    %.3f)", *  3.14159);
    
    
     LogScopeF(INFO, "Will indent all log messages within this
    scope.");
     // in a function, you may use LogScopeFunction(INFO)
    
    
     // scope can be explicitly started and closed by LogStartScope
    (or
     // LogStartScopef) and LogEndScope
     LogStartScope(INFO, "id-used-as-message");
     LogStartScopeF(INFO, "id", "message-%d", 1);
     LogEndScope("id");
     LogEndScope("id-used-as-message");
    
    
     // alternatively, you can use streams instead of printf-style
     Log(INFO, "I'm hungry for some " << 3.14159 << "!");
     LogIF(INFO, ptr == nullptr, "ptr is " << "nullptr");
    
    @section logging_and_legacy_macros Logging and VTK error macros
    
    VTK has long supported multiple macros to report errors, warnings and
    debug messages through `vtkerror_macro`, `vtkwarning_macro`,
    `vtkdebug_macro`, etc. In addition to performing the traditional
    message reporting via `vtkoutput_window`, these macros also log to the
    logging sub-system with appropriate verbosity levels.
    
    To avoid the Logger and OutputWindow both posting the message
    to the standard output streams, OutputWindow now supports an
    ability to specify terminal display mode, via
    `vtkoutput_window::set_display_mode`. If display mode is
    `vtkoutput_window::DEFAULT` then the output window will not post
    messages originating from the standard error/warning/debug macros to
    the standard output if VTK is built with logging support. If VTK is
    not built with logging support, then OutputWindow will post the
    messages to the standard output streams, unless disabled explicitly.
    
    @section Callbacks Custom callbacks/handlers for log messages
    
    Logger supports ability to register callbacks to call on each
    logged message. This is useful to show the messages in application
    specific viewports, e.g. a special message widget.
    
    To register a callback use `Logger::add_callback` and to remove a
    callback use `Logger::remove_callback` with the id provided when
    registering the callback.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkLogger, obj, update, **traits)
    
    thread_name = traits.String('', enter_set=True, auto_set=False, desc=\
        """
        Get/Set the name to identify the current thread in the log
        output.
        """
    )

    def _thread_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetThreadName,
                        self.thread_name)

    def _get_current_verbosity_cutoff(self):
        return self._vtk_obj.GetCurrentVerbosityCutoff()
    current_verbosity_cutoff = traits.Property(_get_current_verbosity_cutoff, desc=\
        """
        Returns the maximum verbosity of all log outputs. A log item for
        a verbosity higher than this will not be generated in any of the
        currently active outputs.
        """
    )

    def get_identifier(self, *args):
        """
        get_identifier(obj:ObjectBase) -> str
        C++: static std::string get_identifier(ObjectBase *obj)
        Returns a printable string for a ObjectBase instance.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetIdentifier, *my_args)
        return ret

    def convert_to_verbosity(self, *args):
        """
        convert_to_verbosity(value:int) -> Verbosity
        C++: static Verbosity convert_to_verbosity(int value)
        convert_to_verbosity(text:str) -> Verbosity
        C++: static Verbosity convert_to_verbosity(const char *text)
        Convenience function to convert an integer to matching verbosity
        level. If val is less than or equal to
        Logger::VERBOSITY_INVALID, then Logger::VERBOSITY_INVALID
        is returned. If value is greater than Logger::VERBOSITY_MAX,
        then Logger::VERBOSITY_MAX is returned.
        """
        ret = self._wrap_call(self._vtk_obj.ConvertToVerbosity, *args)
        return ret

    def end_log_to_file(self, *args):
        """
        end_log_to_file(path:str) -> None
        C++: static void end_log_to_file(const char *path)
        Stop logging to a file at the given path.
        """
        ret = self._wrap_call(self._vtk_obj.EndLogToFile, *args)
        return ret

    def end_scope(self, *args):
        """
        end_scope(id:str) -> None
        C++: static void end_scope(const char *id)"""
        ret = self._wrap_call(self._vtk_obj.EndScope, *args)
        return ret

    def init(self):
        """
        init() -> None
        C++: static void init()"""
        ret = self._vtk_obj.Init()
        return ret
        

    def is_enabled(self):
        """
        is_enabled() -> bool
        C++: static bool is_enabled()
        Returns true if VTK is built with logging support enabled.
        """
        ret = self._vtk_obj.IsEnabled()
        return ret
        

    def log(self, *args):
        """
        log(verbosity:Verbosity, fname:str, lineno:int, txt:str) -> None
        C++: static void log(Verbosity verbosity, const char *fname,
            unsigned int lineno, const char *txt)"""
        ret = self._wrap_call(self._vtk_obj.Log, *args)
        return ret

    def log_to_file(self, *args):
        """
        log_to_file(path:str, filemode:FileMode, verbosity:Verbosity)
            -> None
        C++: static void log_to_file(const char *path, FileMode filemode,
            Verbosity verbosity)
        Enable logging to a file at the given path. Any logging message
        with verbosity lower or equal to the given verbosity will be
        included. This method will create all directories in the 'path'
        if needed. To stop the file logging, call `end_log_to_file` with the
        same path.
        """
        ret = self._wrap_call(self._vtk_obj.LogToFile, *args)
        return ret

    def new_instance(self):
        """
        new_instance(self) -> Logger
        C++: Logger *new_instance()"""
        ret = wrap_vtk(self._vtk_obj.NewInstance())
        return ret
        

    def remove_callback(self, *args):
        """
        remove_callback(id:str) -> bool
        C++: static bool remove_callback(const char *id)
        Remove a callback using the id specified. Returns true if and
        only if the callback was found (and removed).
        """
        ret = self._wrap_call(self._vtk_obj.RemoveCallback, *args)
        return ret

    def safe_down_cast(self, *args):
        """
        safe_down_cast(o:ObjectBase) -> Logger
        C++: static Logger *safe_down_cast(ObjectBase *o)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SafeDownCast, *my_args)
        return wrap_vtk(ret)

    def set_internal_verbosity_level(self, *args):
        """
        set_internal_verbosity_level(level:Verbosity) -> None
        C++: static void set_internal_verbosity_level(Verbosity level)
        Set internal messages verbosity level. The library used by VTK,
        `loguru` generates log messages during initialization and at
        exit. These are logged as log level VERBOSITY_1, by default. One
        can change that using this method. Typically, you want to call
        this before `Logger::Init`.
        """
        ret = self._wrap_call(self._vtk_obj.SetInternalVerbosityLevel, *args)
        return ret

    def set_stderr_verbosity(self, *args):
        """
        set_stderr_verbosity(level:Verbosity) -> None
        C++: static void set_stderr_verbosity(Verbosity level)
        Set the verbosity level for the output logged to stderr.
        Everything with a verbosity equal or less than the level
        specified will be written to stderr. Set to `VERBOSITY_OFF` to
        write nothing to stderr. Default is 0.
        """
        ret = self._wrap_call(self._vtk_obj.SetStderrVerbosity, *args)
        return ret

    def start_scope(self, *args):
        """
        start_scope(verbosity:Verbosity, id:str, fname:str, lineno:int)
            -> None
        C++: static void start_scope(Verbosity verbosity, const char *id,
            const char *fname, unsigned int lineno)"""
        ret = self._wrap_call(self._vtk_obj.StartScope, *args)
        return ret

    _updateable_traits_ = \
    (('thread_name', 'GetThreadName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['thread_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Logger, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Logger properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['thread_name']),
            title='Edit Logger properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Logger properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

