# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.writer import Writer


class JavaScriptDataWriter(Writer):
    """
    JavaScriptDataWriter - A Javascript data writer for Table
    
    Superclass: Writer
    
    Writes a Table into a Javascript data format.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkJavaScriptDataWriter, obj, update, **traits)
    
    file_name = tvtk_base.vtk_file_name("", desc=\
        """
        Get/Set the filename for the file.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    include_field_names = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        """
        Get/Set the whether or not to include field names When field
        names are on you will get data output that looks like this: var
        data=[ {foo:3,time:"2009-11-04 16:09:42",bar:1 }, {foo:5,time:"2009-11-04
        16:11:22",bar:0 }, without field names the data will be an array
        of arrays like this: var data=[ [3,"2009-11-04 16:09:42",1], [5,"2009-11-04
        16:11:22",0],
        
        * Default is ON (true)
        """
    )

    def _include_field_names_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIncludeFieldNames,
                        self.include_field_names)

    variable_name = traits.String('data', enter_set=True, auto_set=False, desc=\
        """
        Get/set the name of the Javascript variable that the dataset will
        be assigned to. The default value is "data", so the javascript
        code generated by the filter will look like this: "var data = [ ...
        ];". If variable_name is set to nullptr, then no assignment
        statement will be generated (i.e., only "[ ... ];" will be
        generated).
        """
    )

    def _variable_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVariableName,
                        self.variable_name)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('file_name',
    'GetFileName'), ('include_field_names', 'GetIncludeFieldNames'),
    ('variable_name', 'GetVariableName'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'file_name', 'include_field_names',
    'progress_text', 'variable_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(JavaScriptDataWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit JavaScriptDataWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['file_name', 'include_field_names', 'variable_name']),
            title='Edit JavaScriptDataWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit JavaScriptDataWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

