# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.interactor_style import InteractorStyle


class InteractorStyle3D(InteractorStyle):
    """
    InteractorStyle3D - extends interaction to support 3D input
    
    Superclass: InteractorStyle
    
    InteractorStyle3D allows the user to interact with (rotate, pan,
    etc.) objects in the scene indendent of each other. It is designed to
    use 3d positions and orientations instead of 2D.
    
    The following interactions are specified by default.
    
    A click and hold in 3D within the bounding box of a prop will pick up
    that prop allowing you to translate and orient that prop as desired
    with the 3D controller.
    
    Click/dragging two controllers and pulling them apart or pushing them
    together will initial a scale gesture that will scale the world
    larger or smaller.
    
    Click/dragging two controllers and translating them in the same
    direction will translate the camera/world pushing them together will
    initial a scale gesture that will scale the world larger or smaller.
    
    If a controller is right clicked (push touchpad on Vive) then it
    starts a fly motion where the camer moves in the direction the
    controller is pointing. It moves at a speed scaled by the position of
    your thumb on the trackpad. Higher moves faster forward. Lower moves
    faster backwards.
    
    For the Vive left click is mapped to the trigger and right click is
    mapped to pushing the trackpad down.
    
    @sa
    RenderWindowInteractor3D
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkInteractorStyle3D, obj, update, **traits)
    
    dolly_physical_speed = traits.Float(1.6666, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the maximum dolly speed used when flying in 3D, in meters
        per second. Default is 1.6666, corresponding to walking speed (=
        6 km/h). This speed is scaled by the touchpad position as well.
        """
    )

    def _dolly_physical_speed_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDollyPhysicalSpeed,
                        self.dolly_physical_speed)

    def _get_interaction_picker(self):
        return wrap_vtk(self._vtk_obj.GetInteractionPicker())
    def _set_interaction_picker(self, arg):
        old_val = self._get_interaction_picker()
        self._wrap_call(self._vtk_obj.SetInteractionPicker,
                        deref_vtk(arg))
        self.trait_property_changed('interaction_picker', old_val, arg)
    interaction_picker = traits.Property(_get_interaction_picker, _set_interaction_picker, desc=\
        """
        Get/Set the interaction picker. By default, a PropPicker is
        instancied.
        """
    )

    def dolly3d(self, *args):
        """
        dolly3d(self, __a:EventData) -> None
        C++: virtual void dolly3d(EventData *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Dolly3D, *my_args)
        return ret

    def position_prop(self, *args):
        """
        position_prop(self, __a:EventData, lwpos:[float, ...]=...,
            lwori:[float, ...]=...) -> None
        C++: virtual void position_prop(EventData *,
            double *lwpos=nullptr, double *lwori=nullptr)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PositionProp, *my_args)
        return ret

    def set_scale(self, *args):
        """
        set_scale(self, cam:Camera, newScale:float) -> None
        C++: virtual void set_scale(Camera *cam, double newScale)
        Set the scaling factor from world to physical space. In VR when
        we set it to a new value we also adjust the HMD position to
        maintain the same relative position.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetScale, *my_args)
        return ret

    _updateable_traits_ = \
    (('auto_adjust_camera_clipping_range',
    'GetAutoAdjustCameraClippingRange'), ('handle_observers',
    'GetHandleObservers'), ('use_timers', 'GetUseTimers'), ('enabled',
    'GetEnabled'), ('key_press_activation', 'GetKeyPressActivation'),
    ('picking_managed', 'GetPickingManaged'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('dolly_physical_speed', 'GetDollyPhysicalSpeed'),
    ('mouse_wheel_motion_factor', 'GetMouseWheelMotionFactor'),
    ('pick_color', 'GetPickColor'), ('timer_duration',
    'GetTimerDuration'), ('key_press_activation_value',
    'GetKeyPressActivationValue'), ('priority', 'GetPriority'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['auto_adjust_camera_clipping_range', 'debug', 'enabled',
    'global_warning_display', 'handle_observers', 'key_press_activation',
    'picking_managed', 'use_timers', 'dolly_physical_speed',
    'key_press_activation_value', 'mouse_wheel_motion_factor',
    'pick_color', 'priority', 'timer_duration'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(InteractorStyle3D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit InteractorStyle3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['auto_adjust_camera_clipping_range', 'enabled',
            'handle_observers', 'key_press_activation', 'picking_managed',
            'use_timers'], [], ['dolly_physical_speed',
            'key_press_activation_value', 'mouse_wheel_motion_factor',
            'pick_color', 'priority', 'timer_duration']),
            title='Edit InteractorStyle3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit InteractorStyle3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

