# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Importer(Object):
    """
    Importer - importer abstract class
    
    Superclass: Object
    
    Importer is an abstract class that specifies the protocol for
    importing actors, cameras, lights and properties into a
    RenderWindow. The following takes place:
    1) Create a render_window and Renderer if none is provided.
    2) Call import_begin, if import_begin returns False, return
    3) Call read_data, which calls: a) Import the Actors b) Import the
       cameras c) Import the lights d) Import the Properties
    7) Call import_end
    
    Subclasses optionally implement the import_actors, import_cameras,
    import_lights and import_properties or read_data methods. An import_begin
    and import_end can optionally be provided to perform Importer-specific
    initialization and termination.  The Read method initiates the import
    process. If a render_window is provided, its Renderer will contained
    the imported objects. If the render_window has no Renderer, one is
    created. If no render_window is provided, both a render_window and
    Renderer will be created. Both the render_window and Renderer can be
    accessed using Get methods.
    
    @sa
    ThreeDSImporter Exporter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImporter, obj, update, **traits)
    
    def _get_render_window(self):
        return wrap_vtk(self._vtk_obj.GetRenderWindow())
    def _set_render_window(self, arg):
        old_val = self._get_render_window()
        self._wrap_call(self._vtk_obj.SetRenderWindow,
                        deref_vtk(arg))
        self.trait_property_changed('render_window', old_val, arg)
    render_window = traits.Property(_get_render_window, _set_render_window, desc=\
        """
        
        """
    )

    def get_animation_name(self, *args):
        """
        get_animation_name(self, animationIndex:int) -> str
        C++: virtual std::string get_animation_name(
            IdType animationIndex)
        Get the name of an animation. Return an empty if not provided by
        implementation.
        """
        ret = self._wrap_call(self._vtk_obj.GetAnimationName, *args)
        return ret

    def get_camera_name(self, *args):
        """
        get_camera_name(self, camIndex:int) -> str
        C++: virtual std::string get_camera_name(IdType camIndex)
        Get the name of a camera. Return an empty string if not provided
        by implementation.
        """
        ret = self._wrap_call(self._vtk_obj.GetCameraName, *args)
        return ret

    def _get_number_of_animations(self):
        return self._vtk_obj.GetNumberOfAnimations()
    number_of_animations = traits.Property(_get_number_of_animations, desc=\
        """
        Get the number of available animations. Return -1 if not provided
        by implementation.
        """
    )

    def _get_number_of_cameras(self):
        return self._vtk_obj.GetNumberOfCameras()
    number_of_cameras = traits.Property(_get_number_of_cameras, desc=\
        """
        Get the number of available cameras. Return 0 if not provided by
        implementation.
        """
    )

    def _get_outputs_description(self):
        return self._vtk_obj.GetOutputsDescription()
    outputs_description = traits.Property(_get_outputs_description, desc=\
        """
        Recover a printable string that let importer implementation
        Describe their outputs.
        """
    )

    def _get_renderer(self):
        return wrap_vtk(self._vtk_obj.GetRenderer())
    renderer = traits.Property(_get_renderer, desc=\
        """
        Get the renderer that contains the imported actors, cameras and
        lights.
        """
    )

    def get_temporal_information(self, *args):
        """
        get_temporal_information(self, animationIndex:int, frameRate:float,
            nbTimeSteps:int, timeRange:[float, float],
            timeSteps:DoubleArray) -> bool
        C++: virtual bool get_temporal_information(IdType animationIndex,
             double frameRate, int &nbTimeSteps, double timeRange[2],
            DoubleArray *timeSteps)
        Get temporal informations for the currently enabled animations.
        the three return arguments can be defined or not. Return true in
        case of success, false otherwise.
        """
        my_args = deref_array(args, [('int', 'float', 'int', ['float', 'float'], 'vtkDoubleArray')])
        ret = self._wrap_call(self._vtk_obj.GetTemporalInformation, *my_args)
        return ret

    def disable_animation(self, *args):
        """
        disable_animation(self, animationIndex:int) -> None
        C++: virtual void disable_animation(IdType animationIndex)"""
        ret = self._wrap_call(self._vtk_obj.DisableAnimation, *args)
        return ret

    def enable_animation(self, *args):
        """
        enable_animation(self, animationIndex:int) -> None
        C++: virtual void enable_animation(IdType animationIndex)
        Enable/Disable/Get the status of specific animations
        """
        ret = self._wrap_call(self._vtk_obj.EnableAnimation, *args)
        return ret

    def is_animation_enabled(self, *args):
        """
        is_animation_enabled(self, animationIndex:int) -> bool
        C++: virtual bool is_animation_enabled(IdType animationIndex)"""
        ret = self._wrap_call(self._vtk_obj.IsAnimationEnabled, *args)
        return ret

    def read(self):
        """
        read(self) -> None
        C++: void read()
        Import the actors, cameras, lights and properties into a
        RenderWindow.
        """
        ret = self._vtk_obj.Read()
        return ret
        

    def set_camera(self, *args):
        """
        set_camera(self, camIndex:int) -> None
        C++: virtual void set_camera(IdType camIndex)
        Enable a specific camera. If a negative index is provided, no
        camera from the importer is used. Does nothing if not provided by
        implementation.
        """
        ret = self._wrap_call(self._vtk_obj.SetCamera, *args)
        return ret

    def update(self):
        """
        update(self) -> None
        C++: void update()"""
        ret = self._vtk_obj.Update()
        return ret
        

    def update_time_step(self, *args):
        """
        update_time_step(self, timeStep:float) -> None
        C++: virtual void update_time_step(double timeStep)
        Import the actors, camera, lights and properties at a specific
        timestep. If not reimplemented, only call Update().
        """
        ret = self._wrap_call(self._vtk_obj.UpdateTimeStep, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Importer, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Importer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit Importer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Importer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

