# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.threaded_image_algorithm import ThreadedImageAlgorithm


class ImageCast(ThreadedImageAlgorithm):
    """
    ImageCast - Image Data type Casting Filter
    
    Superclass: ThreadedImageAlgorithm
    
    ImageCast filter casts the input type to match the output type in
    the image processing pipeline.  The filter does nothing if the input
    already has the correct type.  To specify the "cast_to" type, use
    "set_output_scalar_type" method.
    
    @warning
    As ImageCast only casts values without rescaling them, its use is
    not recommended. ImageShiftScale is the recommended way to change
    the type of an image data.
    
    @sa
    ImageThreshold ImageShiftScale
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImageCast, obj, update, **traits)
    
    clamp_overflow = tvtk_base.false_bool_trait(desc=\
        """
        When the clamp_overflow flag is on, the data is thresholded so
        that the output value does not exceed the max or min of the data
        type. Clamping is safer because otherwise you might invoke
        undefined behavior (and may crash) if the type conversion is out
        of range of the data type.  On the other hand, clamping is
        slower. By default clamp_overflow is off.
        """
    )

    def _clamp_overflow_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetClampOverflow,
                        self.clamp_overflow_)

    def get_output_scalar_type(self):
        """
        get_output_scalar_type(self) -> int
        C++: virtual int get_output_scalar_type()"""
        ret = self._vtk_obj.GetOutputScalarType()
        return ret
        

    def set_output_scalar_type(self, *args):
        """
        set_output_scalar_type(self, _arg:int) -> None
        C++: virtual void set_output_scalar_type(int _arg)
        Set the desired output scalar type to cast to.
        """
        ret = self._wrap_call(self._vtk_obj.SetOutputScalarType, *args)
        return ret

    def set_output_scalar_type_to_char(self):
        """
        set_output_scalar_type_to_char(self) -> None
        C++: void set_output_scalar_type_to_char()"""
        self._vtk_obj.SetOutputScalarTypeToChar()

    def set_output_scalar_type_to_double(self):
        """
        set_output_scalar_type_to_double(self) -> None
        C++: void set_output_scalar_type_to_double()"""
        self._vtk_obj.SetOutputScalarTypeToDouble()

    def set_output_scalar_type_to_float(self):
        """
        set_output_scalar_type_to_float(self) -> None
        C++: void set_output_scalar_type_to_float()"""
        self._vtk_obj.SetOutputScalarTypeToFloat()

    def set_output_scalar_type_to_int(self):
        """
        set_output_scalar_type_to_int(self) -> None
        C++: void set_output_scalar_type_to_int()"""
        self._vtk_obj.SetOutputScalarTypeToInt()

    def set_output_scalar_type_to_long(self):
        """
        set_output_scalar_type_to_long(self) -> None
        C++: void set_output_scalar_type_to_long()"""
        self._vtk_obj.SetOutputScalarTypeToLong()

    def set_output_scalar_type_to_short(self):
        """
        set_output_scalar_type_to_short(self) -> None
        C++: void set_output_scalar_type_to_short()"""
        self._vtk_obj.SetOutputScalarTypeToShort()

    def set_output_scalar_type_to_unsigned_char(self):
        """
        set_output_scalar_type_to_unsigned_char(self) -> None
        C++: void set_output_scalar_type_to_unsigned_char()"""
        self._vtk_obj.SetOutputScalarTypeToUnsignedChar()

    def set_output_scalar_type_to_unsigned_int(self):
        """
        set_output_scalar_type_to_unsigned_int(self) -> None
        C++: void set_output_scalar_type_to_unsigned_int()"""
        self._vtk_obj.SetOutputScalarTypeToUnsignedInt()

    def set_output_scalar_type_to_unsigned_long(self):
        """
        set_output_scalar_type_to_unsigned_long(self) -> None
        C++: void set_output_scalar_type_to_unsigned_long()"""
        self._vtk_obj.SetOutputScalarTypeToUnsignedLong()

    def set_output_scalar_type_to_unsigned_short(self):
        """
        set_output_scalar_type_to_unsigned_short(self) -> None
        C++: void set_output_scalar_type_to_unsigned_short()"""
        self._vtk_obj.SetOutputScalarTypeToUnsignedShort()

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('clamp_overflow', 'GetClampOverflow'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('split_mode', 'GetSplitMode'),
    ('desired_bytes_per_piece', 'GetDesiredBytesPerPiece'), ('enable_smp',
    'GetEnableSMP'), ('global_default_enable_smp',
    'GetGlobalDefaultEnableSMP'), ('minimum_piece_size',
    'GetMinimumPieceSize'), ('number_of_threads', 'GetNumberOfThreads'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'clamp_overflow', 'debug',
    'global_warning_display', 'release_data_flag', 'split_mode',
    'desired_bytes_per_piece', 'enable_smp', 'global_default_enable_smp',
    'minimum_piece_size', 'number_of_threads', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImageCast, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ImageCast properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['clamp_overflow'], ['split_mode'], ['desired_bytes_per_piece',
            'enable_smp', 'global_default_enable_smp', 'minimum_piece_size',
            'number_of_threads']),
            title='Edit ImageCast properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImageCast properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

