# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.hyper_tree_grid_algorithm import HyperTreeGridAlgorithm


class HyperTreeGridSource(HyperTreeGridAlgorithm):
    """
    HyperTreeGridSource - Create a synthetic grid of hypertrees.
    
    Superclass: HyperTreeGridAlgorithm
    
    This class uses input parameters, most notably a string descriptor,
    to generate a HyperTreeGrid instance representing the
    corresponding tree-based AMR grid. This descriptor uses the following
    conventions, e.g., to describe a 1-D ternary subdivision with 2 root
    cells L0    L1        L2 RR  | .R. ... | ... For this tree:
     HTG:       .
              /   \
     L0:     .     .
            /|\   /|\
     L1:   c . c c c c
            /|\
     L2:   c c c The top level of the tree is not considered a grid level
    NB: For ease of legibility, white spaces are allowed and ignored.
    
    @par Thanks: This class was written by Philippe Pebay, Joachim
    Pouderoux, and Charles Law, Kitware 2013 This class was modified by
    Guenole Harel and Jacques-Bernard Lekien 2014 This class was modified
    by Philippe Pebay, 2016 This work was supported by Commissariat a
    l'Energie Atomique (CEA/DIF) CEA, DAM, DIF, F-91297 Arpajon, France.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHyperTreeGridSource, obj, update, **traits)
    
    generate_interface_fields = tvtk_base.false_bool_trait(desc=\
        """
        Set/get whether cell-centered interface fields should be
        generated. Default: false
        """
    )

    def _generate_interface_fields_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateInterfaceFields,
                        self.generate_interface_fields_)

    use_descriptor = tvtk_base.true_bool_trait(desc=\
        """
        Set/get whether the descriptor string should be used. NB:
        Otherwise a quadric definition is expected. Default: true
        """
    )

    def _use_descriptor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseDescriptor,
                        self.use_descriptor_)

    use_mask = tvtk_base.false_bool_trait(desc=\
        """
        Set/get whether the material mask should be used. NB: This is
        only used when use_descriptor is ON Default: false
        """
    )

    def _use_mask_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseMask,
                        self.use_mask_)

    branch_factor = traits.Trait(2, traits.Range(2, 3, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the subdivision factor in the grid refinement scheme
        """
    )

    def _branch_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBranchFactor,
                        self.branch_factor)

    descriptor = traits.String('.', enter_set=True, auto_set=False, desc=\
        """
        Set/Get the string used to describe the grid.
        """
    )

    def _descriptor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDescriptor,
                        self.descriptor)

    def _get_descriptor_bits(self):
        return wrap_vtk(self._vtk_obj.GetDescriptorBits())
    def _set_descriptor_bits(self, arg):
        old_val = self._get_descriptor_bits()
        my_arg = deref_array([arg], [['vtkBitArray']])
        self._wrap_call(self._vtk_obj.SetDescriptorBits,
                        my_arg[0])
        self.trait_property_changed('descriptor_bits', old_val, arg)
    descriptor_bits = traits.Property(_get_descriptor_bits, _set_descriptor_bits, desc=\
        """
        
        """
    )

    dimensions = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="int64", value=(1, 1, 1), cols=3, desc=\
        """
        Set/Get the number of root cells + 1 in each dimension of the
        grid
        """
    )

    def _dimensions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDimensions,
                        self.dimensions)

    grid_scale = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(1.0, 1.0, 1.0), cols=3, desc=\
        """
        Set/Get the scale to be applied to root cells in each dimension
        of the grid
        """
    )

    def _grid_scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGridScale,
                        self.grid_scale)

    mask = traits.String('0', enter_set=True, auto_set=False, desc=\
        """
        Set/Get the string used to as a material mask.
        """
    )

    def _mask_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMask,
                        self.mask)

    def _get_mask_bits(self):
        return wrap_vtk(self._vtk_obj.GetMaskBits())
    def _set_mask_bits(self, arg):
        old_val = self._get_mask_bits()
        my_arg = deref_array([arg], [['vtkBitArray']])
        self._wrap_call(self._vtk_obj.SetMaskBits,
                        my_arg[0])
        self.trait_property_changed('mask_bits', old_val, arg)
    mask_bits = traits.Property(_get_mask_bits, _set_mask_bits, desc=\
        """
        
        """
    )

    max_depth = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        Set the maximum number of levels of the hypertrees.
        \pre positive_levels: levels>=1
        \post is_set: this->get_levels()==levels
        \post min_is_valid: this->get_min_levels()<this->get_levels()
        """
    )

    def _max_depth_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaxDepth,
                        self.max_depth)

    maximum_level = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _maximum_level_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumLevel,
                        self.maximum_level)

    origin = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        """
        Set/Get the origin of the grid
        """
    )

    def _origin_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOrigin,
                        self.origin)

    def _get_quadric(self):
        return wrap_vtk(self._vtk_obj.GetQuadric())
    def _set_quadric(self, arg):
        old_val = self._get_quadric()
        self._wrap_call(self._vtk_obj.SetQuadric,
                        deref_vtk(arg))
        self.trait_property_changed('quadric', old_val, arg)
    quadric = traits.Property(_get_quadric, _set_quadric, desc=\
        """
        
        """
    )

    quadric_coefficients = traits.Trait((traits.Undefined, traits.Undefined, traits.Undefined, traits.Undefined, traits.Undefined, traits.Undefined, traits.Undefined, traits.Undefined, traits.Undefined, traits.Undefined), traits.Array(shape=(10,), dtype="float", value=(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), cols=3), enter_set=True, auto_set=False, desc=\
        """
        Helpers to set/get the 10 coefficients of the quadric function
        """
    )

    def _quadric_coefficients_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetQuadricCoefficients,
                        self.quadric_coefficients)

    transposed_root_indexing = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        """
        Specify whether indexing mode of grid root cells must be
        transposed to x-axis first, z-axis last, instead of the default
        z-axis first, k-axis last
        """
    )

    def _transposed_root_indexing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTransposedRootIndexing,
                        self.transposed_root_indexing)

    def _get_orientation(self):
        return self._vtk_obj.GetOrientation()
    orientation = traits.Property(_get_orientation, desc=\
        """
        Set/Get the orientation of the grid (in 1D and 2D)
        """
    )

    def convert_descriptor_string_to_bit_array(self, *args):
        """
        convert_descriptor_string_to_bit_array(self, __a:str) -> BitArray
        C++: BitArray *convert_descriptor_string_to_bit_array(
            const std::string &)
        Helpers to convert string descriptors & mask to bit arrays
        """
        ret = self._wrap_call(self._vtk_obj.ConvertDescriptorStringToBitArray, *args)
        return wrap_vtk(ret)

    def convert_mask_string_to_bit_array(self, *args):
        """
        convert_mask_string_to_bit_array(self, __a:str) -> BitArray
        C++: BitArray *convert_mask_string_to_bit_array(const std::string &)"""
        ret = self._wrap_call(self._vtk_obj.ConvertMaskStringToBitArray, *args)
        return wrap_vtk(ret)

    def set_indexing_mode_to_ijk(self):
        """
        set_indexing_mode_to_ijk(self) -> None
        C++: void set_indexing_mode_to_ijk()"""
        ret = self._vtk_obj.SetIndexingModeToIJK()
        return ret
        

    def set_indexing_mode_to_kji(self):
        """
        set_indexing_mode_to_kji(self) -> None
        C++: void set_indexing_mode_to_kji()"""
        ret = self._vtk_obj.SetIndexingModeToKJI()
        return ret
        

    def set_level_zero_material_index(self, *args):
        """
        set_level_zero_material_index(self, __a:IdTypeArray) -> None
        C++: virtual void set_level_zero_material_index(IdTypeArray *)
        Set the index array used to as a material mask.
        """
        my_args = deref_array(args, [['vtkIdTypeArray']])
        ret = self._wrap_call(self._vtk_obj.SetLevelZeroMaterialIndex, *my_args)
        return ret

    _updateable_traits_ = \
    (('generate_interface_fields', 'GetGenerateInterfaceFields'),
    ('use_descriptor', 'GetUseDescriptor'), ('use_mask', 'GetUseMask'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('branch_factor', 'GetBranchFactor'), ('descriptor', 'GetDescriptor'),
    ('dimensions', 'GetDimensions'), ('grid_scale', 'GetGridScale'),
    ('mask', 'GetMask'), ('max_depth', 'GetMaxDepth'), ('maximum_level',
    'GetMaximumLevel'), ('origin', 'GetOrigin'),
    ('transposed_root_indexing', 'GetTransposedRootIndexing'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'generate_interface_fields',
    'global_warning_display', 'release_data_flag', 'use_descriptor',
    'use_mask', 'branch_factor', 'descriptor', 'dimensions', 'grid_scale',
    'mask', 'max_depth', 'maximum_level', 'origin', 'progress_text',
    'transposed_root_indexing'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HyperTreeGridSource, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HyperTreeGridSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['generate_interface_fields', 'use_descriptor', 'use_mask'], [],
            ['branch_factor', 'descriptor', 'dimensions', 'grid_scale', 'mask',
            'max_depth', 'maximum_level', 'origin', 'transposed_root_indexing']),
            title='Edit HyperTreeGridSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HyperTreeGridSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

