# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class HyperTreeGridNonOrientedCursor(Object):
    """
    HyperTreeGridNonOrientedCursor - Objects for traversal a
    hyper_tree_grid.
    
    Superclass: Object
    
    JB A REVOIR Objects that can perform depth traversal of a hyper tree
    grid, take into account more parameters (related to the grid
    structure) than the compact hyper tree cursor implemented in
    HyperTree can. This is an abstract class. Cursors are created by
    the hyper_tree_grid implementation.
    
    @sa
    HyperTreeCursor HyperTree HyperTreeGrid
    
    @par Thanks: This class was written by Guenole Harel and
    Jacques-Bernard Lekien, 2014. This class was re-written by Philippe
    Pebay, 2016. JB This class was re-written for more optimisation by
    Jacques-Bernard Lekien, Guenole Harel and Jerome Dubois, 2018. This
    work was supported by Commissariat a l'Energie Atomique CEA, DAM,
    DIF, F-91297 Arpajon, France.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHyperTreeGridNonOrientedCursor, obj, update, **traits)
    
    def _get_dimension(self):
        return self._vtk_obj.GetDimension()
    dimension = traits.Property(_get_dimension, desc=\
        """
        Return the dimension of the tree.
        \post positive_result: result>0
        """
    )

    def _get_global_node_index(self):
        return self._vtk_obj.GetGlobalNodeIndex()
    global_node_index = traits.Property(_get_global_node_index, desc=\
        """
        Return the global index (relative to the grid) of the current
        vertex in the tree.
        """
    )

    def _get_grid(self):
        return wrap_vtk(self._vtk_obj.GetGrid())
    grid = traits.Property(_get_grid, desc=\
        """
        Set the hyper tree grid to which the cursor is pointing.
        """
    )

    def _get_level(self):
        return self._vtk_obj.GetLevel()
    level = traits.Property(_get_level, desc=\
        """
        Get the level of the tree vertex pointed by the cursor.
        """
    )

    def _get_number_of_children(self):
        return self._vtk_obj.GetNumberOfChildren()
    number_of_children = traits.Property(_get_number_of_children, desc=\
        """
        Return the number of children for each node (non-vertex leaf) of
        the tree.
        \post positive_number: result>0
        """
    )

    def _get_tree(self):
        return wrap_vtk(self._vtk_obj.GetTree())
    tree = traits.Property(_get_tree, desc=\
        """
        Set the hyper tree to which the cursor is pointing.
        """
    )

    def _get_vertex_id(self):
        return self._vtk_obj.GetVertexId()
    vertex_id = traits.Property(_get_vertex_id, desc=\
        """
        Return the index of the current vertex in the tree.
        """
    )

    def clone(self):
        """
        clone(self) -> HyperTreeGridNonOrientedCursor
        C++: HyperTreeGridNonOrientedCursor *clone()
        Create a copy of `this'.
        \\post results_exists:result!=0
        """
        ret = wrap_vtk(self._vtk_obj.Clone())
        return ret
        

    def has_tree(self):
        """
        has_tree(self) -> bool
        C++: bool has_tree()
        Return if a Tree pointing exist
        """
        ret = self._vtk_obj.HasTree()
        return ret
        

    def initialize(self, *args):
        """
        initialize(self, grid:HyperTreeGrid, treeIndex:int,
            create:bool=False) -> None
        C++: void initialize(HyperTreeGrid *grid, IdType treeIndex,
            bool create=false)
        initialize(self, grid:HyperTreeGrid, tree:HyperTree,
            level:int, index:int) -> None
        C++: void initialize(HyperTreeGrid *grid, HyperTree *tree,
            unsigned int level, IdType index)
        Initialize cursor at root of given tree index in grid.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Initialize, *my_args)
        return ret

    def is_leaf(self):
        """
        is_leaf(self) -> bool
        C++: bool is_leaf()
        Is the cursor pointing to a leaf?
        """
        ret = self._vtk_obj.IsLeaf()
        return ret
        

    def is_masked(self):
        """
        is_masked(self) -> bool
        C++: bool is_masked()
        Determine whether blanking mask is empty or not
        """
        ret = self._vtk_obj.IsMasked()
        return ret
        

    def is_root(self):
        """
        is_root(self) -> bool
        C++: bool is_root()
        Is the cursor at tree root?
        """
        ret = self._vtk_obj.IsRoot()
        return ret
        

    def set_global_index_from_local(self, *args):
        """
        set_global_index_from_local(self, index:int) -> None
        C++: void set_global_index_from_local(IdType index)
        JB
        """
        ret = self._wrap_call(self._vtk_obj.SetGlobalIndexFromLocal, *args)
        return ret

    def set_global_index_start(self, *args):
        """
        set_global_index_start(self, index:int) -> None
        C++: void set_global_index_start(IdType index)
        JB
        """
        ret = self._wrap_call(self._vtk_obj.SetGlobalIndexStart, *args)
        return ret

    def set_mask(self, *args):
        """
        set_mask(self, state:bool) -> None
        C++: void set_mask(bool state)
        Set the blanking mask is empty or not
        \\pre not_tree: tree
        """
        ret = self._wrap_call(self._vtk_obj.SetMask, *args)
        return ret

    def subdivide_leaf(self):
        """
        subdivide_leaf(self) -> None
        C++: void subdivide_leaf()
        JB
        """
        ret = self._vtk_obj.SubdivideLeaf()
        return ret
        

    def to_child(self, *args):
        """
        to_child(self, ichild:int) -> None
        C++: void to_child(unsigned char ichild)
        Move the cursor to child `child' of the current vertex.
        \\pre not_tree: has_tree()
        \\pre not_leaf: !is_leaf()
        \\pre valid_child: ichild>=0 && ichild<get_number_of_children()
        \\pre depth_limiter: get_level() <= get_depth_limiter()
        """
        ret = self._wrap_call(self._vtk_obj.ToChild, *args)
        return ret

    def to_parent(self):
        """
        to_parent(self) -> None
        C++: void to_parent()
        Move the cursor to the parent of the current vertex. Authorized
        if has_history return true.
        \\pre Non_root: !is_root()
        """
        ret = self._vtk_obj.ToParent()
        return ret
        

    def to_root(self):
        """
        to_root(self) -> None
        C++: void to_root()
        Move the cursor to the root vertex.
        \\pre can be root
        \\post is_root: is_root()
        """
        ret = self._vtk_obj.ToRoot()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HyperTreeGridNonOrientedCursor, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HyperTreeGridNonOrientedCursor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit HyperTreeGridNonOrientedCursor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HyperTreeGridNonOrientedCursor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

