# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.non_linear_cell import NonLinearCell


class HigherOrderWedge(NonLinearCell):
    """
    HigherOrderWedge - A 3D cell that represents an arbitrary order
    higher_order wedge
    
    Superclass: NonLinearCell
    
    HigherOrderWedge is a concrete implementation of Cell to
    represent a 3D wedge using higher_order shape functions of user
    specified order. A wedge consists of two triangular and three
    quadrilateral faces. The first six points of the wedge (0-5) are the
    "corner" points where the first three points are the base of the
    wedge. This wedge point ordering is opposite the Wedge ordering
    though in that the base of the wedge defined by the first three
    points (0,1,2) form a triangle whose normal points inward (toward the
    triangular face (3,4,5)). While this is opposite the Wedge
    convention it is consistent with every other cell type in VTK. The
    first 2 parametric coordinates of the higher_order wedge or for the
    triangular base and vary between 0 and 1. The third parametric
    coordinate is between the two triangular faces and goes from 0 to 1
    as well.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHigherOrderWedge, obj, update, **traits)
    
    def get_order(self, *args):
        """
        get_order(self) -> Pointer
        C++: virtual const int *get_order()
        get_order(self, i:int) -> int
        C++: virtual int get_order(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetOrder, *args)
        return ret

    def set_order(self, *args):
        """
        set_order(self, s:int, t:int, u:int, numPts:int) -> None
        C++: virtual void set_order(const int s, const int t, const int u,
            const IdType numPts)"""
        ret = self._wrap_call(self._vtk_obj.SetOrder, *args)
        return ret

    parametric_coords = traits.Array(enter_set=True, auto_set=False, shape=(18,), dtype="float", value=(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0), cols=3, desc=\
        """
        
        """
    )

    def _parametric_coords_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetParametricCoords,
                        self.parametric_coords)

    def _get_boundary_quad(self):
        return wrap_vtk(self._vtk_obj.GetBoundaryQuad())
    boundary_quad = traits.Property(_get_boundary_quad, desc=\
        """
        
        """
    )

    def _get_boundary_tri(self):
        return wrap_vtk(self._vtk_obj.GetBoundaryTri())
    boundary_tri = traits.Property(_get_boundary_tri, desc=\
        """
        
        """
    )

    def _get_edge_cell(self):
        return wrap_vtk(self._vtk_obj.GetEdgeCell())
    edge_cell = traits.Property(_get_edge_cell, desc=\
        """
        
        """
    )

    def _get_interpolation(self):
        return wrap_vtk(self._vtk_obj.GetInterpolation())
    interpolation = traits.Property(_get_interpolation, desc=\
        """
        
        """
    )

    def _get_number_of_approximating_wedges(self):
        return self._vtk_obj.GetNumberOfApproximatingWedges()
    number_of_approximating_wedges = traits.Property(_get_number_of_approximating_wedges, desc=\
        """
        
        """
    )

    def get_number_of_approximating_wedges(self, *args):
        """
        get_number_of_approximating_wedges(order:(int, ...)) -> int
        C++: static int get_number_of_approximating_wedges(const int *order)
        get_number_of_approximating_wedges(self) -> int
        C++: int get_number_of_approximating_wedges()"""
        ret = self._wrap_call(self._vtk_obj.GetNumberOfApproximatingWedges, *args)
        return ret

    def point_index_from_ijk(self, *args):
        """
        point_index_from_ijk(i:int, j:int, k:int, order:(int, ...)) -> int
        C++: static int point_index_from_ijk(int i, int j, int k,
            const int *order)
        point_index_from_ijk(self, i:int, j:int, k:int) -> int
        C++: int point_index_from_ijk(int i, int j, int k)"""
        ret = self._wrap_call(self._vtk_obj.PointIndexFromIJK, *args)
        return ret

    def set_order_from_cell_data(self, *args):
        """
        set_order_from_cell_data(self, cell_data:CellData, numPts:int,
            cell_id:int) -> None
        C++: virtual void set_order_from_cell_data(CellData *cell_data,
            const IdType numPts, const IdType cell_id)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetOrderFromCellData, *my_args)
        return ret

    def set_uniform_order_from_num_points(self, *args):
        """
        set_uniform_order_from_num_points(self, numPts:int) -> None
        C++: virtual void set_uniform_order_from_num_points(
            const IdType numPts)"""
        ret = self._wrap_call(self._vtk_obj.SetUniformOrderFromNumPoints, *args)
        return ret

    def sub_cell_coordinates_from_id(self, *args):
        """
        sub_cell_coordinates_from_id(self, ijk:Vector3i, subId:int) -> bool
        C++: bool sub_cell_coordinates_from_id(Vector3i &ijk, int subId)
        sub_cell_coordinates_from_id(self, i:int, j:int, k:int, subId:int)
            -> bool
        C++: bool sub_cell_coordinates_from_id(int &i, int &j, int &k,
            int subId)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SubCellCoordinatesFromId, *my_args)
        return ret

    def transform_approx_to_cell_params(self, *args):
        """
        transform_approx_to_cell_params(self, subCell:int, pcoords:[float,
            ...]) -> bool
        C++: bool transform_approx_to_cell_params(int subCell,
            double *pcoords)"""
        ret = self._wrap_call(self._vtk_obj.TransformApproxToCellParams, *args)
        return ret

    def transform_face_to_cell_params(self, *args):
        """
        transform_face_to_cell_params(self, bdyFace:int, pcoords:[float, ...])
             -> bool
        C++: bool transform_face_to_cell_params(int bdyFace, double *pcoords)"""
        ret = self._wrap_call(self._vtk_obj.TransformFaceToCellParams, *args)
        return ret

    def get_bdy_quad(self):
        """
        get_bdy_quad(self) -> HigherOrderQuadrilateral
        C++: virtual HigherOrderQuadrilateral *get_bdy_quad()"""
        ret = wrap_vtk(self._vtk_obj.getBdyQuad())
        return ret
        

    def get_bdy_tri(self):
        """
        get_bdy_tri(self) -> HigherOrderTriangle
        C++: virtual HigherOrderTriangle *get_bdy_tri()"""
        ret = wrap_vtk(self._vtk_obj.getBdyTri())
        return ret
        

    def get_edge_cell(self):
        """
        get_edge_cell(self) -> HigherOrderCurve
        C++: virtual HigherOrderCurve *get_edge_cell()"""
        ret = wrap_vtk(self._vtk_obj.getEdgeCell())
        return ret
        

    def get_interp(self):
        """
        get_interp(self) -> HigherOrderInterpolation
        C++: virtual HigherOrderInterpolation *get_interp()"""
        ret = wrap_vtk(self._vtk_obj.getInterp())
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('parametric_coords',
    'GetParametricCoords'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'parametric_coords'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HigherOrderWedge, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HigherOrderWedge properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['parametric_coords']),
            title='Edit HigherOrderWedge properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HigherOrderWedge properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

