# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_set_algorithm import DataSetAlgorithm


class HDFReader(DataSetAlgorithm):
    """
    HDFReader - Read VTK HDF files.
    
    Superclass: DataSetAlgorithm
    
    Reads data saved using the VTK HDF format which supports all
    DataSet types (image data and unstructured grid are currently
    implemented) and serial as well as parallel processing. See (@ref
    VTKHDFfile_format) for more information about this.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHDFReader, obj, update, **traits)
    
    file_name = tvtk_base.vtk_file_name("", desc=\
        """
        Get/Set the name of the input file.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    def get_cell_array_name(self, *args):
        """
        get_cell_array_name(self, index:int) -> str
        C++: const char *get_cell_array_name(int index)
        Get the name of the point or cell array with the given index in
        the input.
        """
        ret = self._wrap_call(self._vtk_obj.GetCellArrayName, *args)
        return ret

    def _get_cell_data_array_selection(self):
        return wrap_vtk(self._vtk_obj.GetCellDataArraySelection())
    cell_data_array_selection = traits.Property(_get_cell_data_array_selection, desc=\
        """
        Get the data array selection tables used to configure which data
        arrays are loaded by the reader.
        """
    )

    def _get_field_data_array_selection(self):
        return wrap_vtk(self._vtk_obj.GetFieldDataArraySelection())
    field_data_array_selection = traits.Property(_get_field_data_array_selection, desc=\
        """
        Get the data array selection tables used to configure which data
        arrays are loaded by the reader.
        """
    )

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    def _get_number_of_cell_arrays(self):
        return self._vtk_obj.GetNumberOfCellArrays()
    number_of_cell_arrays = traits.Property(_get_number_of_cell_arrays, desc=\
        """
        Get the number of point or cell arrays available in the input.
        """
    )

    def _get_number_of_point_arrays(self):
        return self._vtk_obj.GetNumberOfPointArrays()
    number_of_point_arrays = traits.Property(_get_number_of_point_arrays, desc=\
        """
        Get the number of point or cell arrays available in the input.
        """
    )

    def _get_output_as_data_set(self):
        return wrap_vtk(self._vtk_obj.GetOutputAsDataSet())
    output_as_data_set = traits.Property(_get_output_as_data_set, desc=\
        """
        Get the output as a DataSet pointer.
        """
    )

    def get_output_as_data_set(self, *args):
        """
        get_output_as_data_set(self) -> DataSet
        C++: DataSet *get_output_as_data_set()
        get_output_as_data_set(self, index:int) -> DataSet
        C++: DataSet *get_output_as_data_set(int index)
        Get the output as a DataSet pointer.
        """
        ret = self._wrap_call(self._vtk_obj.GetOutputAsDataSet, *args)
        return wrap_vtk(ret)

    def get_point_array_name(self, *args):
        """
        get_point_array_name(self, index:int) -> str
        C++: const char *get_point_array_name(int index)
        Get the name of the point or cell array with the given index in
        the input.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointArrayName, *args)
        return ret

    def _get_point_data_array_selection(self):
        return wrap_vtk(self._vtk_obj.GetPointDataArraySelection())
    point_data_array_selection = traits.Property(_get_point_data_array_selection, desc=\
        """
        Get the data array selection tables used to configure which data
        arrays are loaded by the reader.
        """
    )

    def can_read_file(self, *args):
        """
        can_read_file(self, name:str) -> int
        C++: virtual int can_read_file(const char *name)
        Test whether the file (type) with the given name can be read by
        this reader. If the file has a newer version than the reader, we
        still say we can read the file type and we fail later, when we
        try to read the file. This enables clients (para_view) to
        distinguish between failures when we need to look for another
        reader and failures when we don't.
        """
        ret = self._wrap_call(self._vtk_obj.CanReadFile, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('file_name',
    'GetFileName'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'file_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HDFReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HDFReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['file_name']),
            title='Edit HDFReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HDFReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

