# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.multi_block_data_set_algorithm import MultiBlockDataSetAlgorithm


class GLTFReader(MultiBlockDataSetAlgorithm):
    """
    GLTFReader - Read a GLTF file.
    
    Superclass: MultiBlockDataSetAlgorithm
    
    GLTFReader is a concrete subclass of MultiBlockDataSetAlgorithm
    that reads glTF 2.0 files.
    
    The GL Transmission Format (glTF) is an API-neutral runtime asset
    delivery format. A glTF asset is represented by:
    - A JSON-formatted file (.gltf) containing a full scene description:
      node hierarchy, materials, cameras, as well as descriptor
      information for meshes, animations, and other constructs
    - Binary files (.bin) containing geometry and animation data, and
      other buffer-based data
    - Image files (.jpg, .png) for textures
    
    This reader currently outputs a MultiBlockDataSet containing
    geometry information for the current selected scene, with animations,
    skins and morph targets applied, unless configured not to (see
    apply_deformations_to_geometry).
    
    It is possible to get information about available scenes and
    animations by using the corresponding accessors. To use animations,
    first call set_framerate with a non-zero value, then use
    enable_animation or disable_animation to configure which animations you
    would like to apply to the geometry. Finally, use UPDATE_TIME_STEPS
    to choose which frame to apply. If apply_deformations_to_geometry is set
    to true, the reader will apply the deformations, otherwise, animation
    transformation information will be saved to the dataset's field_data.
    
    Materials are currently not supported in this reader. If you would
    like to display materials, please try using GLTFImporter. You
    could also use GLTFReader::GetGLTFTexture, to access the image
    data that was loaded from the glTF 2.0 document.
    
    This reader only supports assets that use the 2.x version of the glTF
    specification.
    
    For the full glTF specification, see:
    https://github.com/khronos_group/glTF/tree/master/specification/2.0
    
    Note: array sizes should not exceed INT_MAX
    
    @sa
    MultiBlockDataSetAlgorithm GLTFImporter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGLTFReader, obj, update, **traits)
    
    apply_deformations_to_geometry = tvtk_base.true_bool_trait(desc=\
        """
        The model's skinning transforms are computed and added to the different PolyData
        objects' field data. If this flag is set to true, the reader will
        apply those skinning transforms to the model's geometry.
        """
    )

    def _apply_deformations_to_geometry_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetApplyDeformationsToGeometry,
                        self.apply_deformations_to_geometry_)

    current_scene = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _current_scene_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCurrentScene,
                        self.current_scene)

    file_name = tvtk_base.vtk_file_name("", desc=\
        """
        Set/Get the name of the file from which to read points.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    frame_rate = traits.Int(60, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _frame_rate_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFrameRate,
                        self.frame_rate)

    def _get_all_scene_names(self):
        return wrap_vtk(self._vtk_obj.GetAllSceneNames())
    all_scene_names = traits.Property(_get_all_scene_names, desc=\
        """
        Get a list all scenes names as a StringArray, with duplicate
        names numbered and empty names replaced by a generic name. All
        names are guaranteed to be unique, and their index in the array
        matches the glTF document's scene indices.
        """
    )

    def get_animation_duration(self, *args):
        """
        get_animation_duration(self, animationIndex:int) -> float
        C++: float get_animation_duration(IdType animationIndex)"""
        ret = self._wrap_call(self._vtk_obj.GetAnimationDuration, *args)
        return ret

    def get_animation_name(self, *args):
        """
        get_animation_name(self, animationIndex:int) -> str
        C++: std::string get_animation_name(IdType animationIndex)"""
        ret = self._wrap_call(self._vtk_obj.GetAnimationName, *args)
        return ret

    def _get_animation_selection(self):
        return wrap_vtk(self._vtk_obj.GetAnimationSelection())
    animation_selection = traits.Property(_get_animation_selection, desc=\
        """
        Get the DataArraySelection object to enable/disable
        animations.
        """
    )

    def _get_number_of_animations(self):
        return self._vtk_obj.GetNumberOfAnimations()
    number_of_animations = traits.Property(_get_number_of_animations, desc=\
        """
        glTF models can contain multiple animations, with various names
        and duration. glTF does not specify however any runtime behavior
        (order of playing, auto-start, loops, mapping of timelines, etc),
        which is why no animation is enabled by default. These accessors
        expose metadata information about a model's available animations.
        """
    )

    def _get_number_of_scenes(self):
        return self._vtk_obj.GetNumberOfScenes()
    number_of_scenes = traits.Property(_get_number_of_scenes, desc=\
        """
        
        """
    )

    def _get_number_of_textures(self):
        return self._vtk_obj.GetNumberOfTextures()
    number_of_textures = traits.Property(_get_number_of_textures, desc=\
        """
        
        """
    )

    def get_scene_name(self, *args):
        """
        get_scene_name(self, sceneIndex:int) -> str
        C++: std::string get_scene_name(IdType sceneIndex)
        glTF models can contain multiple scene descriptions. These
        accessors expose metadata information about a model's available
        scenes.
        """
        ret = self._wrap_call(self._vtk_obj.GetSceneName, *args)
        return ret

    def disable_animation(self, *args):
        """
        disable_animation(self, animationIndex:int) -> None
        C++: void disable_animation(IdType animationIndex)"""
        ret = self._wrap_call(self._vtk_obj.DisableAnimation, *args)
        return ret

    def enable_animation(self, *args):
        """
        enable_animation(self, animationIndex:int) -> None
        C++: void enable_animation(IdType animationIndex)
        Enable/Disable an animation. The reader will apply all enabled
        animations to the model's transformations, at the specified time
        step. Use UPDATE_TIME_STEP to select which frame should be
        applied.
        """
        ret = self._wrap_call(self._vtk_obj.EnableAnimation, *args)
        return ret

    def is_animation_enabled(self, *args):
        """
        is_animation_enabled(self, animationIndex:int) -> bool
        C++: bool is_animation_enabled(IdType animationIndex)"""
        ret = self._wrap_call(self._vtk_obj.IsAnimationEnabled, *args)
        return ret

    def set_scene(self, *args):
        """
        set_scene(self, scene:str) -> None
        C++: void set_scene(const std::string &scene)"""
        ret = self._wrap_call(self._vtk_obj.SetScene, *args)
        return ret

    _updateable_traits_ = \
    (('apply_deformations_to_geometry', 'GetApplyDeformationsToGeometry'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('current_scene', 'GetCurrentScene'), ('file_name', 'GetFileName'),
    ('frame_rate', 'GetFrameRate'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'apply_deformations_to_geometry', 'debug',
    'global_warning_display', 'release_data_flag', 'current_scene',
    'file_name', 'frame_rate', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GLTFReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GLTFReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['apply_deformations_to_geometry'], [], ['current_scene',
            'file_name', 'frame_rate']),
            title='Edit GLTFReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GLTFReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

