# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class GLTFDocumentLoader(Object):
    """
    GLTFDocumentLoader - Deserialize a GLTF model file.
    
    Superclass: Object
    
    GLTFDocument loader is an internal utility class which defines
    data structures and functions with the purpose of deserializing a
    glTF model from a glTF file, loading its data from binary buffers and
    creating vtk objects with the extracted geometry. It contains an
    internal Model structure into which all loading is performed.
    
    The GL Transmission Format (glTF) is an API-neutral runtime asset
    delivery format. A glTF asset is represented by:
    - A JSON-formatted file (.gltf) containing a full scene description:
      node hierarchy, materials, cameras, as well as descriptor
      information for meshes, animations, and other constructs
    - Binary files (.bin) containing geometry and animation data, and
      other buffer-based data
    - Image files (.jpg, .png) for textures
    
    For the full specification, see:
    https://github.com/khronos_group/glTF/tree/master/specification/2.0
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGLTFDocumentLoader, obj, update, **traits)
    
    def get_number_of_components_for_type(self, *args):
        """
        get_number_of_components_for_type(
            type:GLTFDocumentLoader.AccessorType) -> int
        C++: static unsigned int get_number_of_components_for_type(
            GLTFDocumentLoader::AccessorType type)
        Returns the number of components for a given accessor type.
        """
        ret = self._wrap_call(self._vtk_obj.GetNumberOfComponentsForType, *args)
        return ret

    def _get_supported_extensions(self):
        return self._vtk_obj.GetSupportedExtensions()
    supported_extensions = traits.Property(_get_supported_extensions, desc=\
        """
        Get the list of extensions that are supported by this loader
        """
    )

    def _get_used_extensions(self):
        return self._vtk_obj.GetUsedExtensions()
    used_extensions = traits.Property(_get_used_extensions, desc=\
        """
        Get the list of extensions that are used by the current model
        """
    )

    def apply_animation(self, *args):
        """
        apply_animation(self, t:float, animationId:int,
            forceStep:bool=False) -> bool
        C++: bool apply_animation(float t, int animationId,
            bool forceStep=false)
        Apply the specified animation, at the specified time, to the
        internal Model. Changes node transforms and morphing weights.
        """
        ret = self._wrap_call(self._vtk_obj.ApplyAnimation, *args)
        return ret

    def build_global_transforms(self, *args):
        """
        build_global_transforms(self, nodeIndex:int,
            parentTransform:SmartPointer_I12vtkMatrix4x4E) -> None
        C++: void build_global_transforms(unsigned int nodeIndex,
            SmartPointer<vtkMatrix4x4> parentTransform)
        build_global_transforms(self) -> None
        C++: void build_global_transforms()
        Concatenate the current node's local transform to its parent's
        global transform, storing the resulting transform in the node's
        globalTransform field. Then does the same for the current node's
        children. Recursive.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.BuildGlobalTransforms, *my_args)
        return ret

    def build_model_vtk_geometry(self):
        """
        build_model_vtk_geometry(self) -> bool
        C++: bool build_model_vtk_geometry()
        Converts the internal Model's loaded data into more convenient
        vtk objects.
        """
        ret = self._vtk_obj.BuildModelVTKGeometry()
        return ret
        

    def load_model_meta_data_from_file(self, *args):
        """
        load_model_meta_data_from_file(self, FileName:str) -> bool
        C++: bool load_model_meta_data_from_file(std::string FileName)
        Reset internal Model struct, and serialize glTF metadata (all
        json information) into it. To load buffers, use load_model_data
        """
        ret = self._wrap_call(self._vtk_obj.LoadModelMetaDataFromFile, *args)
        return ret

    def reset_animation(self, *args):
        """
        reset_animation(self, animationId:int) -> None
        C++: void reset_animation(int animationId)
        Restore the transforms that were modified by an animation to
        their initial state
        """
        ret = self._wrap_call(self._vtk_obj.ResetAnimation, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GLTFDocumentLoader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GLTFDocumentLoader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit GLTFDocumentLoader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GLTFDocumentLoader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

