# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class GeometryFilter(PolyDataAlgorithm):
    """
    GeometryFilter - extract boundary geometry from dataset (or
    convert data to polygonal type)
    
    Superclass: PolyDataAlgorithm
    
    GeometryFilter is a general-purpose filter to extract dataset
    boundary geometry, topology, and associated attribute data from any
    type of dataset. Geometry is obtained as follows: all 0D, 1D, and 2D
    cells are extracted. All 2D faces that are used by only one 3D cell
    (i.e., boundary faces) are extracted. It also is possible to specify
    conditions on point ids, cell ids, and on a bounding box (referred to
    as "Extent") to control the extraction process.  This point and cell
    id- and extent-based clipping is a powerful way to "see inside"
    datasets; however it may impact performance significantly.
    
    This filter may also be used to convert any type of data to polygonal
    type. This is particularly useful for surface rendering. The
    conversion process may be less than satisfactory for some 3D
    datasets. For example, this filter will extract the outer surface of
    a volume or structured grid dataset (if point, cell, and extent
    clipping is disabled). (For structured data you may want to use
    ImageDataGeometryFilter, StructuredGridGeometryFilter,
    ExtractUnstructuredGrid, RectilinearGridGeometryFilter, or
    ExtractVOI.)
    
    Another important feature of GeometryFilter is that it preserves
    topological connectivity. This enables filters that depend on correct
    connectivity (e.g., QuadricDecimation, FeatureEdges, etc.) to
    operate properly . It is possible to label the output polydata with
    an originating cell (pass_through_cell_ids) or point id
    (pass_through_point_ids). The output precision of created points (if
    they need to be created) can also be specified.
    
    In some cases (especially for large unstructured grids) the
    GeometryFilter can be slow. Consequently the filter has an
    optional "fast mode" that may execute significantly faster (>4-5x)
    than normal execution. The fast mode visits a subset of cells that
    may be on the boundary of the dataset (and skips interior cells which
    contribute nothing to the output). The set of subsetted cells is
    determined by inspecting the topological connectivity degree of each
    point (i.e., the number of unique cells using a particular point is
    that point's degree). With fast mode enabled, those cells connected
    to a point with degree <= Degree are visited. Note that this approach
    may miss some cells which contribute boundary faces--thus the output
    is an approximation to the normal execution of GeometryFilter.
    
    Finally, this filter takes an optional second, PolyData input.
    This input represents a list of faces that are to be excluded from
    the output of GeometryFilter.
    
    @warning
    While GeometryFilter and DataSetSurfaceFilter perform similar
    operations, there are important differences as follows:
    1. GeometryFilter preserves topological connectivity.
       DataSetSurfaceFilter produces output primitives which may be
       disconnected from one another.
    2. GeometryFilter can generate output based on cell ids, point
       ids, and/or extent (bounding box) clipping.
       DataSetSurfaceFilter strictly extracts the boundary surface of
       a dataset.
    3. GeometryFilter is much faster than DataSetSurfaceFilter,
       especially for UnstructuredGrids. As a result,
       DataSetSurfaceFilter will delegate the processing of linear
       unstructured grids to GeometryFilter.
    4. GeometryFilter can (currently) only handle linear cells. The
       filter will delegate to DataSetSurfaceFilter for higher-order
       cells. (This is a historical artifact and may be rectified in the
       future.)
    
    @warning
    If point merging (merging_off) is disabled, the filter will (if
    possible) use the input points and point attributes.  This can result
    in a lot of unused points in the output, at some gain in filter
    performance.  If enabled, point merging will generate only new points
    that are used by the output polydata cells.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    DataSetSurfaceFilter ImageDataGeometryFilter
    StructuredGridGeometryFilter ExtractGeometry ExtractVOI
    MarkBoundaryFilter RemovePolyData
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGeometryFilter, obj, update, **traits)
    
    cell_clipping = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off selection of geometry by cell id.
        """
    )

    def _cell_clipping_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCellClipping,
                        self.cell_clipping_)

    delegation = tvtk_base.true_bool_trait(desc=\
        """
        Disable delegation to an internal DataSetSurfaceFilter.
        """
    )

    def _delegation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDelegation,
                        self.delegation_)

    extent_clipping = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off selection of geometry via bounding box.
        """
    )

    def _extent_clipping_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExtentClipping,
                        self.extent_clipping_)

    fast_mode = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off fast mode execution. If enabled, fast mode typically
        runs much faster (2-3x) than the standard algorithm, however the
        output is an approximation to the correct result. Also, note that
        the fast_mode depends on the data member Degree for its execution.
        """
    )

    def _fast_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFastMode,
                        self.fast_mode_)

    merging = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off merging of points. This will reduce the number of
        output points, at some cost to performance. If Merging is off,
        then if possible (i.e., if the point representation is explicit),
        the filter will reuse the input points to create the output
        polydata. Certain input dataset types (with implicit point
        representations) will always create new points (effectively
        performing a merge operation).
        """
    )

    def _merging_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMerging,
                        self.merging_)

    pass_through_cell_ids = tvtk_base.false_bool_trait(desc=\
        """
        If on, the output polygonal dataset will have a celldata array
        that holds the cell index of the original 3D cell that produced
        each output cell. This is useful for cell picking. The default is
        off to conserve memory. Note that pass_through_cell_ids will be
        ignored if use_strips is on, since in that case each tringle strip
        can represent more than on of the input cells.
        """
    )

    def _pass_through_cell_ids_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassThroughCellIds,
                        self.pass_through_cell_ids_)

    pass_through_point_ids = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _pass_through_point_ids_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassThroughPointIds,
                        self.pass_through_point_ids_)

    point_clipping = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off selection of geometry by point id.
        """
    )

    def _point_clipping_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPointClipping,
                        self.point_clipping_)

    cell_maximum = traits.Trait(9223372036854775807, traits.Range(0, 9223372036854775807, enter_set=True, auto_set=False), desc=\
        """
        Specify the maximum cell id for point id selection.
        """
    )

    def _cell_maximum_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCellMaximum,
                        self.cell_maximum)

    cell_minimum = traits.Trait(0, traits.Range(0, 9223372036854775807, enter_set=True, auto_set=False), desc=\
        """
        Specify the minimum cell id for point id selection.
        """
    )

    def _cell_minimum_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCellMinimum,
                        self.cell_minimum)

    degree = traits.Trait(4, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        If fast mode is enabled, then Degree controls which cells are
        visited. Basically, any cell connected to a point with
        connectivity degree <= is visited and processed. Low degree
        points tend to be located on the boundary of datasets - thus
        attached cells frequently produce output boundary fragments.
        """
    )

    def _degree_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDegree,
                        self.degree)

    extent = traits.Array(enter_set=True, auto_set=False, shape=(6,), dtype="float", value=(-1e+299, 1e+299, -1e+299, 1e+299, -1e+299, 1e+299), cols=3, desc=\
        """
        Specify a (xmin,xmax, ymin,ymax, zmin,zmax) bounding box to clip
        data.
        """
    )

    def _extent_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExtent,
                        self.extent)

    def _get_locator(self):
        return wrap_vtk(self._vtk_obj.GetLocator())
    def _set_locator(self, arg):
        old_val = self._get_locator()
        self._wrap_call(self._vtk_obj.SetLocator,
                        deref_vtk(arg))
        self.trait_property_changed('locator', old_val, arg)
    locator = traits.Property(_get_locator, _set_locator, desc=\
        """
        
        """
    )

    nonlinear_subdivision_level = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        If the input is an unstructured grid with nonlinear faces, this
        parameter determines how many times the face is subdivided into
        linear faces.  If 0, the output is the equivalent of its linear
        counterpart (and the midpoints determining the nonlinear
        interpolation are discarded).  If 1 (the default), the nonlinear
        face is triangulated based on the midpoints.  If greater than 1,
        the triangulated pieces are recursively subdivided to reach the
        desired subdivision.  Setting the value to greater than 1 may
        cause some point data to not be passed even if no nonlinear faces
        exist.  This option has no effect if the input is not an
        unstructured grid.
        """
    )

    def _nonlinear_subdivision_level_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNonlinearSubdivisionLevel,
                        self.nonlinear_subdivision_level)

    original_cell_ids_name = traits.String('vtkOriginalCellIds', enter_set=True, auto_set=False, desc=\
        """
        If pass_through_cell_ids or pass_through_point_ids is on, then these
        ivars control the name given to the field in which the ids are
        written into.  If set to nullptr, then OriginalCellIds or
        OriginalPointIds (the default) is used, respectively.
        """
    )

    def _original_cell_ids_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOriginalCellIdsName,
                        self.original_cell_ids_name)

    original_point_ids_name = traits.String('vtkOriginalPointIds', enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _original_point_ids_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOriginalPointIdsName,
                        self.original_point_ids_name)

    output_points_precision = traits.Int(2, enter_set=True, auto_set=False, desc=\
        """
        Set/get the desired precision for the output types. See the
        documentation for the Algorithm::DesiredOutputPrecision enum
        for an explanation of the available precision settings. This only
        applies for data types where we create points (merging) as
        opposed to passing them from input to output, such as
        unstructured grids.
        """
    )

    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    piece_invariant = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        If piece_invariant is true, DataSetSurfaceFilter requests 1
        ghost level from input in order to remove internal surface that
        are between processes. False by default.
        """
    )

    def _piece_invariant_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPieceInvariant,
                        self.piece_invariant)

    point_maximum = traits.Trait(9223372036854775807, traits.Range(0, 9223372036854775807, enter_set=True, auto_set=False), desc=\
        """
        Specify the maximum point id for point id selection.
        """
    )

    def _point_maximum_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPointMaximum,
                        self.point_maximum)

    point_minimum = traits.Trait(0, traits.Range(0, 9223372036854775807, enter_set=True, auto_set=False), desc=\
        """
        Specify the minimum point id for point id selection.
        """
    )

    def _point_minimum_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPointMinimum,
                        self.point_minimum)

    def _get_excluded_faces(self):
        return wrap_vtk(self._vtk_obj.GetExcludedFaces())
    excluded_faces = traits.Property(_get_excluded_faces, desc=\
        """
        
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def create_default_locator(self):
        """
        create_default_locator(self) -> None
        C++: void create_default_locator()
        Create default locator. Used to create one when none is
        specified. This method is now deprecated.
        """
        ret = self._vtk_obj.CreateDefaultLocator()
        return ret
        

    def data_set_execute(self, *args):
        """
        data_set_execute(self, input:DataSet, output:PolyData,
            exc:ExcludedFaces) -> int
        C++: int data_set_execute(DataSet *input, PolyData *output,
            ExcludedFaces *exc)
        data_set_execute(self, input:DataSet, output:PolyData) -> int
        C++: virtual int data_set_execute(DataSet *input,
            PolyData *output)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DataSetExecute, *my_args)
        return ret

    def poly_data_execute(self, *args):
        """
        poly_data_execute(self, input:DataSet, output:PolyData,
            exc:ExcludedFaces) -> int
        C++: int poly_data_execute(DataSet *input, PolyData *output,
            ExcludedFaces *exc)
        poly_data_execute(self, __a:DataSet, __b:PolyData) -> int
        C++: virtual int poly_data_execute(DataSet *, PolyData *)
        Direct access methods so that this class can be used as an
        algorithm without using it as a filter (i.e., no pipeline
        updates). Also some internal methods with additional options.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PolyDataExecute, *my_args)
        return ret

    def set_excluded_faces_connection(self, *args):
        """
        set_excluded_faces_connection(self, algOutput:AlgorithmOutput)
            -> None
        C++: void set_excluded_faces_connection(
            AlgorithmOutput *algOutput)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetExcludedFacesConnection, *my_args)
        return ret

    def set_excluded_faces_data(self, *args):
        """
        set_excluded_faces_data(self, __a:PolyData) -> None
        C++: void set_excluded_faces_data(PolyData *)
        If a second, PolyData input is provided, this second input
        specifies a list of faces to be excluded from the output (in the
        PolyData::Polys attribute). This is useful to prevent the same
        face to be output multiple times in complex pipelines. (A
        candidate output boundary face is the same as a face in the
        excluded face list if it uses the same point ids as one of the
        polygons defined in the second input.) For example, a face may be
        extracted separately via a threshold filter; thus this face
        should not be also extracted via the GeometryFilter. (This
        functionality is related to RemovePolyData.)
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetExcludedFacesData, *my_args)
        return ret

    def structured_execute(self, *args):
        """
        structured_execute(self, input:DataSet, output:PolyData,
            inInfo:Information, exc:ExcludedFaces) -> int
        C++: int structured_execute(DataSet *input, PolyData *output,
             Information *inInfo, ExcludedFaces *exc)
        structured_execute(self, input:DataSet, output:PolyData,
            inInfo:Information) -> int
        C++: virtual int structured_execute(DataSet *input,
            PolyData *output, Information *inInfo)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.StructuredExecute, *my_args)
        return ret

    def unstructured_grid_execute(self, *args):
        """
        unstructured_grid_execute(self, input:DataSet,
            output:PolyData) -> int
        C++: virtual int unstructured_grid_execute(DataSet *input,
            PolyData *output)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.UnstructuredGridExecute, *my_args)
        return ret

    _updateable_traits_ = \
    (('cell_clipping', 'GetCellClipping'), ('delegation',
    'GetDelegation'), ('extent_clipping', 'GetExtentClipping'),
    ('fast_mode', 'GetFastMode'), ('merging', 'GetMerging'),
    ('pass_through_cell_ids', 'GetPassThroughCellIds'),
    ('pass_through_point_ids', 'GetPassThroughPointIds'),
    ('point_clipping', 'GetPointClipping'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('cell_maximum', 'GetCellMaximum'),
    ('cell_minimum', 'GetCellMinimum'), ('degree', 'GetDegree'),
    ('extent', 'GetExtent'), ('nonlinear_subdivision_level',
    'GetNonlinearSubdivisionLevel'), ('original_cell_ids_name',
    'GetOriginalCellIdsName'), ('original_point_ids_name',
    'GetOriginalPointIdsName'), ('output_points_precision',
    'GetOutputPointsPrecision'), ('piece_invariant', 'GetPieceInvariant'),
    ('point_maximum', 'GetPointMaximum'), ('point_minimum',
    'GetPointMinimum'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'cell_clipping', 'debug', 'delegation',
    'extent_clipping', 'fast_mode', 'global_warning_display', 'merging',
    'pass_through_cell_ids', 'pass_through_point_ids', 'point_clipping',
    'release_data_flag', 'cell_maximum', 'cell_minimum', 'degree',
    'extent', 'nonlinear_subdivision_level', 'original_cell_ids_name',
    'original_point_ids_name', 'output_points_precision',
    'piece_invariant', 'point_maximum', 'point_minimum', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GeometryFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GeometryFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['cell_clipping', 'delegation', 'extent_clipping', 'fast_mode',
            'merging', 'pass_through_cell_ids', 'pass_through_point_ids',
            'point_clipping'], [], ['cell_maximum', 'cell_minimum', 'degree',
            'extent', 'nonlinear_subdivision_level', 'original_cell_ids_name',
            'original_point_ids_name', 'output_points_precision',
            'piece_invariant', 'point_maximum', 'point_minimum']),
            title='Edit GeometryFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GeometryFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

