# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class GenericEdgeTable(Object):
    """
    GenericEdgeTable - keep track of edges (defined by pair of integer
    id's)
    
    Superclass: Object
    
    GenericEdgeTable is used to indicate the existence of and hold
    information about edges. Similar to EdgeTable, this class is more
    sophisticated in that it uses reference counting to keep track of
    when information about an edge should be deleted.
    
    GenericEdgeTable is a helper class used in the adaptor framework. 
    It is used during the tessellation process to hold information about
    the error metric on each edge. This avoids recomputing the error
    metric each time the same edge is visited.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGenericEdgeTable, obj, update, **traits)
    
    number_of_components = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        Set the total number of components for the point-centered
        attributes.
        \pre positive_count: count>0
        """
    )

    def _number_of_components_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfComponents,
                        self.number_of_components)

    def check_edge(self, *args):
        """
        check_edge(self, e1:int, e2:int, ptId:int) -> int
        C++: int check_edge(IdType e1, IdType e2, IdType &ptId)
        Method to determine whether an edge is in the table (0 or 1), or
        not (-1). It returns whether the edge was split (1) or not (0),
        and the point id exists.
        """
        ret = self._wrap_call(self._vtk_obj.CheckEdge, *args)
        return ret

    def check_edge_reference_count(self, *args):
        """
        check_edge_reference_count(self, e1:int, e2:int) -> int
        C++: int check_edge_reference_count(IdType e1, IdType e2)
        Return the edge reference count.
        """
        ret = self._wrap_call(self._vtk_obj.CheckEdgeReferenceCount, *args)
        return ret

    def check_point(self, *args):
        """
        check_point(self, ptId:int) -> int
        C++: int check_point(IdType ptId)
        check_point(self, ptId:int, point:[float, float, float],
            scalar:[float, ...]) -> int
        C++: int check_point(IdType ptId, double point[3],
            double *scalar)
        Check if a point is already in the point table.
        """
        ret = self._wrap_call(self._vtk_obj.CheckPoint, *args)
        return ret

    def dump_table(self):
        """
        dump_table(self) -> None
        C++: void dump_table()
        For debugging purposes. It is particularly useful to dump the
        table and check that nothing is left after a complete iteration.
        load_factor should ideally be very low to be able to have a
        constant time access
        """
        ret = self._vtk_obj.DumpTable()
        return ret
        

    def increment_edge_reference_count(self, *args):
        """
        increment_edge_reference_count(self, e1:int, e2:int, cellId:int)
            -> int
        C++: int increment_edge_reference_count(IdType e1, IdType e2,
            IdType cellId)
        Method that increments the referencecount and returns it.
        """
        ret = self._wrap_call(self._vtk_obj.IncrementEdgeReferenceCount, *args)
        return ret

    def increment_point_reference_count(self, *args):
        """
        increment_point_reference_count(self, ptId:int) -> None
        C++: void increment_point_reference_count(IdType ptId)
        Increment the reference count for the indicated point.
        """
        ret = self._wrap_call(self._vtk_obj.IncrementPointReferenceCount, *args)
        return ret

    def initialize(self, *args):
        """
        initialize(self, start:int) -> None
        C++: void initialize(IdType start)
        To specify the starting point id. It will initialize last_point_id
        This is very sensitive the start point should be cautiously
        chosen
        """
        ret = self._wrap_call(self._vtk_obj.Initialize, *args)
        return ret

    def insert_edge(self, *args):
        """
        insert_edge(self, e1:int, e2:int, cellId:int, ref:int, ptId:int)
            -> None
        C++: void insert_edge(IdType e1, IdType e2, IdType cellId,
             int ref, IdType &ptId)
        insert_edge(self, e1:int, e2:int, cellId:int, ref:int=1) -> None
        C++: void insert_edge(IdType e1, IdType e2, IdType cellId,
             int ref=1)
        Split the edge with the indicated point id.
        """
        ret = self._wrap_call(self._vtk_obj.InsertEdge, *args)
        return ret

    def insert_point(self, *args):
        """
        insert_point(self, ptId:int, point:[float, float, float]) -> None
        C++: void insert_point(IdType ptId, double point[3])
        Insert point associated with an edge.
        """
        ret = self._wrap_call(self._vtk_obj.InsertPoint, *args)
        return ret

    def insert_point_and_scalar(self, *args):
        """
        insert_point_and_scalar(self, ptId:int, pt:[float, float, float],
            s:[float, ...]) -> None
        C++: void insert_point_and_scalar(IdType ptId, double pt[3],
            double *s)"""
        ret = self._wrap_call(self._vtk_obj.InsertPointAndScalar, *args)
        return ret

    def load_factor(self):
        """
        load_factor(self) -> None
        C++: void load_factor()"""
        ret = self._vtk_obj.LoadFactor()
        return ret
        

    def remove_edge(self, *args):
        """
        remove_edge(self, e1:int, e2:int) -> int
        C++: int remove_edge(IdType e1, IdType e2)
        Method to remove an edge from the table. The method returns the
        current reference count.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveEdge, *args)
        return ret

    def remove_point(self, *args):
        """
        remove_point(self, ptId:int) -> None
        C++: void remove_point(IdType ptId)
        Remove a point from the point table.
        """
        ret = self._wrap_call(self._vtk_obj.RemovePoint, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('number_of_components',
    'GetNumberOfComponents'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'number_of_components'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GenericEdgeTable, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GenericEdgeTable properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['number_of_components']),
            title='Edit GenericEdgeTable properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GenericEdgeTable properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

