# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_array import DataArray


class GenericDataArray_I23vtkSOADataArrayTemplateImEmE(DataArray):
    """
    GenericDataArray<vtkSOADataArrayTemplate<unsigned long>, unsigned
    long> - Base interface for all typed DataArray subclasses.
    
    Superclass: DataArray
    
    A more detailed description of this class and related tools can be
    found\ref VTK-7-1-array_dispatch "here".
    
    The GenericDataArray class provides a generic implementation of
    the DataArray API. It relies on subclasses providing access to
    data via 8 "concept methods", which should be implemented as
    non-virtual methods of the subclass. These methods are:
    
    - value_type get_value(vtkid_type valueIdx) const
    - [public] void set_value(vtkid_type valueIdx, value_type value)
    - [public] void get_typed_tuple(vtkid_type tupleIdx, value_type* tuple)
      const
    - [public] void set_typed_tuple(vtkid_type tupleIdx, const value_type*
      tuple)
    - [public] value_type get_typed_component(vtkid_type tupleIdx, int
      compIdx) const
    - [public] void set_typed_component(vtkid_type tupleIdx, int compIdx,
      value_type value)
    - [protected] bool allocate_tuples(vtkid_type numTuples)
    - [protected] bool reallocate_tuples(vtkid_type numTuples)
    
    Note that these methods use the CRTP idiom, which provides static
    binding to avoid virtual calls. This allows the compiler to optimize
    away layers of indirection when these methods are used. Well-designed
    implementations of these methods will reduce to raw memory accesses,
    providing efficient performance comparable to working with the
    pointer data.
    
    See AOSDataArrayTemplate and SOADataArrayTemplate for example
    implementations.
    
    In practice, code should not be written to use GenericDataArray
    objects. Doing so is rather unweildy due to the CRTP pattern
    requiring the derived class be provided as a template argument.
    Instead, the ArrayDispatch framework can be used to detect a
    DataArray's implementation type and instantiate appropriate
    templated worker code.
    
    ArrayDispatch is also intended to replace code that currently
    relies on the encapsulation-breaking get_void_pointer method. Not all
    subclasses of DataArray use the memory layout assumed by
    get_void_pointer; calling this method on, e.g. a
    SOADataArrayTemplate will trigger a deep copy of the array data
    into an AOS buffer. This is very inefficient and should be avoided.
    
    @sa
    ArrayDispatcher DataArrayRange
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGenericDataArray_I23vtkSOADataArrayTemplateImEmE, obj, update, **traits)
    
    def get_component(self, *args):
        """
        get_component(self, tupleIdx:int, compIdx:int) -> float
        C++: double get_component(IdType tupleIdx, int compIdx)
            override;
        Return the data component at the location specified by tupleIdx
        and compIdx.
        """
        ret = self._wrap_call(self._vtk_obj.GetComponent, *args)
        return ret

    def set_component(self, *args):
        """
        set_component(self, tupleIdx:int, compIdx:int, value:float) -> None
        C++: void set_component(IdType tupleIdx, int compIdx,
            double value) override;
        Set the data component at the location specified by tupleIdx and
        compIdx to value. Note that i is less than number_of_tuples and j
        is less than number_of_components. Make sure enough memory has been
        allocated (use set_number_of_tuples() and set_number_of_components()).
        """
        ret = self._wrap_call(self._vtk_obj.SetComponent, *args)
        return ret

    number_of_components = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the dimension (n) of the components. Must be >= 1. Make
        sure that this is set before allocation.
        """
    )

    def _number_of_components_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfComponents,
                        self.number_of_components)

    number_of_tuples = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Set the number of tuples (a component group) in the array. Note
        that this may allocate space depending on the number of
        components. Also note that if allocation is performed no copy is
        performed so existing data will be lost (if data conservation is
        sought, one may use the Resize method instead).
        """
    )

    def _number_of_tuples_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfTuples,
                        self.number_of_tuples)

    def get_tuple(self, *args):
        """
        get_tuple(self, tupleIdx:int) -> (float, ...)
        get_tuple(self, tupleIdx:int, tuple:[float, ...]) -> None
        
        Get the data tuple at tupleIdx. Return it as a pointer to an
        array. Note: this method is not thread-safe, and the pointer is
        only valid as long as another method invocation to a vtk object
        is not performed.
        """
        ret = self._wrap_call(self._vtk_obj.GetTuple, *args)
        return ret

    def set_tuple(self, *args):
        """
        set_tuple(self, dstTupleIdx:int, srcTupleIdx:int,
            source:AbstractArray) -> None
        C++: void set_tuple(IdType dstTupleIdx, IdType srcTupleIdx,
            AbstractArray *source) override;
        set_tuple(self, tupleIdx:int, tuple:(float, ...)) -> None
        C++: void set_tuple(IdType tupleIdx, const double *tuple)
            override;
        Set the tuple at dsttuple_idx in this array to the tuple at
        srctuple_idx in the source array. This method assumes that the two
        arrays have the same type and structure. Note that range checking
        and memory allocation is not performed; use in conjunction with
        set_number_of_tuples() to allocate space.
        """
        my_args = deref_array(args, [('int', 'int', 'vtkAbstractArray'), ('int', 'tuple')])
        ret = self._wrap_call(self._vtk_obj.SetTuple, *my_args)
        return ret

    def get_typed_component(self, *args):
        """
        get_typed_component(self, tupleIdx:int, compIdx:int) -> int
        C++: ValueType get_typed_component(IdType tupleIdx, int compIdx)
        Get component compIdx of the tuple at tupleIdx. This is typically
        the fastest way to access array data.@ingroup
        GDAConceptMethods
        """
        ret = self._wrap_call(self._vtk_obj.GetTypedComponent, *args)
        return ret

    def set_typed_component(self, *args):
        """
        set_typed_component(self, tupleIdx:int, compIdx:int, value:int)
            -> None
        C++: void set_typed_component(IdType tupleIdx, int compIdx,
            ValueType value)
        Set component compIdx of the tuple at tupleIdx to value. This is
        typically the fastest way to set array data.@ingroup
        GDAConceptMethods
        """
        ret = self._wrap_call(self._vtk_obj.SetTypedComponent, *args)
        return ret

    def get_typed_tuple(self, *args):
        """
        get_typed_tuple(self, tupleIdx:int, tuple:[int, ...]) -> None
        C++: void get_typed_tuple(IdType tupleIdx, ValueType *tuple)
        Copy the tuple at tupleIdx into tuple.
        
        ote get_typed_component is preferred over this method. The overhead
        of copying the tuple is significant compared to the more
        performant component-wise access methods, which typically
        optimize to raw memory access.@ingroup GDAConceptMethods
        """
        ret = self._wrap_call(self._vtk_obj.GetTypedTuple, *args)
        return ret

    def set_typed_tuple(self, *args):
        """
        set_typed_tuple(self, tupleIdx:int, tuple:(int, ...)) -> None
        C++: void set_typed_tuple(IdType tupleIdx,
            const ValueType *tuple)
        Set this array's tuple at tupleIdx to the values in tuple.
        
        ote set_typed_component is preferred over this method. The overhead
        of copying the tuple is significant compared to the more
        performant component-wise access methods, which typically
        optimize to raw memory access.@ingroup GDAConceptMethods
        """
        ret = self._wrap_call(self._vtk_obj.SetTypedTuple, *args)
        return ret

    def get_value(self, *args):
        """
        get_value(self, valueIdx:int) -> int
        C++: ValueType get_value(IdType valueIdx)
        Get the value at valueIdx. valueIdx assumes AOS ordering.
        
        ote get_typed_component is preferred over this method. It is faster
        for SOA arrays, and shows equivalent performance for AOS arrays
        when number_of_components is known to the compiler (See
        Assume.h).@ingroup GDAConceptMethods
        """
        ret = self._wrap_call(self._vtk_obj.GetValue, *args)
        return ret

    def set_value(self, *args):
        """
        set_value(self, valueIdx:int, value:int) -> None
        C++: void set_value(IdType valueIdx, ValueType value)
        Set the value at valueIdx to value. valueIdx assumes AOS
        ordering.
        
        ote set_typed_component is preferred over this method. It is faster
        for SOA arrays, and shows equivalent performance for AOS arrays
        when number_of_components is known to the compiler (See
        Assume.h).@ingroup GDAConceptMethods
        """
        ret = self._wrap_call(self._vtk_obj.SetValue, *args)
        return ret

    def get_variant_value(self, *args):
        """
        get_variant_value(self, valueIdx:int) -> Variant
        
        Retrieve value from the array as a variant.
        """
        ret = self._wrap_call(self._vtk_obj.GetVariantValue, *args)
        return wrap_vtk(ret)

    def set_variant_value(self, *args):
        """
        set_variant_value(self, valueIdx:int, value:Variant) -> None
        C++: void set_variant_value(IdType valueIdx, Variant value)
            override;
        Set a value in the array from a variant.  This method does NOT do
        bounds checking.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetVariantValue, *my_args)
        return ret

    def _get_finite_value_range(self):
        return self._vtk_obj.GetFiniteValueRange()
    finite_value_range = traits.Property(_get_finite_value_range, desc=\
        """
        
        """
    )

    def get_finite_value_range(self, *args):
        """
        get_finite_value_range(self, range:[int, int], comp:int) -> None
        C++: void get_finite_value_range(ValueType range[2], int comp)
        get_finite_value_range(self, comp:int) -> (int, int)
        C++: ValueType *get_finite_value_range(int comp)
        get_finite_value_range(self) -> (int, int)
        C++: ValueType *get_finite_value_range()
        get_finite_value_range(self, range:[int, int]) -> None
        C++: void get_finite_value_range(ValueType range[2])"""
        ret = self._wrap_call(self._vtk_obj.GetFiniteValueRange, *args)
        return ret

    def get_pointer(self, *args):
        """
        get_pointer(self, valueIdx:int) -> Pointer
        C++: ValueType *get_pointer(IdType valueIdx)"""
        ret = self._wrap_call(self._vtk_obj.GetPointer, *args)
        return ret

    def _get_value_range(self):
        return self._vtk_obj.GetValueRange()
    value_range = traits.Property(_get_value_range, desc=\
        """
        Get the range of array values for the given component in the
        native data type.
        """
    )

    def get_value_range(self, *args):
        """
        get_value_range(self, range:[int, int], comp:int) -> None
        C++: void get_value_range(ValueType range[2], int comp)
        get_value_range(self, comp:int) -> (int, int)
        C++: ValueType *get_value_range(int comp)
        get_value_range(self) -> (int, int)
        C++: ValueType *get_value_range()
        get_value_range(self, range:[int, int]) -> None
        C++: void get_value_range(ValueType range[2])
        Get the range of array values for the given component in the
        native data type.
        """
        ret = self._wrap_call(self._vtk_obj.GetValueRange, *args)
        return ret

    def capacity(self):
        """
        capacity(self) -> int
        C++: IdType capacity()
        Return the capacity in typeof T units of the current array. TODO
        Leftover from DataArrayTemplate, redundant with get_size.
        Deprecate?
        """
        ret = self._vtk_obj.Capacity()
        return ret
        

    def fill_typed_component(self, *args):
        """
        fill_typed_component(self, compIdx:int, value:int) -> None
        C++: virtual void fill_typed_component(int compIdx, ValueType value)
        Set component comp of all tuples to value.
        """
        ret = self._wrap_call(self._vtk_obj.FillTypedComponent, *args)
        return ret

    def fill_value(self, *args):
        """
        fill_value(self, value:int) -> None
        C++: virtual void fill_value(ValueType value)
        Set all the values in array to value.
        """
        ret = self._wrap_call(self._vtk_obj.FillValue, *args)
        return ret

    def insert_next_typed_tuple(self, *args):
        """
        insert_next_typed_tuple(self, t:(int, ...)) -> int
        C++: IdType insert_next_typed_tuple(const ValueType *t)
        Insert (memory allocation performed) the tuple onto the end of
        the array.
        """
        ret = self._wrap_call(self._vtk_obj.InsertNextTypedTuple, *args)
        return ret

    def insert_next_value(self, *args):
        """
        insert_next_value(self, value:int) -> int
        C++: IdType insert_next_value(ValueType value)
        Insert data at the end of the array. Return its location in the
        array.
        """
        ret = self._wrap_call(self._vtk_obj.InsertNextValue, *args)
        return ret

    def insert_typed_component(self, *args):
        """
        insert_typed_component(self, tupleIdx:int, compIdx:int, val:int)
            -> None
        C++: void insert_typed_component(IdType tupleIdx, int compIdx,
            ValueType val)
        Insert (memory allocation performed) the value at the specified
        tuple and component location.
        """
        ret = self._wrap_call(self._vtk_obj.InsertTypedComponent, *args)
        return ret

    def insert_typed_tuple(self, *args):
        """
        insert_typed_tuple(self, tupleIdx:int, t:(int, ...)) -> None
        C++: void insert_typed_tuple(IdType tupleIdx, const ValueType *t)
        Insert (memory allocation performed) the tuple t at tupleIdx.
        """
        ret = self._wrap_call(self._vtk_obj.InsertTypedTuple, *args)
        return ret

    def insert_value(self, *args):
        """
        insert_value(self, valueIdx:int, value:int) -> None
        C++: void insert_value(IdType valueIdx, ValueType value)
        Insert data at a specified position in the array.
        """
        ret = self._wrap_call(self._vtk_obj.InsertValue, *args)
        return ret

    def lookup_typed_value(self, *args):
        """
        lookup_typed_value(self, value:int) -> int
        C++: virtual IdType lookup_typed_value(ValueType value)
        lookup_typed_value(self, value:int, valueIds:IdList) -> None
        C++: virtual void lookup_typed_value(ValueType value,
            IdList *valueIds)"""
        my_args = deref_array(args, [['int'], ('int', 'vtkIdList')])
        ret = self._wrap_call(self._vtk_obj.LookupTypedValue, *my_args)
        return ret

    def write_pointer(self, *args):
        """
        write_pointer(self, valueIdx:int, numValues:int) -> Pointer
        C++: ValueType *write_pointer(IdType valueIdx,
            IdType numValues)"""
        ret = self._wrap_call(self._vtk_obj.WritePointer, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('number_of_components',
    'GetNumberOfComponents'), ('number_of_tuples', 'GetNumberOfTuples'),
    ('max_discrete_values', 'GetMaxDiscreteValues'), ('name', 'GetName'),
    ('number_of_values', 'GetNumberOfValues'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'max_discrete_values', 'name',
    'number_of_components', 'number_of_tuples', 'number_of_values'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GenericDataArray_I23vtkSOADataArrayTemplateImEmE, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GenericDataArray_I23vtkSOADataArrayTemplateImEmE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['max_discrete_values', 'name', 'number_of_components',
            'number_of_tuples', 'number_of_values']),
            title='Edit GenericDataArray_I23vtkSOADataArrayTemplateImEmE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GenericDataArray_I23vtkSOADataArrayTemplateImEmE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

