# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.cell import Cell


class GenericCell(Cell):
    """
    GenericCell - provides thread-safe access to cells
    
    Superclass: Cell
    
    GenericCell is a class that provides access to concrete types of
    cells. It's main purpose is to allow thread-safe access to cells,
    supporting the DataSet::GetCell(vtkGenericCell *) method.
    GenericCell acts like any type of cell, it just dereferences an
    internal representation. The set_cell_type() methods use #define
    constants; these are defined in the file CellType.h.
    
    @sa
    Cell DataSet
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGenericCell, obj, update, **traits)
    
    def _get_faces(self):
        return self._vtk_obj.GetFaces()
    def _set_faces(self, arg):
        old_val = self._get_faces()
        self._wrap_call(self._vtk_obj.SetFaces,
                        arg)
        self.trait_property_changed('faces', old_val, arg)
    faces = traits.Property(_get_faces, _set_faces, desc=\
        """
        
        """
    )

    def _get_point_ids(self):
        return wrap_vtk(self._vtk_obj.GetPointIds())
    def _set_point_ids(self, arg):
        old_val = self._get_point_ids()
        my_arg = deref_array([arg], [['vtkIdList']])
        self._wrap_call(self._vtk_obj.SetPointIds,
                        my_arg[0])
        self.trait_property_changed('point_ids', old_val, arg)
    point_ids = traits.Property(_get_point_ids, _set_point_ids, desc=\
        """
        Return the list of point ids defining the cell.
        """
    )

    def _get_points(self):
        return wrap_vtk(self._vtk_obj.GetPoints())
    def _set_points(self, arg):
        old_val = self._get_points()
        my_arg = deref_array([arg], [['vtkPoints']])
        self._wrap_call(self._vtk_obj.SetPoints,
                        my_arg[0])
        self.trait_property_changed('points', old_val, arg)
    points = traits.Property(_get_points, _set_points, desc=\
        """
        Get the point coordinates for the cell.
        """
    )

    def _get_representative_cell(self):
        return wrap_vtk(self._vtk_obj.GetRepresentativeCell())
    representative_cell = traits.Property(_get_representative_cell, desc=\
        """
        
        """
    )

    def instantiate_cell(self, *args):
        """
        instantiate_cell(cellType:int) -> Cell
        C++: static Cell *instantiate_cell(int cellType)
        Instantiate a new Cell based on it's cell type value
        """
        ret = self._wrap_call(self._vtk_obj.InstantiateCell, *args)
        return wrap_vtk(ret)

    def set_cell_type(self, *args):
        """
        set_cell_type(self, cellType:int) -> None
        C++: void set_cell_type(int cellType)
        This method is used to support the
        DataSet::GetCell(vtkGenericCell *) method. It allows
        GenericCell to act like any cell type by dereferencing an
        internal instance of a concrete cell type. When you set the cell
        type, you are resetting a pointer to an internal cell which is
        then used for computation.
        """
        ret = self._wrap_call(self._vtk_obj.SetCellType, *args)
        return ret

    def set_cell_type_to_bezier_curve(self):
        """
        set_cell_type_to_bezier_curve(self) -> None
        C++: void set_cell_type_to_bezier_curve()"""
        ret = self._vtk_obj.SetCellTypeToBezierCurve()
        return ret
        

    def set_cell_type_to_bezier_hexahedron(self):
        """
        set_cell_type_to_bezier_hexahedron(self) -> None
        C++: void set_cell_type_to_bezier_hexahedron()"""
        ret = self._vtk_obj.SetCellTypeToBezierHexahedron()
        return ret
        

    def set_cell_type_to_bezier_quadrilateral(self):
        """
        set_cell_type_to_bezier_quadrilateral(self) -> None
        C++: void set_cell_type_to_bezier_quadrilateral()"""
        ret = self._vtk_obj.SetCellTypeToBezierQuadrilateral()
        return ret
        

    def set_cell_type_to_bezier_tetra(self):
        """
        set_cell_type_to_bezier_tetra(self) -> None
        C++: void set_cell_type_to_bezier_tetra()"""
        ret = self._vtk_obj.SetCellTypeToBezierTetra()
        return ret
        

    def set_cell_type_to_bezier_triangle(self):
        """
        set_cell_type_to_bezier_triangle(self) -> None
        C++: void set_cell_type_to_bezier_triangle()"""
        ret = self._vtk_obj.SetCellTypeToBezierTriangle()
        return ret
        

    def set_cell_type_to_bezier_wedge(self):
        """
        set_cell_type_to_bezier_wedge(self) -> None
        C++: void set_cell_type_to_bezier_wedge()"""
        ret = self._vtk_obj.SetCellTypeToBezierWedge()
        return ret
        

    def set_cell_type_to_bi_quadratic_quad(self):
        """
        set_cell_type_to_bi_quadratic_quad(self) -> None
        C++: void set_cell_type_to_bi_quadratic_quad()"""
        ret = self._vtk_obj.SetCellTypeToBiQuadraticQuad()
        return ret
        

    def set_cell_type_to_bi_quadratic_quadratic_hexahedron(self):
        """
        set_cell_type_to_bi_quadratic_quadratic_hexahedron(self) -> None
        C++: void set_cell_type_to_bi_quadratic_quadratic_hexahedron()"""
        ret = self._vtk_obj.SetCellTypeToBiQuadraticQuadraticHexahedron()
        return ret
        

    def set_cell_type_to_bi_quadratic_quadratic_wedge(self):
        """
        set_cell_type_to_bi_quadratic_quadratic_wedge(self) -> None
        C++: void set_cell_type_to_bi_quadratic_quadratic_wedge()"""
        ret = self._vtk_obj.SetCellTypeToBiQuadraticQuadraticWedge()
        return ret
        

    def set_cell_type_to_bi_quadratic_triangle(self):
        """
        set_cell_type_to_bi_quadratic_triangle(self) -> None
        C++: void set_cell_type_to_bi_quadratic_triangle()"""
        ret = self._vtk_obj.SetCellTypeToBiQuadraticTriangle()
        return ret
        

    def set_cell_type_to_convex_point_set(self):
        """
        set_cell_type_to_convex_point_set(self) -> None
        C++: void set_cell_type_to_convex_point_set()"""
        ret = self._vtk_obj.SetCellTypeToConvexPointSet()
        return ret
        

    def set_cell_type_to_cubic_line(self):
        """
        set_cell_type_to_cubic_line(self) -> None
        C++: void set_cell_type_to_cubic_line()"""
        ret = self._vtk_obj.SetCellTypeToCubicLine()
        return ret
        

    def set_cell_type_to_empty_cell(self):
        """
        set_cell_type_to_empty_cell(self) -> None
        C++: void set_cell_type_to_empty_cell()"""
        ret = self._vtk_obj.SetCellTypeToEmptyCell()
        return ret
        

    def set_cell_type_to_hexagonal_prism(self):
        """
        set_cell_type_to_hexagonal_prism(self) -> None
        C++: void set_cell_type_to_hexagonal_prism()"""
        ret = self._vtk_obj.SetCellTypeToHexagonalPrism()
        return ret
        

    def set_cell_type_to_hexahedron(self):
        """
        set_cell_type_to_hexahedron(self) -> None
        C++: void set_cell_type_to_hexahedron()"""
        ret = self._vtk_obj.SetCellTypeToHexahedron()
        return ret
        

    def set_cell_type_to_lagrange_curve(self):
        """
        set_cell_type_to_lagrange_curve(self) -> None
        C++: void set_cell_type_to_lagrange_curve()"""
        ret = self._vtk_obj.SetCellTypeToLagrangeCurve()
        return ret
        

    def set_cell_type_to_lagrange_hexahedron(self):
        """
        set_cell_type_to_lagrange_hexahedron(self) -> None
        C++: void set_cell_type_to_lagrange_hexahedron()"""
        ret = self._vtk_obj.SetCellTypeToLagrangeHexahedron()
        return ret
        

    def set_cell_type_to_lagrange_quadrilateral(self):
        """
        set_cell_type_to_lagrange_quadrilateral(self) -> None
        C++: void set_cell_type_to_lagrange_quadrilateral()"""
        ret = self._vtk_obj.SetCellTypeToLagrangeQuadrilateral()
        return ret
        

    def set_cell_type_to_lagrange_tetra(self):
        """
        set_cell_type_to_lagrange_tetra(self) -> None
        C++: void set_cell_type_to_lagrange_tetra()"""
        ret = self._vtk_obj.SetCellTypeToLagrangeTetra()
        return ret
        

    def set_cell_type_to_lagrange_triangle(self):
        """
        set_cell_type_to_lagrange_triangle(self) -> None
        C++: void set_cell_type_to_lagrange_triangle()"""
        ret = self._vtk_obj.SetCellTypeToLagrangeTriangle()
        return ret
        

    def set_cell_type_to_lagrange_wedge(self):
        """
        set_cell_type_to_lagrange_wedge(self) -> None
        C++: void set_cell_type_to_lagrange_wedge()"""
        ret = self._vtk_obj.SetCellTypeToLagrangeWedge()
        return ret
        

    def set_cell_type_to_line(self):
        """
        set_cell_type_to_line(self) -> None
        C++: void set_cell_type_to_line()"""
        ret = self._vtk_obj.SetCellTypeToLine()
        return ret
        

    def set_cell_type_to_pentagonal_prism(self):
        """
        set_cell_type_to_pentagonal_prism(self) -> None
        C++: void set_cell_type_to_pentagonal_prism()"""
        ret = self._vtk_obj.SetCellTypeToPentagonalPrism()
        return ret
        

    def set_cell_type_to_pixel(self):
        """
        set_cell_type_to_pixel(self) -> None
        C++: void set_cell_type_to_pixel()"""
        ret = self._vtk_obj.SetCellTypeToPixel()
        return ret
        

    def set_cell_type_to_poly_line(self):
        """
        set_cell_type_to_poly_line(self) -> None
        C++: void set_cell_type_to_poly_line()"""
        ret = self._vtk_obj.SetCellTypeToPolyLine()
        return ret
        

    def set_cell_type_to_poly_vertex(self):
        """
        set_cell_type_to_poly_vertex(self) -> None
        C++: void set_cell_type_to_poly_vertex()"""
        ret = self._vtk_obj.SetCellTypeToPolyVertex()
        return ret
        

    def set_cell_type_to_polygon(self):
        """
        set_cell_type_to_polygon(self) -> None
        C++: void set_cell_type_to_polygon()"""
        ret = self._vtk_obj.SetCellTypeToPolygon()
        return ret
        

    def set_cell_type_to_polyhedron(self):
        """
        set_cell_type_to_polyhedron(self) -> None
        C++: void set_cell_type_to_polyhedron()"""
        ret = self._vtk_obj.SetCellTypeToPolyhedron()
        return ret
        

    def set_cell_type_to_pyramid(self):
        """
        set_cell_type_to_pyramid(self) -> None
        C++: void set_cell_type_to_pyramid()"""
        ret = self._vtk_obj.SetCellTypeToPyramid()
        return ret
        

    def set_cell_type_to_quad(self):
        """
        set_cell_type_to_quad(self) -> None
        C++: void set_cell_type_to_quad()"""
        ret = self._vtk_obj.SetCellTypeToQuad()
        return ret
        

    def set_cell_type_to_quadratic_edge(self):
        """
        set_cell_type_to_quadratic_edge(self) -> None
        C++: void set_cell_type_to_quadratic_edge()"""
        ret = self._vtk_obj.SetCellTypeToQuadraticEdge()
        return ret
        

    def set_cell_type_to_quadratic_hexahedron(self):
        """
        set_cell_type_to_quadratic_hexahedron(self) -> None
        C++: void set_cell_type_to_quadratic_hexahedron()"""
        ret = self._vtk_obj.SetCellTypeToQuadraticHexahedron()
        return ret
        

    def set_cell_type_to_quadratic_linear_quad(self):
        """
        set_cell_type_to_quadratic_linear_quad(self) -> None
        C++: void set_cell_type_to_quadratic_linear_quad()"""
        ret = self._vtk_obj.SetCellTypeToQuadraticLinearQuad()
        return ret
        

    def set_cell_type_to_quadratic_linear_wedge(self):
        """
        set_cell_type_to_quadratic_linear_wedge(self) -> None
        C++: void set_cell_type_to_quadratic_linear_wedge()"""
        ret = self._vtk_obj.SetCellTypeToQuadraticLinearWedge()
        return ret
        

    def set_cell_type_to_quadratic_polygon(self):
        """
        set_cell_type_to_quadratic_polygon(self) -> None
        C++: void set_cell_type_to_quadratic_polygon()"""
        ret = self._vtk_obj.SetCellTypeToQuadraticPolygon()
        return ret
        

    def set_cell_type_to_quadratic_pyramid(self):
        """
        set_cell_type_to_quadratic_pyramid(self) -> None
        C++: void set_cell_type_to_quadratic_pyramid()"""
        ret = self._vtk_obj.SetCellTypeToQuadraticPyramid()
        return ret
        

    def set_cell_type_to_quadratic_quad(self):
        """
        set_cell_type_to_quadratic_quad(self) -> None
        C++: void set_cell_type_to_quadratic_quad()"""
        ret = self._vtk_obj.SetCellTypeToQuadraticQuad()
        return ret
        

    def set_cell_type_to_quadratic_tetra(self):
        """
        set_cell_type_to_quadratic_tetra(self) -> None
        C++: void set_cell_type_to_quadratic_tetra()"""
        ret = self._vtk_obj.SetCellTypeToQuadraticTetra()
        return ret
        

    def set_cell_type_to_quadratic_triangle(self):
        """
        set_cell_type_to_quadratic_triangle(self) -> None
        C++: void set_cell_type_to_quadratic_triangle()"""
        ret = self._vtk_obj.SetCellTypeToQuadraticTriangle()
        return ret
        

    def set_cell_type_to_quadratic_wedge(self):
        """
        set_cell_type_to_quadratic_wedge(self) -> None
        C++: void set_cell_type_to_quadratic_wedge()"""
        ret = self._vtk_obj.SetCellTypeToQuadraticWedge()
        return ret
        

    def set_cell_type_to_tetra(self):
        """
        set_cell_type_to_tetra(self) -> None
        C++: void set_cell_type_to_tetra()"""
        ret = self._vtk_obj.SetCellTypeToTetra()
        return ret
        

    def set_cell_type_to_tri_quadratic_hexahedron(self):
        """
        set_cell_type_to_tri_quadratic_hexahedron(self) -> None
        C++: void set_cell_type_to_tri_quadratic_hexahedron()"""
        ret = self._vtk_obj.SetCellTypeToTriQuadraticHexahedron()
        return ret
        

    def set_cell_type_to_tri_quadratic_pyramid(self):
        """
        set_cell_type_to_tri_quadratic_pyramid(self) -> None
        C++: void set_cell_type_to_tri_quadratic_pyramid()"""
        ret = self._vtk_obj.SetCellTypeToTriQuadraticPyramid()
        return ret
        

    def set_cell_type_to_triangle(self):
        """
        set_cell_type_to_triangle(self) -> None
        C++: void set_cell_type_to_triangle()"""
        ret = self._vtk_obj.SetCellTypeToTriangle()
        return ret
        

    def set_cell_type_to_triangle_strip(self):
        """
        set_cell_type_to_triangle_strip(self) -> None
        C++: void set_cell_type_to_triangle_strip()"""
        ret = self._vtk_obj.SetCellTypeToTriangleStrip()
        return ret
        

    def set_cell_type_to_vertex(self):
        """
        set_cell_type_to_vertex(self) -> None
        C++: void set_cell_type_to_vertex()"""
        ret = self._vtk_obj.SetCellTypeToVertex()
        return ret
        

    def set_cell_type_to_voxel(self):
        """
        set_cell_type_to_voxel(self) -> None
        C++: void set_cell_type_to_voxel()"""
        ret = self._vtk_obj.SetCellTypeToVoxel()
        return ret
        

    def set_cell_type_to_wedge(self):
        """
        set_cell_type_to_wedge(self) -> None
        C++: void set_cell_type_to_wedge()"""
        ret = self._vtk_obj.SetCellTypeToWedge()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GenericCell, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GenericCell properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit GenericCell properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GenericCell properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

