# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Executive(Object):
    """
    Executive - Superclass for all pipeline executives in VTK.
    
    Superclass: Object
    
    Executive is the superclass for all pipeline executives in VTK. A
    VTK executive is responsible for controlling one instance of
    Algorithm.  A pipeline consists of one or more executives that
    control data flow.  Every reader, source, writer, or data processing
    algorithm in the pipeline is implemented in an instance of
    Algorithm.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkExecutive, obj, update, **traits)
    
    def get_output_data(self, *args):
        """
        get_output_data(self, port:int) -> DataObject
        C++: virtual DataObject *get_output_data(int port)
        Get/Set the data object for an output port of the algorithm.
        """
        ret = self._wrap_call(self._vtk_obj.GetOutputData, *args)
        return wrap_vtk(ret)

    def set_output_data(self, *args):
        """
        set_output_data(self, port:int, __b:DataObject,
            info:Information) -> None
        C++: virtual void set_output_data(int port, DataObject *,
            Information *info)
        set_output_data(self, port:int, __b:DataObject) -> None
        C++: virtual void set_output_data(int port, DataObject *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetOutputData, *my_args)
        return ret

    def _get_algorithm(self):
        return wrap_vtk(self._vtk_obj.GetAlgorithm())
    algorithm = traits.Property(_get_algorithm, desc=\
        """
        Get the algorithm to which this executive has been assigned.
        """
    )

    def get_input_data(self, *args):
        """
        get_input_data(self, port:int, connection:int) -> DataObject
        C++: virtual DataObject *get_input_data(int port, int connection)
        Get the data object for an input port of the algorithm.
        """
        ret = self._wrap_call(self._vtk_obj.GetInputData, *args)
        return wrap_vtk(ret)

    def get_input_executive(self, *args):
        """
        get_input_executive(self, port:int, connection:int) -> Executive
        C++: Executive *get_input_executive(int port, int connection)
        Get the executive managing the given input connection.
        """
        ret = self._wrap_call(self._vtk_obj.GetInputExecutive, *args)
        return wrap_vtk(ret)

    def get_input_information(self, *args):
        """
        get_input_information(self, port:int, connection:int)
            -> Information
        C++: Information *get_input_information(int port, int connection)
        get_input_information(self, port:int) -> InformationVector
        C++: InformationVector *get_input_information(int port)
        Get the pipeline information for the given input connection.
        """
        ret = self._wrap_call(self._vtk_obj.GetInputInformation, *args)
        return wrap_vtk(ret)

    def get_number_of_input_connections(self, *args):
        """
        get_number_of_input_connections(self, port:int) -> int
        C++: int get_number_of_input_connections(int port)
        Get the number of input connections on the given port.
        """
        ret = self._wrap_call(self._vtk_obj.GetNumberOfInputConnections, *args)
        return ret

    def _get_number_of_input_ports(self):
        return self._vtk_obj.GetNumberOfInputPorts()
    number_of_input_ports = traits.Property(_get_number_of_input_ports, desc=\
        """
        Get the number of input/output ports for the algorithm associated
        with this executive.  Returns 0 if no algorithm is set.
        """
    )

    def _get_number_of_output_ports(self):
        return self._vtk_obj.GetNumberOfOutputPorts()
    number_of_output_ports = traits.Property(_get_number_of_output_ports, desc=\
        """
        
        """
    )

    def _get_output_information(self):
        return wrap_vtk(self._vtk_obj.GetOutputInformation())
    output_information = traits.Property(_get_output_information, desc=\
        """
        Get the pipeline information object for the given output port.
        """
    )

    def get_output_information(self, *args):
        """
        get_output_information(self, port:int) -> Information
        C++: virtual Information *get_output_information(int port)
        get_output_information(self) -> InformationVector
        C++: InformationVector *get_output_information()
        Get the pipeline information object for the given output port.
        """
        ret = self._wrap_call(self._vtk_obj.GetOutputInformation, *args)
        return wrap_vtk(ret)

    def ALGORITHM_AFTER_FORWARD(self):
        """
        algorithm__after__forward() -> InformationIntegerKey
        C++: static InformationIntegerKey *algorithm__after__forward()"""
        ret = wrap_vtk(self._vtk_obj.ALGORITHM_AFTER_FORWARD())
        return ret
        

    def ALGORITHM_BEFORE_FORWARD(self):
        """
        algorithm__before__forward() -> InformationIntegerKey
        C++: static InformationIntegerKey *algorithm__before__forward()
        Keys to program Executive::ProcessRequest with the default
        behavior for unknown requests.
        """
        ret = wrap_vtk(self._vtk_obj.ALGORITHM_BEFORE_FORWARD())
        return ret
        

    def ALGORITHM_DIRECTION(self):
        """
        algorithm__direction() -> InformationIntegerKey
        C++: static InformationIntegerKey *algorithm__direction()"""
        ret = wrap_vtk(self._vtk_obj.ALGORITHM_DIRECTION())
        return ret
        

    def CONSUMERS(self):
        """
        consumers() -> InformationExecutivePortVectorKey
        C++: static InformationExecutivePortVectorKey *consumers()
        Information key to store the executive/port number pairs
        consuming an information object.
        """
        ret = wrap_vtk(self._vtk_obj.CONSUMERS())
        return ret
        

    def FORWARD_DIRECTION(self):
        """
        forward__direction() -> InformationIntegerKey
        C++: static InformationIntegerKey *forward__direction()"""
        ret = wrap_vtk(self._vtk_obj.FORWARD_DIRECTION())
        return ret
        

    def FROM_OUTPUT_PORT(self):
        """
        from__output__port() -> InformationIntegerKey
        C++: static InformationIntegerKey *from__output__port()
        Information key to store the output port number from which a
        request is made.
        """
        ret = wrap_vtk(self._vtk_obj.FROM_OUTPUT_PORT())
        return ret
        

    def KEYS_TO_COPY(self):
        """
        keys__to__copy() -> InformationKeyVectorKey
        C++: static InformationKeyVectorKey *keys__to__copy()"""
        ret = wrap_vtk(self._vtk_obj.KEYS_TO_COPY())
        return ret
        

    def PRODUCER(self):
        """
        producer() -> InformationExecutivePortKey
        C++: static InformationExecutivePortKey *producer()
        Information key to store the executive/port number producing an
        information object.
        """
        ret = wrap_vtk(self._vtk_obj.PRODUCER())
        return ret
        

    def set_shared_output_information(self, *args):
        """
        set_shared_output_information(self, outInfoVec:InformationVector)
            -> None
        C++: void set_shared_output_information(
            InformationVector *outInfoVec)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSharedOutputInformation, *my_args)
        return ret

    def update(self, *args):
        """
        update(self) -> int
        C++: virtual TypeBool update()
        update(self, port:int) -> int
        C++: virtual TypeBool update(int port)
        Bring the algorithm's outputs up-to-date.  Returns 1 for success
        and 0 for failure.
        """
        ret = self._wrap_call(self._vtk_obj.Update, *args)
        return ret

    def update_information(self):
        """
        update_information(self) -> int
        C++: virtual int update_information()
        Bring the output information up to date.
        """
        ret = self._vtk_obj.UpdateInformation()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Executive, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Executive properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit Executive properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Executive properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

