# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.context_item import ContextItem


class EqualizerContextItem(ContextItem):
    """
    EqualizerContextItem - draws a interactive polyline
    
    Superclass: ContextItem
    
    This is a ContextItem that can be placed into a ContextScene.
    It draws a polyline, and reacts to mouse events. Initially there are
    2 points at the ends of the line. Provides the ability to add,
    remove, and move anchor points. This is not a universal polyline and
    is designed to adjust the reference points for the digital signal
    processing algorithm. So there are a number of features for
    interacting with the line:
    - the horizontal axis is frequencies; the values are of the integer
      type and cannot be negative
    - the vertical axis is the gains; the values are of the double type
      and cannot be negative
    - each reference point is limited by the values of neighboring points
    on the x-axis
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkEqualizerContextItem, obj, update, **traits)
    
    points = traits.String('0,1;500,1;', enter_set=True, auto_set=False, desc=\
        """
        Set / Get anchor points in the following format "P1x,P1y;P2x,P2y; ...
        PNx,PNy;" where X denotes the frequency, typeid(x) = int and Y
        denotes the gain, typeid(y) = float "0,1;500,1;" by default
        """
    )

    def _points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPoints,
                        self.points)

    def _get_scene(self):
        return wrap_vtk(self._vtk_obj.GetScene())
    def _set_scene(self, arg):
        old_val = self._get_scene()
        self._wrap_call(self._vtk_obj.SetScene,
                        deref_vtk(arg))
        self.trait_property_changed('scene', old_val, arg)
    scene = traits.Property(_get_scene, _set_scene, desc=\
        """
        Get the ContextScene for the item, always set for an item in a
        scene.
        """
    )

    def instantiate_handle_representation(self):
        """
        instantiate_handle_representation(self) -> None
        C++: void instantiate_handle_representation()
        A stub method that is called from para_view. Additional logic can
        be implemented here. Example of usage
        (3dwidgets_remotingviews.xml):
        
        <Proxy class="vtkequalizer_context_item"
              name="equalizer_context_item"
              post_creation="instantiate_handle_representation">
        """
        ret = self._vtk_obj.InstantiateHandleRepresentation()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('points', 'GetPoints'), ('opacity',
    'GetOpacity'), ('interactive', 'GetInteractive'), ('visible',
    'GetVisible'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'interactive', 'opacity',
    'points', 'visible'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(EqualizerContextItem, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit EqualizerContextItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['interactive', 'opacity', 'points', 'visible']),
            title='Edit EqualizerContextItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit EqualizerContextItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

