# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class DiscreteFlyingEdges2D(PolyDataAlgorithm):
    """
    DiscreteFlyingEdges2D - generate isoline(s) from 2D image data
    
    Superclass: PolyDataAlgorithm
    
    DiscreteFlyingEdges2D creates output representations of label maps
    (e.g., segmented images) using a variation of the flying edges
    algorithm. The input is a 2D image where each point is labeled
    (integer labels are preferred to real values), and the output data is
    polygonal data representing labeled regions. (Note that on output
    each region [corresponding to a different contour value] is
    represented independently; i.e., points are not shared between
    regions even if they are coincident.)
    
    @warning
    This filter is specialized to 2D images. This implementation can
    produce degenerate line segments (i.e., zero-length line segments).
    
    @warning
    Use ContourLoopExtraction if you wish to create polygons from the
    line segments.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    DiscreteMarchingCubes ContourLoopExtraction
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDiscreteFlyingEdges2D, obj, update, **traits)
    
    compute_scalars = tvtk_base.true_bool_trait(desc=\
        """
        Option to set the point scalars of the output.  The scalars will
        be the label values.  By default this flag is on.
        """
    )

    def _compute_scalars_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeScalars,
                        self.compute_scalars_)

    array_component = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Set/get which component of the scalar array to contour on;
        defaults to 0.
        """
    )

    def _array_component_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArrayComponent,
                        self.array_component)

    number_of_contours = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        Set the number of contours to place into the list. You only
        really need to use this method to reduce list size. The method
        set_value() will automatically increase list size as needed.
        """
    )

    def _number_of_contours_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfContours,
                        self.number_of_contours)

    def get_value(self, *args):
        """
        get_value(self, i:int) -> float
        C++: double get_value(int i)
        Get the ith contour value.
        """
        ret = self._wrap_call(self._vtk_obj.GetValue, *args)
        return ret

    def set_value(self, *args):
        """
        set_value(self, i:int, value:float) -> None
        C++: void set_value(int i, double value)
        Set a particular contour value at contour number i. The index i
        ranges between 0<=i<number_of_contours.
        """
        ret = self._wrap_call(self._vtk_obj.SetValue, *args)
        return ret

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_values(self):
        return self._vtk_obj.GetValues()
    values = traits.Property(_get_values, desc=\
        """
        Get a pointer to an array of contour values. There will be
        get_number_of_contours() values in the list.
        """
    )

    def get_values(self, *args):
        """
        get_values(self) -> Pointer
        C++: double *get_values()
        get_values(self, contourValues:[float, ...]) -> None
        C++: void get_values(double *contourValues)
        Get a pointer to an array of contour values. There will be
        get_number_of_contours() values in the list.
        """
        ret = self._wrap_call(self._vtk_obj.GetValues, *args)
        return ret

    def generate_values(self, *args):
        """
        generate_values(self, numContours:int, range:[float, float])
            -> None
        C++: void generate_values(int numContours, double range[2])
        generate_values(self, numContours:int, rangeStart:float,
            rangeEnd:float) -> None
        C++: void generate_values(int numContours, double rangeStart,
            double rangeEnd)
        Generate numContours equally spaced contour values between
        specified range. Contour values will include min/max range
        values.
        """
        ret = self._wrap_call(self._vtk_obj.GenerateValues, *args)
        return ret

    _updateable_traits_ = \
    (('compute_scalars', 'GetComputeScalars'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('array_component', 'GetArrayComponent'),
    ('number_of_contours', 'GetNumberOfContours'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'compute_scalars', 'debug',
    'global_warning_display', 'release_data_flag', 'array_component',
    'number_of_contours', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DiscreteFlyingEdges2D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DiscreteFlyingEdges2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compute_scalars'], [], ['array_component',
            'number_of_contours']),
            title='Edit DiscreteFlyingEdges2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DiscreteFlyingEdges2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

