# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.typed_array__if_e import TypedArray_IfE


class DenseArray_IfE(TypedArray_IfE):
    """
    DenseArray- Contiguous storage for N-way arrays.
    
    Superclass: TypedArray[float32]
    
    DenseArray is a concrete Array implementation that stores
    values using a contiguous block of memory.  Values are stored with
    fortran ordering, meaning that if you iterated over the memory block,
    the left-most coordinates would vary the fastest.
    
    In addition to the retrieval and update methods provided by
    TypedArray, DenseArray provides methods to:
    
    Fill the entire array with a specific value.
    
    Retrieve a pointer to the storage memory block.
    
    @sa
    Array, TypedArray, SparseArray
    
    @par Thanks: Developed by Timothy M. Shead (tshead@sandia.gov) at
    Sandia National Laboratories.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDenseArray_IfE, obj, update, **traits)
    
    def get_value(self, *args):
        """
        get_value(self, i:int) -> float
        get_value(self, i:int, j:int) -> float
        get_value(self, i:int, j:int, k:int) -> float
        C++: const float &get_value(CoordinateT i, CoordinateT j,
            CoordinateT k) override;
        get_value(self, coordinates:ArrayCoordinates) -> float
        C++: const float &get_value(const ArrayCoordinates &coordinates)
             override;
        Returns the value stored in the array at the given coordinates.
        Note that the number of dimensions in the supplied coordinates
        must match the number of dimensions in the array.
        """
        my_args = deref_array(args, [['int'], ('int', 'int'), ('int', 'int', 'int'), ['vtkArrayCoordinates']])
        ret = self._wrap_call(self._vtk_obj.GetValue, *my_args)
        return ret

    def set_value(self, *args):
        """
        set_value(self, i:int, value:float) -> None
        set_value(self, i:int, j:int, value:float) -> None
        C++: void set_value(CoordinateT i, CoordinateT j,
            const float &value) override;
        set_value(self, i:int, j:int, k:int, value:float) -> None
        C++: void set_value(CoordinateT i, CoordinateT j, CoordinateT k,
            const float &value) override;
        set_value(self, coordinates:ArrayCoordinates, value:float)
            -> None
        C++: void set_value(const ArrayCoordinates &coordinates,
            const float &value) override;
        Overwrites the value stored in the array at the given
        coordinates. Note that the number of dimensions in the supplied
        coordinates must match the number of dimensions in the array.
        """
        my_args = deref_array(args, [('int', 'float'), ('int', 'int', 'float'), ('int', 'int', 'int', 'float'), ('vtkArrayCoordinates', 'float')])
        ret = self._wrap_call(self._vtk_obj.SetValue, *my_args)
        return ret

    def get_value_n(self, *args):
        """
        get_value_n(self, n:int) -> float
        
        Returns the n-th value stored in the array, where n is in the
        range [0, get_non_null_size()).  This is useful for efficiently
        visiting every value in the array.  Note that the order in which
        values are visited is undefined, but is guaranteed to match the
        order used by Array::GetCoordinatesN().
        """
        ret = self._wrap_call(self._vtk_obj.GetValueN, *args)
        return ret

    def set_value_n(self, *args):
        """
        set_value_n(self, n:int, value:float) -> None
        
        Overwrites the n-th value stored in the array, where n is in the
        range [0, get_non_null_size()).  This is useful for efficiently
        visiting every value in the array.  Note that the order in which
        values are visited is undefined, but is guaranteed to match the
        order used by Array::GetCoordinatesN().
        """
        ret = self._wrap_call(self._vtk_obj.SetValueN, *args)
        return ret

    def _get_storage(self):
        return self._vtk_obj.GetStorage()
    storage = traits.Property(_get_storage, desc=\
        """
        Returns a mutable reference to the underlying storage.  Values
        are stored contiguously with fortran ordering.  Use at your own
        risk!
        """
    )

    def fill(self, *args):
        """
        fill(self, value:float) -> None
        C++: void fill(const float &value)
        Fills every element in the array with the given value.
        """
        ret = self._wrap_call(self._vtk_obj.Fill, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('name', 'GetName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DenseArray_IfE, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DenseArray_IfE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['name']),
            title='Edit DenseArray_IfE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DenseArray_IfE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

