# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class DataTransferHelper(Object):
    """
    DataTransferHelper - is a helper class that aids in transferring
     data between CPU memory and GPU memory.
    
    Superclass: Object
    
    DataTransferHelper is a helper class that aids in transferring
    data
     between the CPU memory and the GPU memory. The data in GPU memory is
     stored as textures which that in CPU memory is stored as
    DataArray.
     DataTransferHelper provides API to transfer only a sub-extent of
    CPU
     structured data to/from the GPU.
    
    @sa
     PixelBufferObject TextureObject OpenGLExtensionManager
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDataTransferHelper, obj, update, **traits)
    
    def _get_array(self):
        return wrap_vtk(self._vtk_obj.GetArray())
    def _set_array(self, arg):
        old_val = self._get_array()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetArray,
                        my_arg[0])
        self.trait_property_changed('array', old_val, arg)
    array = traits.Property(_get_array, _set_array, desc=\
        """
        Get/Set the CPU data buffer. Initial value is 0.
        """
    )

    cpu_extent = traits.Array(enter_set=True, auto_set=False, shape=(6,), dtype="int64", value=(0, 0, 0, 0, 0, 0), cols=3, desc=\
        """
        Set the CPU data extent. The extent matches the DataArray
        size. If the DataArray comes from an ImageData and it is
        part of the point data, it is usually the ImageData extent. It
        can be on cell data too, but in this case it does not match the
        ImageData extent. If the DataArray comes from a DataSet,
        just set it to a one-dimenstional extent equal to the number of
        tuples. Initial value is (0,0,0,0,0,0), a valid one tuple array.
        """
    )

    def _cpu_extent_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCPUExtent,
                        self.cpu_extent)

    def _get_context(self):
        return wrap_vtk(self._vtk_obj.GetContext())
    def _set_context(self, arg):
        old_val = self._get_context()
        self._wrap_call(self._vtk_obj.SetContext,
                        deref_vtk(arg))
        self.trait_property_changed('context', old_val, arg)
    context = traits.Property(_get_context, _set_context, desc=\
        """
        
        """
    )

    gpu_extent = traits.Array(enter_set=True, auto_set=False, shape=(6,), dtype="int64", value=(0, 0, 0, 0, 0, 0), cols=3, desc=\
        """
        Set the GPU data extent. This is the sub-extent to copy from or
        to the GPU. This extent matches the size of the data to transfer.
        GPUExtent and texture_extent don't have to match (GPUExtent can be
        1D whereas texture_extent is 2D) but the number of elements have
        to match. Initial value is (0,0,0,0,0,0), a valid one tuple
        array.
        """
    )

    def _gpu_extent_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGPUExtent,
                        self.gpu_extent)

    min_texture_dimension = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        Define the minimal dimension of the texture regardless of the
        dimensions of the texture_extent. Initial value is 1. A texture
        extent can have a given dimension 0D (one value), 1D, 2D or 3D.
        By default 0D and 1D are translated into a 1D texture, 2D is
        translated into a 2D texture, 3D is translated into a 3D texture.
        To make life easier when writing GLSL code and use only one type
        of sampler (ex: sampler2d), the default behavior can be changed
        by forcing a type of texture with this ivar. 1: default behavior.
        Initial value. 2: force 0D and 1D to be in a 2D texture 3: force
        0D, 1D and 2D texture to be in a 3D texture.
        """
    )

    def _min_texture_dimension_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMinTextureDimension,
                        self.min_texture_dimension)

    shader_supports_texture_int = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _shader_supports_texture_int_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetShaderSupportsTextureInt,
                        self.shader_supports_texture_int)

    def _get_texture(self):
        return wrap_vtk(self._vtk_obj.GetTexture())
    def _set_texture(self, arg):
        old_val = self._get_texture()
        self._wrap_call(self._vtk_obj.SetTexture,
                        deref_vtk(arg))
        self.trait_property_changed('texture', old_val, arg)
    texture = traits.Property(_get_texture, _set_texture, desc=\
        """
        Get/Set the GPU data buffer. Initial value is 0.
        """
    )

    texture_extent = traits.Array(enter_set=True, auto_set=False, shape=(6,), dtype="int64", value=(0, -1, 0, -1, 0, -1), cols=3, desc=\
        """
        Set the texture data extent. This is the extent of the texture
        image that will receive the data. This extent matches the size of
        the data to transfer. If it is set to an invalid extent,
        GPUExtent is used. See more comment on GPUExtent. Initial value
        is an invalid extent.
        """
    )

    def _texture_extent_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTextureExtent,
                        self.texture_extent)

    def _get_cpu_extent_is_valid(self):
        return self._vtk_obj.GetCPUExtentIsValid()
    cpu_extent_is_valid = traits.Property(_get_cpu_extent_is_valid, desc=\
        """
        Tells if CPUExtent is valid. True if min extent<=max extent.
        """
    )

    def get_extent_is_valid(self, *args):
        """
        get_extent_is_valid(self, extent:[int, ...]) -> bool
        C++: bool get_extent_is_valid(int *extent)
        Tells if the given extent (6 int) is valid. True if min
        extent<=max extent.
        \\pre extent_exists: extent!=0
        """
        ret = self._wrap_call(self._vtk_obj.GetExtentIsValid, *args)
        return ret

    def _get_gpu_extent_is_valid(self):
        return self._vtk_obj.GetGPUExtentIsValid()
    gpu_extent_is_valid = traits.Property(_get_gpu_extent_is_valid, desc=\
        """
        Tells if GPUExtent is valid. True if min extent<=max extent.
        """
    )

    def _get_texture_extent_is_valid(self):
        return self._vtk_obj.GetTextureExtentIsValid()
    texture_extent_is_valid = traits.Property(_get_texture_extent_is_valid, desc=\
        """
        Tells if texture_extent is valid. True if min extent<=max extent.
        """
    )

    def download(self):
        """
        download(self) -> bool
        C++: bool download()
        old comment: Download Extent from GPU data buffer to CPU. GPU
        data size must exactly match Extent. CPU data buffer will be
        resized to match whole_extent in which only the Extent will be
        filled with the GPU data. new comment: Download GPUExtent from
        GPU texture to CPU DataArray. If Array is not provided, it
        will be created with the size of CPUExtent. But only the tuples
        covered by GPUExtent will be download. In this case, if GPUExtent
        does not cover all GPUExtent, some of the DataArray will be
        uninitialized. Reminder: A=>B <=> !A||B
        \\pre texture_exists: texture!=0
        \\pre array_not_empty: array==0 || array->get_number_of_tuples()>0
        \\pre valid_cpu_extent: this->get_cpu_extent_is_valid()
        \\pre valid_cpu_extent_size: array==0 ||
        (CPUExtent[1]-CPUExtent[0]+1)*(CPUExtent[3]-CPUExtent[2]+1)*(CPUEx
        tent[5]-CPUExtent[4]+1)==array->get_number_of_tuples()
        \\pre valid_gpu_extent: this->get_gpu_extent_is_valid()
        \\pre gpu_extent_in_cpu_extent: CPUExtent[0]<=GPUExtent[0] &&
            GPUExtent[1]<=CPUExtent[1] &&
        CPUExtent[2]<=GPUExtent[2] && GPUExtent[3]<=CPUExtent[3] &&
        CPUExtent[4]<=GPUExtent[4] && GPUExtent[5]<=CPUExtent[5] \\pre
        gpu_texture_size: !this->get_texture_extent_is_valid() ||
        (GPUExtent[1]-GPUExtent[0]+1)*(GPUExtent[3]-GPUExtent[2]+1)*(GPUEx
        tent[5]-GPUExtent[4]+1)==(texture_extent[1]-texture_extent[0]+1)*(Te
        xtureExtent[3]-texture_extent[2]+1)*(texture_extent[5]-texture_extent
        [4]+1)
        \\pre valid_components: array==0 ||
            array->get_number_of_components()<=4
        \\pre components_match: array==0 ||
            (texture->get_components()==array->get_number_of_components())
        """
        ret = self._vtk_obj.Download()
        return ret
        

    def download_async1(self):
        """
        download_async1(self) -> bool
        C++: bool download_async1()
        Splits the download in two operations
        * Asynchronously download from texture memory to PBO
          (download_async1()).
        * Copy from pbo to user array (download_async2()).
        """
        ret = self._vtk_obj.DownloadAsync1()
        return ret
        

    def download_async2(self):
        """
        download_async2(self) -> bool
        C++: bool download_async2()"""
        ret = self._vtk_obj.DownloadAsync2()
        return ret
        

    def is_supported(self, *args):
        """
        is_supported(renWin:RenderWindow) -> bool
        C++: static bool is_supported(RenderWindow *renWin)
        Returns if the context supports the required extensions.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.IsSupported, *my_args)
        return ret

    def upload(self, *args):
        """
        upload(self, components:int=0, componentList:[int, ...]=...)
            -> bool
        C++: bool upload(int components=0, int *componentList=nullptr)
        Old comment. Upload Extent from CPU data buffer to GPU. The
        whole_extent must match the Array size. New comment. Upload
        GPUExtent from CPU DataArray to GPU texture. It is possible to
        send a subset of the components or to specify and order of
        components or both. If components=0, componentList is ignored and
        all components are passed, a texture cannot have more than 4
        components.
        \\pre array_exists: array!=0
        \\pre array_not_empty: array->get_number_of_tuples()>0
        \\pre valid_cpu_extent: this->get_cpu_extent_is_valid()
        \\pre valid_cpu_extent_size:
        (CPUExtent[1]-CPUExtent[0]+1)*(CPUExtent[3]-CPUExtent[2]+1)*(CPUEx
        tent[5]-CPUExtent[4]+1)==array->get_number_of_tuples()
        \\pre valid_gpu_extent: this->get_gpu_extent_is_valid()
        \\pre gpu_extent_in_cpu_extent: CPUExtent[0]<=GPUExtent[0] &&
            GPUExtent[1]<=CPUExtent[1] &&
        CPUExtent[2]<=GPUExtent[2] && GPUExtent[3]<=CPUExtent[3] &&
        CPUExtent[4]<=GPUExtent[4] && GPUExtent[5]<=CPUExtent[5] \\pre
        gpu_texture_size: !this->get_texture_extent_is_valid() ||
        (GPUExtent[1]-GPUExtent[0]+1)*(GPUExtent[3]-GPUExtent[2]+1)*(GPUEx
        tent[5]-GPUExtent[4]+1)==(texture_extent[1]-texture_extent[0]+1)*(Te
        xtureExtent[3]-texture_extent[2]+1)*(texture_extent[5]-texture_extent
        [4]+1)
        \\pre texture_can_exist_or_not: texture==0 || texture!=0
        \\pre valid_components: (components==0 && componentList==0 &&
            array->get_number_of_components()<=4)
        || (components>=1 && components<=array->get_number_of_components()
        && components<=4 && componentList!=0)
        """
        ret = self._wrap_call(self._vtk_obj.Upload, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('cpu_extent', 'GetCPUExtent'),
    ('gpu_extent', 'GetGPUExtent'), ('min_texture_dimension',
    'GetMinTextureDimension'), ('shader_supports_texture_int',
    'GetShaderSupportsTextureInt'), ('texture_extent',
    'GetTextureExtent'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'cpu_extent', 'gpu_extent',
    'min_texture_dimension', 'shader_supports_texture_int',
    'texture_extent'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DataTransferHelper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DataTransferHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['cpu_extent', 'gpu_extent', 'min_texture_dimension',
            'shader_supports_texture_int', 'texture_extent']),
            title='Edit DataTransferHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DataTransferHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

