# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class DataAssemblyUtilities(Object):
    """
    DataAssemblyUtilities - collections of utilities for
    DataAssembly
    
    Superclass: Object
    
    DataAssemblyUtilities provides useful utilities for working with
    DataAssembly.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDataAssemblyUtilities, obj, update, **traits)
    
    def get_data_assembly(self, *args):
        """
        get_data_assembly(name:str, cd:CompositeDataSet)
            -> SmartPointer_I15vtkDataAssemblyE
        C++: static SmartPointer<vtkDataAssembly> get_data_assembly(
            const char *name, CompositeDataSet *cd)
        Convenience method to get a named DataAssembly from a
        CompositeDataSet, if available. May return nullptr if none
        exists or possible.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetDataAssembly, *my_args)
        return wrap_vtk(ret)

    def get_selected_composite_ids(self, *args):
        """
        get_selected_composite_ids(selectors:(str, ...),
            hierarchyOrAssembly:DataAssembly,
            data:PartitionedDataSetCollection=...,
            leaf_nodes_only:bool=False) -> (int, ...)
        C++: static std::vector<unsigned int> get_selected_composite_ids(
            const std::vector<std::string> &selectors,
            DataAssembly *hierarchyOrAssembly,
            PartitionedDataSetCollection *data=nullptr,
            bool leaf_nodes_only=false)
        Given a DataAssembly and collection of selectors, returns a
        list of selected composite indices for the selected nodes. The
        DataAssembly can represent either a hierarchy or simply be an
        assembly. For the later, an associated
        `vtkpartitioned_data_set_collection` must be provided to correctly
        determine the composite index for the selected nodes. When an
        hierarchy is used, the hierarchy encodes enough information to
        determine composite ids and hence the `data` argument must be
        nullptr.
        
        `leaf_nodes_only` can be used to indicate if the composite ids
        must only refer to leaf nodes i.e. nodes that cannot have
        additional child nodes.
        """
        ret = self._wrap_call(self._vtk_obj.GetSelectedCompositeIds, *args)
        return ret

    def get_selector_for_composite_id(self, *args):
        """
        get_selector_for_composite_id(id:int, hierarchy:DataAssembly)
            -> str
        C++: static std::string get_selector_for_composite_id(unsigned int id,
             DataAssembly *hierarchy)
        For a DataAssembly representing an hierarchy, returns the
        selector for the given composite id. Note, the selectors maybe
        best-match. When dealing with PartitionedDataSetCollection,
        for example, a composite id may point to a particular dataset in
        a nested PartitionedDataSet, however, selectors are simply not
        expressive enough to pick a dataset at that level and hence will
        simply point to the parent PartitionedDataSet.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetSelectorForCompositeId, *my_args)
        return ret

    def get_selectors_for_composite_ids(self, *args):
        """
        get_selectors_for_composite_ids(ids:(int, ...),
            hierarchy:DataAssembly) -> (str, ...)
        C++: static std::vector<std::string> get_selectors_for_composite_ids(
            const std::vector<unsigned int> &ids,
            DataAssembly *hierarchy)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetSelectorsForCompositeIds, *my_args)
        return ret

    def generate_composite_data_set_from_hierarchy(self, *args):
        """
        generate_composite_data_set_from_hierarchy(
            input:PartitionedDataSetCollection,
            hierarchy:DataAssembly)
            -> SmartPointer_I19vtkCompositeDataSetE
        C++: static SmartPointer<vtkCompositeDataSet> generate_composite_data_set_from_hierarchy(
            PartitionedDataSetCollection *input,
            DataAssembly *hierarchy)
        Inverse of `generate_hierarchy`. Given a
        PartitionedDataSetCollection and a DataAssembly
        representing a target hierarchy, create a appropriate
        CompositeDataSet subclass representing that hierarchy.
        
        A note about OverlappingAMR: since all meta-data necessary for
        defining a valid OverlappingAMR is not encoded in the
        hierarchy, the return OverlappingAMR is not complete (or
        valid) and is missing key meta-data. Calling code must use other
        mechanisms to make the dataset valid.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GenerateCompositeDataSetFromHierarchy, *my_args)
        return wrap_vtk(ret)

    def generate_hierarchy(self, *args):
        """
        generate_hierarchy(input:CompositeDataSet,
            hierarchy:DataAssembly,
            output:PartitionedDataSetCollection=...) -> bool
        C++: static bool generate_hierarchy(CompositeDataSet *input,
            DataAssembly *hierarchy,
            PartitionedDataSetCollection *output=nullptr)
        Populates `hierarchy` with a representation of the hierarchy for
        the given composite dataset `input`. A hierarchy represents the
        input dataset's structure as represented in the dataset itself.
        
        If `output` is non-null, then the input is also converted to a
        `vtkpartitioned_data_set_collection`. The DataAssembly on the
        `output` is updated to be a copy of the hierarchy with correct
        dataset indices so that relationships in the input blocks are
        preserved.
        
        If input is not a `vtkmulti_block_data_set`,
        `vtkpartitioned_data_set_collection`, or `vtkuniform_grid_amr`, then
        there's no hierarchy to represent and hence this function will
        return `false`.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GenerateHierarchy, *my_args)
        return ret

    def hierarchy_name(self):
        """
        hierarchy_name() -> str
        C++: static const char *hierarchy_name()
        Returns the named used by VTK to correspond to a DataAssembly
        associated with the structure of a composite dataset.
        """
        ret = self._vtk_obj.HierarchyName()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DataAssemblyUtilities, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DataAssemblyUtilities properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit DataAssemblyUtilities properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DataAssemblyUtilities properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

