# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.selection_algorithm import SelectionAlgorithm


class ConvertSelection(SelectionAlgorithm):
    """
    ConvertSelection - Convert a selection from one type to another
    
    Superclass: SelectionAlgorithm
    
    ConvertSelection converts an input selection from one type to
    another in the context of a data object being selected. The first
    input is the selection, while the second input is the data object
    that the selection relates to.
    
    @sa
    Selection SelectionNode ExtractSelection
    ExtractSelectedGraph
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkConvertSelection, obj, update, **traits)
    
    allow_missing_array = tvtk_base.false_bool_trait(desc=\
        """
        When enabled, not finding expected array will not return an
        error. Defaults to OFF.
        """
    )

    def _allow_missing_array_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAllowMissingArray,
                        self.allow_missing_array_)

    match_any_values = tvtk_base.false_bool_trait(desc=\
        """
        When on, creates a separate selection node for each array.
        Defaults to OFF.
        """
    )

    def _match_any_values_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMatchAnyValues,
                        self.match_any_values_)

    array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        The output array name for value or threshold selections.
        """
    )

    def _array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArrayName,
                        self.array_name)

    def _get_array_names(self):
        return wrap_vtk(self._vtk_obj.GetArrayNames())
    def _set_array_names(self, arg):
        old_val = self._get_array_names()
        my_arg = deref_array([arg], [['vtkStringArray']])
        self._wrap_call(self._vtk_obj.SetArrayNames,
                        my_arg[0])
        self.trait_property_changed('array_names', old_val, arg)
    array_names = traits.Property(_get_array_names, _set_array_names, desc=\
        """
        
        """
    )

    input_field_type = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        """
        The input field type. If this is set to a number other than -1,
        ignores the input selection field type and instead assumes that
        all selection nodes have the field type specified. This should be
        one of the constants defined in SelectionNode.h. Default is
        -1.
        """
    )

    def _input_field_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInputFieldType,
                        self.input_field_type)

    output_type = traits.Int(4, enter_set=True, auto_set=False, desc=\
        """
        The output selection content type. This should be one of the
        constants defined in SelectionNode.h.
        """
    )

    def _output_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputType,
                        self.output_type)

    def _get_selection_extractor(self):
        return wrap_vtk(self._vtk_obj.GetSelectionExtractor())
    def _set_selection_extractor(self, arg):
        old_val = self._get_selection_extractor()
        self._wrap_call(self._vtk_obj.SetSelectionExtractor,
                        deref_vtk(arg))
        self.trait_property_changed('selection_extractor', old_val, arg)
    selection_extractor = traits.Property(_get_selection_extractor, _set_selection_extractor, desc=\
        """
        
        """
    )

    def get_selected_cells(self, *args):
        """
        get_selected_cells(input:Selection, data:DataSet,
            indices:IdTypeArray) -> None
        C++: static void get_selected_cells(Selection *input,
            DataSet *data, IdTypeArray *indices)"""
        my_args = deref_array(args, [('vtkSelection', 'vtkDataSet', 'vtkIdTypeArray')])
        ret = self._wrap_call(self._vtk_obj.GetSelectedCells, *my_args)
        return ret

    def get_selected_edges(self, *args):
        """
        get_selected_edges(input:Selection, data:Graph,
            indices:IdTypeArray) -> None
        C++: static void get_selected_edges(Selection *input,
            Graph *data, IdTypeArray *indices)"""
        my_args = deref_array(args, [('vtkSelection', 'vtkGraph', 'vtkIdTypeArray')])
        ret = self._wrap_call(self._vtk_obj.GetSelectedEdges, *my_args)
        return ret

    def get_selected_items(self, *args):
        """
        get_selected_items(input:Selection, data:DataObject,
            fieldType:int, indices:IdTypeArray) -> None
        C++: static void get_selected_items(Selection *input,
            DataObject *data, int fieldType, IdTypeArray *indices)
        Static generic method for obtaining selected items from a data
        object. Other static methods (e.g. get_selected_vertices) call this
        one.
        """
        my_args = deref_array(args, [('vtkSelection', 'vtkDataObject', 'int', 'vtkIdTypeArray')])
        ret = self._wrap_call(self._vtk_obj.GetSelectedItems, *my_args)
        return ret

    def get_selected_points(self, *args):
        """
        get_selected_points(input:Selection, data:DataSet,
            indices:IdTypeArray) -> None
        C++: static void get_selected_points(Selection *input,
            DataSet *data, IdTypeArray *indices)"""
        my_args = deref_array(args, [('vtkSelection', 'vtkDataSet', 'vtkIdTypeArray')])
        ret = self._wrap_call(self._vtk_obj.GetSelectedPoints, *my_args)
        return ret

    def get_selected_rows(self, *args):
        """
        get_selected_rows(input:Selection, data:Table,
            indices:IdTypeArray) -> None
        C++: static void get_selected_rows(Selection *input,
            Table *data, IdTypeArray *indices)"""
        my_args = deref_array(args, [('vtkSelection', 'vtkTable', 'vtkIdTypeArray')])
        ret = self._wrap_call(self._vtk_obj.GetSelectedRows, *my_args)
        return ret

    def get_selected_vertices(self, *args):
        """
        get_selected_vertices(input:Selection, data:Graph,
            indices:IdTypeArray) -> None
        C++: static void get_selected_vertices(Selection *input,
            Graph *data, IdTypeArray *indices)
        Static methods for easily obtaining selected items from a data
        object. The array argument will be filled with the selected
        items.
        """
        my_args = deref_array(args, [('vtkSelection', 'vtkGraph', 'vtkIdTypeArray')])
        ret = self._wrap_call(self._vtk_obj.GetSelectedVertices, *my_args)
        return ret

    def add_array_name(self, *args):
        """
        add_array_name(self, __a:str) -> None
        C++: void add_array_name(const char *)
        Convenience methods used by UI
        """
        ret = self._wrap_call(self._vtk_obj.AddArrayName, *args)
        return ret

    def clear_array_names(self):
        """
        clear_array_names(self) -> None
        C++: void clear_array_names()"""
        ret = self._vtk_obj.ClearArrayNames()
        return ret
        

    def set_data_object_connection(self, *args):
        """
        set_data_object_connection(self, in_:AlgorithmOutput) -> None
        C++: void set_data_object_connection(AlgorithmOutput *in)
        A convenience method for setting the second input (i.e. the data
        object).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetDataObjectConnection, *my_args)
        return ret

    def to_global_id_selection(self, *args):
        """
        to_global_id_selection(input:Selection, data:DataObject)
            -> Selection
        C++: static Selection *to_global_id_selection(Selection *input,
             DataObject *data)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ToGlobalIdSelection, *my_args)
        return wrap_vtk(ret)

    def to_index_selection(self, *args):
        """
        to_index_selection(input:Selection, data:DataObject)
            -> Selection
        C++: static Selection *to_index_selection(Selection *input,
            DataObject *data)
        Static methods for easily converting between selection types.
        NOTE: The returned selection pointer IS reference counted, so be
        sure to Delete() it when you are done with it.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ToIndexSelection, *my_args)
        return wrap_vtk(ret)

    def to_pedigree_id_selection(self, *args):
        """
        to_pedigree_id_selection(input:Selection, data:DataObject)
            -> Selection
        C++: static Selection *to_pedigree_id_selection(
            Selection *input, DataObject *data)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ToPedigreeIdSelection, *my_args)
        return wrap_vtk(ret)

    def to_selection_type(self, *args):
        """
        to_selection_type(input:Selection, data:DataObject, type:int,
            arrayNames:StringArray=..., inputFieldType:int=-1,
            allowMissingArray:bool=False) -> Selection
        C++: static Selection *to_selection_type(Selection *input,
            DataObject *data, int type,
            StringArray *arrayNames=nullptr, int inputFieldType=-1,
            bool allowMissingArray=false)
        A generic static method for converting selection types. The type
        should be an integer constant defined in SelectionNode.h.
        """
        ret = self._wrap_call(self._vtk_obj.ToSelectionType, *args)
        return ret

    def to_value_selection(self, *args):
        """
        to_value_selection(input:Selection, data:DataObject,
            arrayName:str) -> Selection
        C++: static Selection *to_value_selection(Selection *input,
            DataObject *data, const char *arrayName)
        to_value_selection(input:Selection, data:DataObject,
            arrayNames:StringArray) -> Selection
        C++: static Selection *to_value_selection(Selection *input,
            DataObject *data, StringArray *arrayNames)"""
        my_args = deref_array(args, [('vtkSelection', 'vtkDataObject', 'string'), ('vtkSelection', 'vtkDataObject', 'vtkStringArray')])
        ret = self._wrap_call(self._vtk_obj.ToValueSelection, *my_args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('allow_missing_array', 'GetAllowMissingArray'), ('match_any_values',
    'GetMatchAnyValues'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('array_name',
    'GetArrayName'), ('input_field_type', 'GetInputFieldType'),
    ('output_type', 'GetOutputType'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'allow_missing_array', 'debug',
    'global_warning_display', 'match_any_values', 'release_data_flag',
    'array_name', 'input_field_type', 'output_type', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ConvertSelection, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ConvertSelection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['allow_missing_array', 'match_any_values'], [], ['array_name',
            'input_field_type', 'output_type']),
            title='Edit ConvertSelection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ConvertSelection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

