# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class ContourGrid(PolyDataAlgorithm):
    """
    ContourGrid - generate isosurfaces/isolines from scalar values
    (specialized for unstructured grids)
    
    Superclass: PolyDataAlgorithm
    
    ContourGrid is a filter that takes as input datasets of type
    UnstructuredGrid and generates on output isosurfaces and/or
    isolines. The exact form of the output depends upon the
    dimensionality of the input data.  Data consisting of 3D cells will
    generate isosurfaces, data consisting of 2D cells will generate
    isolines, and data with 1D or 0D cells will generate isopoints.
    Combinations of output type are possible if the input dimension is
    mixed.
    
    To use this filter you must specify one or more contour values. You
    can either use the method set_value() to specify each contour value,
    or use generate_values() to generate a series of evenly spaced
    contours. It is also possible to accelerate the operation of this
    filter (at the cost of extra memory) by using a ScalarTree. A
    scalar tree is used to quickly locate cells that contain a contour
    surface. This is especially effective if multiple contours are being
    extracted. If you want to use a scalar tree, invoke the method
    use_scalar_tree_on().
    
    @warning
    If the input UnstructuredGrid contains 3D linear cells, the class
    Contour3DLinearGrid is much faster and may be preferred in certain
    applications.
    
    @warning
    For unstructured data or structured grids, normals and gradients are
    not computed. Use PolyDataNormals to compute the surface normals
    of the resulting isosurface.
    
    @sa
    Contour3DLinearGrid ContourFilter MarchingContourFilter
    FlyingEdges3D MarchingCubes SliceCubes DividingCubes
    MarchingSquares ImageMarchingCubes
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkContourGrid, obj, update, **traits)
    
    compute_normals = tvtk_base.false_bool_trait(desc=\
        """
        Set/Get the computation of normals. Normal computation is fairly
        expensive in both time and storage. If the output data will be
        processed by filters that modify topology or geometry, it may be
        wise to turn Normals and Gradients off.
        """
    )

    def _compute_normals_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeNormals,
                        self.compute_normals_)

    compute_scalars = tvtk_base.true_bool_trait(desc=\
        """
        Set/Get the computation of scalars.
        """
    )

    def _compute_scalars_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeScalars,
                        self.compute_scalars_)

    generate_triangles = tvtk_base.true_bool_trait(desc=\
        """
        If this is enabled (by default), the output will be triangles
        otherwise, the output may be represented by one or more polygons.
        WARNING: if the resulting isocontour is not planar, and
        generate_triangles is false, the output may consist of some 3D
        polygons (i.e., which may be non-planar) - which might be nice to
        look at but hard to compute with downstream.
        """
    )

    def _generate_triangles_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateTriangles,
                        self.generate_triangles_)

    use_scalar_tree = tvtk_base.false_bool_trait(desc=\
        """
        Enable the use of a scalar tree to accelerate contour extraction.
        """
    )

    def _use_scalar_tree_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseScalarTree,
                        self.use_scalar_tree_)

    def _get_locator(self):
        return wrap_vtk(self._vtk_obj.GetLocator())
    def _set_locator(self, arg):
        old_val = self._get_locator()
        self._wrap_call(self._vtk_obj.SetLocator,
                        deref_vtk(arg))
        self.trait_property_changed('locator', old_val, arg)
    locator = traits.Property(_get_locator, _set_locator, desc=\
        """
        
        """
    )

    number_of_contours = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _number_of_contours_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfContours,
                        self.number_of_contours)

    output_points_precision = traits.Int(2, enter_set=True, auto_set=False, desc=\
        """
        Set/get the desired precision for the output types. See the
        documentation for the Algorithm::DesiredOutputPrecision enum
        for an explanation of the available precision settings.
        """
    )

    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    def _get_scalar_tree(self):
        return wrap_vtk(self._vtk_obj.GetScalarTree())
    def _set_scalar_tree(self, arg):
        old_val = self._get_scalar_tree()
        self._wrap_call(self._vtk_obj.SetScalarTree,
                        deref_vtk(arg))
        self.trait_property_changed('scalar_tree', old_val, arg)
    scalar_tree = traits.Property(_get_scalar_tree, _set_scalar_tree, desc=\
        """
        
        """
    )

    def get_value(self, *args):
        """
        get_value(self, i:int) -> float
        C++: double get_value(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetValue, *args)
        return ret

    def set_value(self, *args):
        """
        set_value(self, i:int, value:float) -> None
        C++: void set_value(int i, double value)
        Methods to set / get contour values.
        """
        ret = self._wrap_call(self._vtk_obj.SetValue, *args)
        return ret

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_values(self):
        return self._vtk_obj.GetValues()
    values = traits.Property(_get_values, desc=\
        """
        
        """
    )

    def get_values(self, *args):
        """
        get_values(self) -> Pointer
        C++: double *get_values()
        get_values(self, contourValues:[float, ...]) -> None
        C++: void get_values(double *contourValues)"""
        ret = self._wrap_call(self._vtk_obj.GetValues, *args)
        return ret

    def create_default_locator(self):
        """
        create_default_locator(self) -> None
        C++: void create_default_locator()
        Create default locator. Used to create one when none is
        specified. The locator is used to merge coincident points.
        """
        ret = self._vtk_obj.CreateDefaultLocator()
        return ret
        

    def generate_values(self, *args):
        """
        generate_values(self, numContours:int, range:[float, float])
            -> None
        C++: void generate_values(int numContours, double range[2])
        generate_values(self, numContours:int, rangeStart:float,
            rangeEnd:float) -> None
        C++: void generate_values(int numContours, double rangeStart,
            double rangeEnd)"""
        ret = self._wrap_call(self._vtk_obj.GenerateValues, *args)
        return ret

    _updateable_traits_ = \
    (('compute_normals', 'GetComputeNormals'), ('compute_scalars',
    'GetComputeScalars'), ('generate_triangles', 'GetGenerateTriangles'),
    ('use_scalar_tree', 'GetUseScalarTree'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('number_of_contours',
    'GetNumberOfContours'), ('output_points_precision',
    'GetOutputPointsPrecision'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'compute_normals', 'compute_scalars', 'debug',
    'generate_triangles', 'global_warning_display', 'release_data_flag',
    'use_scalar_tree', 'number_of_contours', 'output_points_precision',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ContourGrid, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ContourGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compute_normals', 'compute_scalars', 'generate_triangles',
            'use_scalar_tree'], [], ['number_of_contours',
            'output_points_precision']),
            title='Edit ContourGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ContourGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

