# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class CompositeDataDisplayAttributes(Object):
    """
    CompositeDataDisplayAttributes - Rendering attributes for a
    multi-block dataset.
    
    Superclass: Object
    
    The CompositeDataDisplayAttributes class stores display attributes
    for individual blocks in a multi-block dataset. It uses the actual
    data block's pointer as a key (vtkdata_object*).
    
    @warning It is considered unsafe to dereference key pointers at any
        time,
    they should only serve as keys to access the internal map.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCompositeDataDisplayAttributes, obj, update, **traits)
    
    def get_block_color(self, *args):
        """
        get_block_color(self, data_object:DataObject, color:[float,
            float, float]) -> None
        C++: void get_block_color(DataObject *data_object,
            double color[3])
        get_block_color(self, data_object:DataObject) -> Color3d
        C++: Color3d get_block_color(DataObject *data_object)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetBlockColor, *my_args)
        return wrap_vtk(ret)

    def set_block_color(self, *args):
        """
        set_block_color(self, data_object:DataObject, color:(float,
            float, float)) -> None
        C++: void set_block_color(DataObject *data_object,
            const double color[3])
        Set/get the color for the block with data_object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetBlockColor, *my_args)
        return ret

    def get_block_material(self, *args):
        """
        get_block_material(self, data_object:DataObject) -> str
        C++: const std::string &get_block_material(
            DataObject *data_object)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetBlockMaterial, *my_args)
        return ret

    def set_block_material(self, *args):
        """
        set_block_material(self, data_object:DataObject, material:str)
            -> None
        C++: void set_block_material(DataObject *data_object,
            const std::string &material)
        Set/get the material for the block with data_object. Only
        rendering backends that support advanced materials need to
        respect these.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetBlockMaterial, *my_args)
        return ret

    def get_block_opacity(self, *args):
        """
        get_block_opacity(self, data_object:DataObject) -> float
        C++: double get_block_opacity(DataObject *data_object)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetBlockOpacity, *my_args)
        return ret

    def set_block_opacity(self, *args):
        """
        set_block_opacity(self, data_object:DataObject, opacity:float)
            -> None
        C++: void set_block_opacity(DataObject *data_object,
            double opacity)
        Set/get the opacity for the block with data_object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetBlockOpacity, *my_args)
        return ret

    def get_block_pickability(self, *args):
        """
        get_block_pickability(self, data_object:DataObject) -> bool
        C++: bool get_block_pickability(DataObject *data_object)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetBlockPickability, *my_args)
        return ret

    def set_block_pickability(self, *args):
        """
        set_block_pickability(self, data_object:DataObject, visible:bool)
             -> None
        C++: void set_block_pickability(DataObject *data_object,
            bool visible)
        Set/get the pickability for the block with data_object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetBlockPickability, *my_args)
        return ret

    def get_block_visibility(self, *args):
        """
        get_block_visibility(self, data_object:DataObject) -> bool
        C++: bool get_block_visibility(DataObject *data_object)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetBlockVisibility, *my_args)
        return ret

    def set_block_visibility(self, *args):
        """
        set_block_visibility(self, data_object:DataObject, visible:bool)
            -> None
        C++: void set_block_visibility(DataObject *data_object,
            bool visible)
        Set/get the visibility for the block with data_object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetBlockVisibility, *my_args)
        return ret

    def compute_visible_bounds(self, *args):
        """
        compute_visible_bounds(cda:CompositeDataDisplayAttributes,
            dobj:DataObject, bounds:[float, float, float, float, float,
             float]) -> None
        C++: static void compute_visible_bounds(
            CompositeDataDisplayAttributes *cda, DataObject *dobj,
            double bounds[6])
        If the input dobj is a CompositeDataSet, we will loop over the
        hierarchy recursively starting from initial index 0 and use only
        visible blocks, which is specified in the
        CompositeDataDisplayAttributes cda, to compute the bounds.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ComputeVisibleBounds, *my_args)
        return ret

    def data_object_from_index(self, *args):
        """
        data_object_from_index(flat_index:int, parent_obj:DataObject,
            current_flat_index:int=0) -> DataObject
        C++: static DataObject *data_object_from_index(
            const unsigned int flat_index, DataObject *parent_obj,
            unsigned int current_flat_index=0)
        Get the data_object corresponding to the node with index
        flat_index under parent_obj. Traverses the entire hierarchy
        recursively.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DataObjectFromIndex, *my_args)
        return wrap_vtk(ret)

    def has_block_color(self, *args):
        """
        has_block_color(self, data_object:DataObject) -> bool
        C++: bool has_block_color(DataObject *data_object)
        Returns true if the block with the given data_object has a color.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HasBlockColor, *my_args)
        return ret

    def has_block_colors(self):
        """
        has_block_colors(self) -> bool
        C++: bool has_block_colors()
        Returns true if any block has any block color is set.
        """
        ret = self._vtk_obj.HasBlockColors()
        return ret
        

    def has_block_material(self, *args):
        """
        has_block_material(self, data_object:DataObject) -> bool
        C++: bool has_block_material(DataObject *data_object)
        Returns true if the block with data_object has an material set.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HasBlockMaterial, *my_args)
        return ret

    def has_block_materials(self):
        """
        has_block_materials(self) -> bool
        C++: bool has_block_materials()
        Returns true if any block has an material set.
        """
        ret = self._vtk_obj.HasBlockMaterials()
        return ret
        

    def has_block_opacities(self):
        """
        has_block_opacities(self) -> bool
        C++: bool has_block_opacities()
        Returns true if any block has an opacity set.
        """
        ret = self._vtk_obj.HasBlockOpacities()
        return ret
        

    def has_block_opacity(self, *args):
        """
        has_block_opacity(self, data_object:DataObject) -> bool
        C++: bool has_block_opacity(DataObject *data_object)
        Returns true if the block with data_object has an opacity set.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HasBlockOpacity, *my_args)
        return ret

    def has_block_pickabilities(self):
        """
        has_block_pickabilities(self) -> bool
        C++: bool has_block_pickabilities()
        Returns true if any block has any block pickability is set.
        """
        ret = self._vtk_obj.HasBlockPickabilities()
        return ret
        

    def has_block_pickability(self, *args):
        """
        has_block_pickability(self, data_object:DataObject) -> bool
        C++: bool has_block_pickability(DataObject *data_object)
        Returns true if the block with the given data_object has a
        pickability set.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HasBlockPickability, *my_args)
        return ret

    def has_block_visibilities(self):
        """
        has_block_visibilities(self) -> bool
        C++: bool has_block_visibilities()
        Returns true if any block has any block visibility is set.
        """
        ret = self._vtk_obj.HasBlockVisibilities()
        return ret
        

    def has_block_visibility(self, *args):
        """
        has_block_visibility(self, data_object:DataObject) -> bool
        C++: bool has_block_visibility(DataObject *data_object)
        Returns true if the block with the given data_object has a
        visibility set.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HasBlockVisibility, *my_args)
        return ret

    def remove_block_color(self, *args):
        """
        remove_block_color(self, data_object:DataObject) -> None
        C++: void remove_block_color(DataObject *data_object)
        Removes the block color for the block with data_object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveBlockColor, *my_args)
        return ret

    def remove_block_colors(self):
        """
        remove_block_colors(self) -> None
        C++: void remove_block_colors()
        Removes all block colors.
        """
        ret = self._vtk_obj.RemoveBlockColors()
        return ret
        

    def remove_block_material(self, *args):
        """
        remove_block_material(self, data_object:DataObject) -> None
        C++: void remove_block_material(DataObject *data_object)
        Removes the set material for the block with data_object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveBlockMaterial, *my_args)
        return ret

    def remove_block_materials(self):
        """
        remove_block_materials(self) -> None
        C++: void remove_block_materials()
        Removes all block materialss.
        """
        ret = self._vtk_obj.RemoveBlockMaterials()
        return ret
        

    def remove_block_opacities(self):
        """
        remove_block_opacities(self) -> None
        C++: void remove_block_opacities()
        Removes all block opacities.
        """
        ret = self._vtk_obj.RemoveBlockOpacities()
        return ret
        

    def remove_block_opacity(self, *args):
        """
        remove_block_opacity(self, data_object:DataObject) -> None
        C++: void remove_block_opacity(DataObject *data_object)
        Removes the set opacity for the block with data_object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveBlockOpacity, *my_args)
        return ret

    def remove_block_pickabilities(self):
        """
        remove_block_pickabilities(self) -> None
        C++: void remove_block_pickabilities()
        Removes all block pickability flags. This effectively sets the
        pickability for all blocks to true.
        """
        ret = self._vtk_obj.RemoveBlockPickabilities()
        return ret
        

    def remove_block_pickability(self, *args):
        """
        remove_block_pickability(self, data_object:DataObject) -> None
        C++: void remove_block_pickability(DataObject *data_object)
        Removes the block pickability flag for the block with
        data_object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveBlockPickability, *my_args)
        return ret

    def remove_block_visibilities(self):
        """
        remove_block_visibilities(self) -> None
        C++: void remove_block_visibilities()
        Removes all block visibility flags. This effectively sets the
        visibility for all blocks to true.
        """
        ret = self._vtk_obj.RemoveBlockVisibilities()
        return ret
        

    def remove_block_visibility(self, *args):
        """
        remove_block_visibility(self, data_object:DataObject) -> None
        C++: void remove_block_visibility(DataObject *data_object)
        Removes the block visibility flag for the block with data_object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveBlockVisibility, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CompositeDataDisplayAttributes, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CompositeDataDisplayAttributes properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit CompositeDataDisplayAttributes properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CompositeDataDisplayAttributes properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

