# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.find_cell_strategy import FindCellStrategy


class ClosestPointStrategy(FindCellStrategy):
    """
    ClosestPointStrategy - implement a specific
    PointSet::FindCell() strategy based
             on closest point
    
    Superclass: FindCellStrategy
    
    ClosestPointStrategy is implements a find_cell() strategy based on
    locating the closest point in a dataset, and then searching the
    attached cells. While relatively fast, it does not always return the
    correct result (it may not find a cell, since the closest cell may
    not be connected to the closest point). CellLocatorStrategy or
    ClosestNPointsStrategy will produce better results at the cost of
    speed.
    
    @sa
    FindCellStrategy PointSet CellLocatorStrategy
    ClosestNPointsStrategy
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkClosestPointStrategy, obj, update, **traits)
    
    def _get_point_locator(self):
        return wrap_vtk(self._vtk_obj.GetPointLocator())
    def _set_point_locator(self, arg):
        old_val = self._get_point_locator()
        self._wrap_call(self._vtk_obj.SetPointLocator,
                        deref_vtk(arg))
        self.trait_property_changed('point_locator', old_val, arg)
    point_locator = traits.Property(_get_point_locator, _set_point_locator, desc=\
        """
        
        """
    )

    def select_cell(self, *args):
        """
        select_cell(self, self_:PointSet, cellId:int, cell:Cell,
            gencell:GenericCell) -> Cell
        C++: Cell *select_cell(PointSet *self, IdType cellId,
            Cell *cell, GenericCell *gencell)
        Subclasses use this method to select the current cell.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SelectCell, *my_args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ClosestPointStrategy, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ClosestPointStrategy properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit ClosestPointStrategy properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ClosestPointStrategy properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

