# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.multi_block_data_set_algorithm import MultiBlockDataSetAlgorithm


class CGNSFileSeriesReader(MultiBlockDataSetAlgorithm):
    """
    CGNSFileSeriesReader - Adds support for reading temporal or
    partitioned CGNS files.
    
    Superclass: MultiBlockDataSetAlgorithm
    
    CGNSFileSeriesReader is a meta-reader that add support for reading
    CGNS file series using CGNSReader. We encounter two types of file
    series with CGNS:
    \li 1. temporal file series - where each file is simply a single
        timestep.
    \li 2. partitioned file series - where each file corresponds to data
        dumped
           out from a rank but has all timesteps.
    
    
     CGNSFileSeriesReader determines the nature of the file series
     encountered and reads the files accordingly. For partitioned files,
    the
     files are distributed among data-processing ranks, while for
    temporal file
     series, blocks are distributed among data-processing ranks (using
    logic in
     CGNSReader itself).
    
    @sa FileSeriesHelper
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCGNSFileSeriesReader, obj, update, **traits)
    
    ignore_reader_time = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _ignore_reader_time_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIgnoreReaderTime,
                        self.ignore_reader_time_)

    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        """
        
        """
    )

    def _get_reader(self):
        return wrap_vtk(self._vtk_obj.GetReader())
    def _set_reader(self, arg):
        old_val = self._get_reader()
        self._wrap_call(self._vtk_obj.SetReader,
                        deref_vtk(arg))
        self.trait_property_changed('reader', old_val, arg)
    reader = traits.Property(_get_reader, _set_reader, desc=\
        """
        
        """
    )

    def _get_current_file_name(self):
        return self._vtk_obj.GetCurrentFileName()
    current_file_name = traits.Property(_get_current_file_name, desc=\
        """
        Returns the filename being used for current timesteps. This is
        only reasonable for temporal file series. For a partitioned file
        series, this will return the filename being used on the current
        rank.
        """
    )

    def add_file_name(self, *args):
        """
        add_file_name(self, fname:str) -> None
        C++: void add_file_name(const char *fname)
        Add/remove files names in the file series.
        """
        ret = self._wrap_call(self._vtk_obj.AddFileName, *args)
        return ret

    def can_read_file(self, *args):
        """
        can_read_file(self, filename:str) -> int
        C++: int can_read_file(const char *filename)
        Test a file for readability. Ensure that
        CGNSFileSeriesReader::SetReader is called before using this
        method.
        """
        ret = self._wrap_call(self._vtk_obj.CanReadFile, *args)
        return ret

    def remove_all_file_names(self):
        """
        remove_all_file_names(self) -> None
        C++: void remove_all_file_names()"""
        ret = self._vtk_obj.RemoveAllFileNames()
        return ret
        

    _updateable_traits_ = \
    (('ignore_reader_time', 'GetIgnoreReaderTime'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'ignore_reader_time', 'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CGNSFileSeriesReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CGNSFileSeriesReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['ignore_reader_time'], [], []),
            title='Edit CGNSFileSeriesReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CGNSFileSeriesReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

