# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_set_algorithm import DataSetAlgorithm


class CellValidator(DataSetAlgorithm):
    """
    CellValidator - validates cells in a dataset
    
    Superclass: DataSetAlgorithm
    
    CellValidator accepts as input a dataset and adds integral cell
    data to it corresponding to the "validity" of each cell. The validity
    field encodes a bitfield for identifying problems that prevent a cell
    from standard use, including:
    
    
      wrong_number_of_points: filters assume that a cell has access to the
                           appropriate number of points that comprise it.
    This
                           assumption is often tacit, resulting in
    unexpected
                           behavior when the condition is not met. This
    check
                           simply confirms that the cell has the minimum
    number
                           of points needed to describe it.
    
    
      intersecting_edges: cells that incorrectly describe the order of
    their
                         points often manifest with intersecting edges or
                         intersecting faces. Given a tolerance, this
    check
                         ensures that two edges from a two-dimensional
    cell
                         are separated by at least the tolerance
    (discounting
                         end-to-end connections).
    
    
      intersecting_faces: cells that incorrectly describe the order of
    their
                         points often manifest with intersecting edges or
                         intersecting faces. Given a tolerance, this
    check
                         ensures that two faces from a three-dimensional
    cell
                         do not intersect.
    
    
      noncontiguous_edges: another symptom of incorrect point ordering
    within a
                          cell is the presence of noncontiguous edges
    where
                          contiguous edges are otherwise expected. Given
    a
                          tolerance, this check ensures that edges around
    the
                          perimeter of a two-dimensional cell are
    contiguous.
    
    
      Nonconvex: many algorithms implicitly require that all input three-
                 dimensional cells be convex. This check uses the generic
                 convexity checkers implemented in Polygon and
    Polyhedron
                 to test this requirement.
    
    
      faces_are_oriented_incorrectly: All three-dimensional cells have an
    implicit
                                   expectation for the orientation of
    their
                                   faces. While the convention is
    unfortunately
                                   inconsistent across cell types, it is
    usually
                                   required that cell faces point
    outward. This
                                   check tests that the faces of a cell
    point in
                                   the direction required by the cell
    type,
                                   taking into account the cell types
    with
                                   nonstandard orientation requirements.
    
    @sa
    CellQuality
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCellValidator, obj, update, **traits)
    
    tolerance = traits.Trait(1.1920928955078125e-07, traits.Range(0.0, 1e+299, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the tolerance. This value is used as an epsilon for
        floating point equality checks throughout the cell checking
        process. The default value is FLT_EPSILON.
        """
    )

    def _tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTolerance,
                        self.tolerance)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    def check(self, *args):
        """
        check(__a:GenericCell, tolerance:float) -> State
        C++: static State check(GenericCell *, double tolerance)
        check(__a:Cell, tolerance:float) -> State
        C++: static State check(Cell *, double tolerance)
        check(__a:EmptyCell, tolerance:float) -> State
        C++: static State check(EmptyCell *, double tolerance)
        check(__a:Vertex, tolerance:float) -> State
        C++: static State check(Vertex *, double tolerance)
        check(__a:PolyVertex, tolerance:float) -> State
        C++: static State check(PolyVertex *, double tolerance)
        check(__a:Line, tolerance:float) -> State
        C++: static State check(Line *, double tolerance)
        check(__a:PolyLine, tolerance:float) -> State
        C++: static State check(PolyLine *, double tolerance)
        check(__a:Triangle, tolerance:float) -> State
        C++: static State check(Triangle *, double tolerance)
        check(__a:TriangleStrip, tolerance:float) -> State
        C++: static State check(TriangleStrip *, double tolerance)
        check(__a:Polygon, tolerance:float) -> State
        C++: static State check(Polygon *, double tolerance)
        check(__a:Pixel, tolerance:float) -> State
        C++: static State check(Pixel *, double tolerance)
        check(__a:Quad, tolerance:float) -> State
        C++: static State check(Quad *, double tolerance)
        check(__a:Tetra, tolerance:float) -> State
        C++: static State check(Tetra *, double tolerance)
        check(__a:Voxel, tolerance:float) -> State
        C++: static State check(Voxel *, double tolerance)
        check(__a:Hexahedron, tolerance:float) -> State
        C++: static State check(Hexahedron *, double tolerance)
        check(__a:Wedge, tolerance:float) -> State
        C++: static State check(Wedge *, double tolerance)
        check(__a:Pyramid, tolerance:float) -> State
        C++: static State check(Pyramid *, double tolerance)
        check(__a:PentagonalPrism, tolerance:float) -> State
        C++: static State check(PentagonalPrism *, double tolerance)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Check, *my_args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('tolerance',
    'GetTolerance'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'progress_text', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CellValidator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CellValidator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['tolerance']),
            title='Edit CellValidator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CellValidator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

