# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_set_algorithm import DataSetAlgorithm


class CellDataToPointData(DataSetAlgorithm):
    """
    CellDataToPointData - map cell data to point data
    
    Superclass: DataSetAlgorithm
    
    CellDataToPointData is a filter that transforms cell data (i.e.,
    data specified per cell) into point data (i.e., data specified at
    cell points). The method of transformation is based on averaging the
    data values of all cells using each point. For large datasets with
    several cell data arrays, the filter optionally supports selective
    processing to speed up processing. Optionally, the input cell data
    can be passed through to the output as well.
    
    Options exist to control which cells are used to perform the
    averaging operation. Since unstructured grids and polydata can
    contain cells of different dimensions, in some cases it is desirable
    to perform cell averaging using cells of a specified dimension. The
    available options to control this functionality are All (default),
    Patch and data_set_max. Patch uses only the highest dimension cells
    attached to a point. data_set_max uses the highest cell dimension in
    the entire data set.
    
    @warning
    This filter is an abstract filter, that is, the output is an abstract
    type (i.e., DataSet). Use the convenience methods (e.g.,
    get_poly_data_output(), get_structured_points_output(), etc.) to get the
    type of output you want.
    
    @warning
    For maximum performance, use the contributing_cell_option=All. Other
    options significantly, negatively impact performance (on the order of
    >10x).
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential execution type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    PointData CellData PointDataToCellData
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCellDataToPointData, obj, update, **traits)
    
    pass_cell_data = tvtk_base.false_bool_trait(desc=\
        """
        Control whether the input cell data is to be passed to the
        output. If on, then the input cell data is passed through to the
        output; otherwise, only generated point data is placed into the
        output.
        """
    )

    def _pass_cell_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassCellData,
                        self.pass_cell_data_)

    process_all_arrays = tvtk_base.true_bool_trait(desc=\
        """
        Activate selective processing of arrays. If false, only arrays
        selected by the user will be considered by this filter. The
        default is true.
        """
    )

    def _process_all_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetProcessAllArrays,
                        self.process_all_arrays_)

    contributing_cell_option = traits.Trait(0, traits.Range(0, 2, enter_set=True, auto_set=False), desc=\
        """
        Option to specify what cells to include in the cell-averaging
        computation. Options are all cells (All, Patch and data_set_max).
        The default is All.
        """
    )

    def _contributing_cell_option_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetContributingCellOption,
                        self.contributing_cell_option)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    def add_cell_data_array(self, *args):
        """
        add_cell_data_array(self, name:str) -> None
        C++: virtual void add_cell_data_array(const char *name)
        Adds an array to be processed. This only has an effect if the
        process_all_arrays option is turned off. If a name is already
        present, nothing happens.
        """
        ret = self._wrap_call(self._vtk_obj.AddCellDataArray, *args)
        return ret

    def clear_cell_data_arrays(self):
        """
        clear_cell_data_arrays(self) -> None
        C++: virtual void clear_cell_data_arrays()
        Removes all arrays to be processed from the list. This only has
        an effect if the process_all_arrays option is turned off.
        """
        ret = self._vtk_obj.ClearCellDataArrays()
        return ret
        

    def remove_cell_data_array(self, *args):
        """
        remove_cell_data_array(self, name:str) -> None
        C++: virtual void remove_cell_data_array(const char *name)
        Removes an array to be processed. This only has an effect if the
        process_all_arrays option is turned off. If the specified name is
        not present, nothing happens.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveCellDataArray, *args)
        return ret

    _updateable_traits_ = \
    (('pass_cell_data', 'GetPassCellData'), ('process_all_arrays',
    'GetProcessAllArrays'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('contributing_cell_option', 'GetContributingCellOption'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'pass_cell_data', 'process_all_arrays', 'release_data_flag',
    'contributing_cell_option', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CellDataToPointData, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CellDataToPointData properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['pass_cell_data', 'process_all_arrays'], [],
            ['contributing_cell_option']),
            title='Edit CellDataToPointData properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CellDataToPointData properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

