# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class CellCenters(PolyDataAlgorithm):
    """
    CellCenters - generate points at center of cells
    
    Superclass: PolyDataAlgorithm
    
    CellCenters is a filter that takes as input any dataset and
    generates on output points at the center of the cells in the dataset.
    These points can be used for placing glyphs (Glyph3D) or labeling
    (vtklabeled_data_mapper). (The center is the parametric center of the
    cell, not necessarily the geometric or bounding box center.) The cell
    attributes will be associated with the points on output.
    
    @warning
    You can choose to generate just points or points and vertex cells.
    Vertex cells are drawn during rendering; points are not. Use the ivar
    vertex_cells to generate cells.
    
    ote Empty cells will be ignored but will require a one by one cell to
    point data copy that will make the processing slower.
    
    @sa
    Glyph3D LabeledDataMapper
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCellCenters, obj, update, **traits)
    
    copy_arrays = tvtk_base.true_bool_trait(desc=\
        """
        Enable/disable whether input cell data arrays should be passed
        through (or copied) as output point data arrays. Default is
        `true` i.e. the arrays will be propagated.
        """
    )

    def _copy_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCopyArrays,
                        self.copy_arrays_)

    vertex_cells = tvtk_base.false_bool_trait(desc=\
        """
        Enable/disable the generation of vertex cells. The default is
        Off.
        """
    )

    def _vertex_cells_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVertexCells,
                        self.vertex_cells_)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def compute_cell_centers(self, *args):
        """
        compute_cell_centers(dataset:DataSet, centers:DoubleArray)
            -> None
        C++: static void compute_cell_centers(DataSet *dataset,
            DoubleArray *centers)
        Compute centers of cells from a dataset, storing them in the
        centers array.
        """
        my_args = deref_array(args, [('vtkDataSet', 'vtkDoubleArray')])
        ret = self._wrap_call(self._vtk_obj.ComputeCellCenters, *my_args)
        return ret

    _updateable_traits_ = \
    (('copy_arrays', 'GetCopyArrays'), ('vertex_cells', 'GetVertexCells'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'copy_arrays', 'debug', 'global_warning_display',
    'release_data_flag', 'vertex_cells', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CellCenters, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CellCenters properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['copy_arrays', 'vertex_cells'], [], []),
            title='Edit CellCenters properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CellCenters properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

