# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.geometry_filter import GeometryFilter


class AdaptiveDataSetSurfaceFilter(GeometryFilter):
    """
    AdaptiveDataSetSurfaceFilter - Adaptively extract dataset surface
    
    Superclass: GeometryFilter
    
    AdaptiveDataSetSurfaceFilter uses view and dataset properties to
    create the outside surface mesh with the minimum minimorum of facets
    @warning
    Only implemented currently for 2-dimensional HyperTreeGrid objects
    @sa
    HyperTreeGrid DataSetSurfaceFilter@par Thanks: This class was
    written by Guenole Harel and Jacques-Bernard Lekien, 2014 This class
    was rewritten by Philippe Pebay, 2016 This class was modified by
    Rogeli Grima, 2016 This work was supported by Commissariat a
    l'Energie Atomique (CEA/DIF) CEA, DAM, DIF, F-91297 Arpajon, France.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAdaptiveDataSetSurfaceFilter, obj, update, **traits)
    
    bb_selection = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        """
        Set/Get for active the bounding box selection viewport (defaut
        false) JB C'est un facteur supplementaire d'acceleration possible
        JB uniquement si l'on ne peut faire de rotation dans la vue.
        """
    )

    def _bb_selection_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBBSelection,
                        self.bb_selection)

    circle_selection = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        """
        Set/Get for active the circle selection viewport (defaut true)
        """
    )

    def _circle_selection_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCircleSelection,
                        self.circle_selection)

    dynamic_decimate_level_max = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        JB Set/Get reduit de autant le niveau max de profondeur, calcule
        JB dynamiquement a parcourir dans la JB representation HTG.
        (defaut 0)
        """
    )

    def _dynamic_decimate_level_max_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDynamicDecimateLevelMax,
                        self.dynamic_decimate_level_max)

    fixed_level_max = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        """
        Set/Get for forced a fixed the level max (lost dynamicity)
        (defaut -1)
        """
    )

    def _fixed_level_max_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFixedLevelMax,
                        self.fixed_level_max)

    def _get_renderer(self):
        return wrap_vtk(self._vtk_obj.GetRenderer())
    def _set_renderer(self, arg):
        old_val = self._get_renderer()
        self._wrap_call(self._vtk_obj.SetRenderer,
                        deref_vtk(arg))
        self.trait_property_changed('renderer', old_val, arg)
    renderer = traits.Property(_get_renderer, _set_renderer, desc=\
        """
        
        """
    )

    scale = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        JB Set/Get the scale factor influence le calcul de l'adaptive
        view. JB Pour un raffinement de 2, donner Scale=2*X revient a
        faire un JB appel a dynamic_decimate_level_max avec la valeur X.
        (defaut 1)
        """
    )

    def _scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScale,
                        self.scale)

    view_point_depend = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        """
        JB Activation de la dependance au point de vue. Par defaut a
        True.
        """
    )

    def _view_point_depend_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetViewPointDepend,
                        self.view_point_depend)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('cell_clipping', 'GetCellClipping'), ('delegation',
    'GetDelegation'), ('extent_clipping', 'GetExtentClipping'),
    ('fast_mode', 'GetFastMode'), ('merging', 'GetMerging'),
    ('pass_through_cell_ids', 'GetPassThroughCellIds'),
    ('pass_through_point_ids', 'GetPassThroughPointIds'),
    ('point_clipping', 'GetPointClipping'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('bb_selection', 'GetBBSelection'),
    ('circle_selection', 'GetCircleSelection'),
    ('dynamic_decimate_level_max', 'GetDynamicDecimateLevelMax'),
    ('fixed_level_max', 'GetFixedLevelMax'), ('scale', 'GetScale'),
    ('view_point_depend', 'GetViewPointDepend'), ('cell_maximum',
    'GetCellMaximum'), ('cell_minimum', 'GetCellMinimum'), ('degree',
    'GetDegree'), ('extent', 'GetExtent'), ('nonlinear_subdivision_level',
    'GetNonlinearSubdivisionLevel'), ('original_cell_ids_name',
    'GetOriginalCellIdsName'), ('original_point_ids_name',
    'GetOriginalPointIdsName'), ('output_points_precision',
    'GetOutputPointsPrecision'), ('piece_invariant', 'GetPieceInvariant'),
    ('point_maximum', 'GetPointMaximum'), ('point_minimum',
    'GetPointMinimum'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'cell_clipping', 'debug', 'delegation',
    'extent_clipping', 'fast_mode', 'global_warning_display', 'merging',
    'pass_through_cell_ids', 'pass_through_point_ids', 'point_clipping',
    'release_data_flag', 'bb_selection', 'cell_maximum', 'cell_minimum',
    'circle_selection', 'degree', 'dynamic_decimate_level_max', 'extent',
    'fixed_level_max', 'nonlinear_subdivision_level',
    'original_cell_ids_name', 'original_point_ids_name',
    'output_points_precision', 'piece_invariant', 'point_maximum',
    'point_minimum', 'progress_text', 'scale', 'view_point_depend'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AdaptiveDataSetSurfaceFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AdaptiveDataSetSurfaceFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['cell_clipping', 'delegation', 'extent_clipping', 'fast_mode',
            'merging', 'pass_through_cell_ids', 'pass_through_point_ids',
            'point_clipping'], [], ['bb_selection', 'cell_maximum',
            'cell_minimum', 'circle_selection', 'degree',
            'dynamic_decimate_level_max', 'extent', 'fixed_level_max',
            'nonlinear_subdivision_level', 'original_cell_ids_name',
            'original_point_ids_name', 'output_points_precision',
            'piece_invariant', 'point_maximum', 'point_minimum', 'scale',
            'view_point_depend']),
            title='Edit AdaptiveDataSetSurfaceFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AdaptiveDataSetSurfaceFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

