# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class XMLCompositeDataSetWriterHelper(Object):
    """
    XMLCompositeDataSetWriterHelper - a helper class used by
    XMLWriter2 subclasses that write composite
           datasets.
    
    Superclass: Object
    
    XMLCompositeDataSetWriterHelper is a helper class intended to be
    used by subclasses of XMLWriter2 that want to write composite
    datasets. It consolidates the logic to write individual datasets for
    leaf nodes into separate files.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkXMLCompositeDataSetWriterHelper, obj, update, **traits)
    
    def _get_writer(self):
        return wrap_vtk(self._vtk_obj.GetWriter())
    def _set_writer(self, arg):
        old_val = self._get_writer()
        self._wrap_call(self._vtk_obj.SetWriter,
                        deref_vtk(arg))
        self.trait_property_changed('writer', old_val, arg)
    writer = traits.Property(_get_writer, _set_writer, desc=\
        """
        
        """
    )

    def write_data_set(self, *args):
        """
        write_data_set(self, path:str, prefix:str, data:DataObject)
            -> str
        C++: std::string write_data_set(const std::string &path,
            const std::string &prefix, DataObject *data)
        Write a specific dataset to a file. The dataset cannot be a
        composite dataset. The implementation uses
        `XMLdata_object_writer` to find a writer to use. Internally,
        writers are cached and will be reused when same type of data is
        being written out multiple times.
        
        The filename is created using the `path` and `prefix`. The prefix
        is extended with a `.` where the `` is dictated by the writer
        used. `XMLwriter_base::get_default_file_extension` is used to
        obtain the extension to use for the file written out.
        
        On success, returns `
        
        .`, otherwise an empty string is returned.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.WriteDataSet, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(XMLCompositeDataSetWriterHelper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit XMLCompositeDataSetWriterHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit XMLCompositeDataSetWriterHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit XMLCompositeDataSetWriterHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

