# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class VtkJSSceneGraphSerializer(Object):
    """
    VtkJSSceneGraphSerializer - Converts elements of a VTK scene graph
    into vtk-js elements
    
    Superclass: Object
    
    VtkJSSceneGraphSerializer accepts nodes and their renderables from
    a scene graph and a) composes the elements' data and topology into a
    Json data structure and b) correlates unique identifiers for data
    objects in the Json data structure to the data objects themselves. It
    is designed to operate with VtkJSViewNodeFactory, which handles
    the logic for scene graph traversal.
    
    When constructing the Json description for a single scene graph node
    and its renderable, the Add(node, renderable) step processes the
    renderable into its corresponding vtk-js form. For many renderables
    this is a no-op, but current restrictions in vtk-js (such as the lack
    of support for composite mappers and the requirement for data
    conversion to PolyData) require a nontrival conversion step for
    certain renderable types. The subsequent to_json(renderable) is a
    straightforward conversion of the renderable's data members into a
    vtk-js Json format.
    
    @sa
    VtkJSViewNodeFactory
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkVtkJSSceneGraphSerializer, obj, update, **traits)
    
    def get_data_array(self, *args):
        """
        get_data_array(self, __a:int) -> DataArray
        C++: DataArray *get_data_array(IdType)"""
        ret = self._wrap_call(self._vtk_obj.GetDataArray, *args)
        return wrap_vtk(ret)

    def get_data_array_id(self, *args):
        """
        get_data_array_id(self, __a:int) -> str
        C++: std::string get_data_array_id(IdType)"""
        ret = self._wrap_call(self._vtk_obj.GetDataArrayId, *args)
        return ret

    def get_data_object(self, *args):
        """
        get_data_object(self, __a:int) -> DataObject
        C++: DataObject *get_data_object(IdType)"""
        ret = self._wrap_call(self._vtk_obj.GetDataObject, *args)
        return wrap_vtk(ret)

    def _get_number_of_data_arrays(self):
        return self._vtk_obj.GetNumberOfDataArrays()
    number_of_data_arrays = traits.Property(_get_number_of_data_arrays, desc=\
        """
        Access the data arrays referenced in the constructed scene.
        """
    )

    def _get_number_of_data_objects(self):
        return self._vtk_obj.GetNumberOfDataObjects()
    number_of_data_objects = traits.Property(_get_number_of_data_objects, desc=\
        """
        Access the data objects referenced in the constructed scene.
        """
    )

    def add(self, *args):
        """
        add(self, __a:ViewNode, __b:Actor) -> None
        C++: virtual void add(ViewNode *, Actor *)
        add(self, __a:ViewNode, __b:CompositePolyDataMapper) -> None
        C++: virtual void add(ViewNode *, CompositePolyDataMapper *)
        add(self, __a:ViewNode, __b:CompositePolyDataMapper2)
            -> None
        C++: virtual void add(ViewNode *,
            CompositePolyDataMapper2 *)
        add(self, __a:ViewNode, __b:Glyph3DMapper) -> None
        C++: virtual void add(ViewNode *, Glyph3DMapper *)
        add(self, __a:ViewNode, __b:Mapper) -> None
        C++: virtual void add(ViewNode *, Mapper *)
        add(self, __a:ViewNode, __b:Renderer) -> None
        C++: virtual void add(ViewNode *, Renderer *)
        add(self, __a:ViewNode, __b:RenderWindow) -> None
        C++: virtual void add(ViewNode *, RenderWindow *)
        Add a scene graph node and its corresponding renderable to the
        scene.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Add, *my_args)
        return ret

    def reset(self):
        """
        reset(self) -> None
        C++: void reset()
        Empty the contents of the scene and the reset the unique id
        generator.
        """
        ret = self._vtk_obj.Reset()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(VtkJSSceneGraphSerializer, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit VtkJSSceneGraphSerializer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit VtkJSSceneGraphSerializer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit VtkJSSceneGraphSerializer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

