# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.non_linear_cell import NonLinearCell


class TriQuadraticPyramid(NonLinearCell):
    """
    TriQuadraticPyramid - cell represents a parabolic, 13-node
    isoparametric pyramid
    
    Superclass: NonLinearCell
    
    TriQuadraticPyramid is a concrete implementation of
    NonLinearCell to represent a second order three-dimensional
    isoparametric 19-node pyramid. The interpolation is the standard
    finite element, tri-quadratic isoparametric shape function. The cell
    includes 5 corner nodes, 8 mid-edge nodes, 5 mid-face nodes, and 1
    volumetric centroid node. The ordering of the nineteen points
    defining the cell is point ids (0-4, 5-12, 13-17, 18), where point
    ids 0-4 are the five corner vertices of the pyramid; followed by 8
    mid-edge nodes (5-12); followed by 5 mid-face nodes (13-17), and the
    last node (19) is the volumetric centroid node. Note that these
    mid-edge nodes lie on the edges defined by (0, 1), (1, 2), (2, 3),
    (3, 0), (0, 4), (1, 4), (2, 4), (3, 4), respectively. The mid-face
    nodes lie on the faces defined by (first corner nodes id's, then mid-edge node
    id's): quadrilateral face: (0, 3, 2, 1, 8, 7, 6, 5), triangle face 1:
    (0, 1, 4, 5, 10, 9), triangle face 2: (1, 2, 4, 6, 11, 10), triangle
    face 3: (2, 3, 4, 7, 12, 11), triangle face 5: (3, 0, 4, 8, 9, 12).
    The last point lies in the center of the cell (0, 1, 2, 3, 4). The
    parametric location of vertex #4 is [0.5, 0.5, 1].
    
    ote It should be noted that the parametric coordinates that describe
    this cell are not distorted like in Pyramid and
    QuadraticPyramid, which are a collapsed hexahedron. They are the
    actual uniform isoparametric coordinates, which are described in
    Browning's dissertation (see thanks section), but they are converted
    to [0, 1] space, and the nodes are rotated so that node-0 has x = 0,
    y = 0, while maintaining the CCW order.
    
    
     Description of 19-node pyramid from bottom to top (based on the z-axis).
    
     base quadrilateral including mid-edge nodes and mid-face node:
      3-- 7--2
      |      |
      8  13  6
      |      |
      0-- 5--1
    
     volumetric centroid node:
    
    
         18
    
    
     mid-face nodes of triangular faces:
    
         16
        /  \
      17    15
        \  /
         14
    
     mid-edge nodes of triangular faces:
    
       12--11
        |  |
        9--10
    
     top corner(apex):
    
    
         4
    
    
     
    
    @sa
    QuadraticEdge BiQuadraticTriangle QuadraticTetra
    QuadraticHexahedron BiQuadraticQuad QuadraticWedge
    
    @par Thanks: The shape functions and derivatives could be implemented
    thanks to the doctoral dissertation: R.S. Browning. A Second-Order
    19-Node Pyramid Finite Element Suitable for Lumped Mass Explicit
    Dynamic methods in Nonlinear Solid Mechanics, University of Alabama
    at Birmingham.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTriQuadraticPyramid, obj, update, **traits)
    
    def get_edge_array(self, *args):
        """
        get_edge_array(edgeId:int) -> Pointer
        C++: static const IdType *get_edge_array(IdType edgeId)
        Return the ids of the vertices defining edge/face
        (`edgeId`/`faceId'). Ids are related to the cell, not to the
        dataset.
        
        ote The return type changed. It used to be int*, it is now const
        IdType*. This is so ids are unified between Cell and
        Points.
        """
        ret = self._wrap_call(self._vtk_obj.GetEdgeArray, *args)
        return ret

    def get_face_array(self, *args):
        """
        get_face_array(faceId:int) -> Pointer
        C++: static const IdType *get_face_array(IdType faceId)"""
        ret = self._wrap_call(self._vtk_obj.GetFaceArray, *args)
        return ret

    def interpolation_derivs(self, *args):
        """
        interpolation_derivs(pcoords:(float, float, float), derivs:[float,
            float, float, float, float, float, float, float, float, float,
             float, float, float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float, float, float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float, float, float, float, float, float, float, float,
            float, float, float, float, float]) -> None
        C++: static void interpolation_derivs(const double pcoords[3],
            double derivs[57])"""
        ret = self._wrap_call(self._vtk_obj.InterpolationDerivs, *args)
        return ret

    def interpolation_functions(self, *args):
        """
        interpolation_functions(pcoords:(float, float, float),
            weights:[float, float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float, float, float]) -> None
        C++: static void interpolation_functions(const double pcoords[3],
            double weights[19])"""
        ret = self._wrap_call(self._vtk_obj.InterpolationFunctions, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(TriQuadraticPyramid, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit TriQuadraticPyramid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit TriQuadraticPyramid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit TriQuadraticPyramid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

