# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class RandomSequence(Object):
    """
    RandomSequence - Generate a sequence of random numbers.
    
    Superclass: Object
    
    RandomSequence defines the interface of any sequence of random
    numbers.
    
    At this level of abstraction, there is no assumption about the
    distribution of the numbers or about the quality of the sequence of
    numbers to be statistically independent. There is no assumption about
    the range of values.
    
    To the question about why a random "sequence" class instead of a
    random "generator" class or to a random "number" class?, see the OOSC
    book: "Object-Oriented Software Construction", 2nd Edition, by
    Bertrand Meyer. chapter 23, "Principles of class design",
    "Pseudo-random number generators: a design exercise", page 754--755.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkRandomSequence, obj, update, **traits)
    
    def _get_next_value(self):
        return self._vtk_obj.GetNextValue()
    next_value = traits.Property(_get_next_value, desc=\
        """
        Advance the sequence and return the new value.
        """
    )

    def _get_value(self):
        return self._vtk_obj.GetValue()
    value = traits.Property(_get_value, desc=\
        """
        Return the current value.
        """
    )

    def initialize(self, *args):
        """
        initialize(self, seed:int) -> None
        C++: virtual void initialize(TypeUInt32 seed)
        Initialize the sequence with a seed.
        """
        ret = self._wrap_call(self._vtk_obj.Initialize, *args)
        return ret

    def next(self):
        """
        next(self) -> None
        C++: virtual void next()
        Move to the next number in the random sequence.
        """
        ret = self._vtk_obj.Next()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(RandomSequence, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit RandomSequence properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit RandomSequence properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit RandomSequence properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

