# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class RandomPool(Object):
    """
    RandomPool - convenience class to quickly generate a pool of
    random numbers
    
    Superclass: Object
    
    RandomPool generates random numbers, and can do so using
    multithreading.  It supports parallel applications where generating
    random numbers on the fly is difficult (i.e., non-deterministic).
    Also, it can be used to populate DataArrays in an efficient
    manner. By default it uses an instance of MersenneTwister to
    generate random sequences, but any subclass of RandomSequence may
    be used. It also supports simple methods to generate, access, and
    pass random memory pools between objects.
    
    In threaded applications, these class may be conveniently used to
    pre-generate a sequence of random numbers, followed by the use of
    deterministic accessor methods to produce random sequences without
    problems etc. due to unpredictable work load and order of thread
    execution.
    
    @warning
    The class uses MultiThreader if the size of the pool is larger
    than the specified chunk size. Also, SMPTools may be used to scale
    the components in the method populate_data_array().
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkRandomPool, obj, update, **traits)
    
    chunk_size = traits.Trait(10000, traits.Range(1000, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        Specify the work chunk size at which point multithreading kicks
        in. For small memory pools < chunk_size, no threading is used.
        Larger pools are computed using MultiThreader.
        """
    )

    def _chunk_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetChunkSize,
                        self.chunk_size)

    number_of_components = traits.Trait(1, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        Methods to set and get the number of components in the pool. This
        is a convenience capability and can be used to interface with
        DataArrays. By default the number of components is =1.
        """
    )

    def _number_of_components_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfComponents,
                        self.number_of_components)

    def _get_sequence(self):
        return wrap_vtk(self._vtk_obj.GetSequence())
    def _set_sequence(self, arg):
        old_val = self._get_sequence()
        self._wrap_call(self._vtk_obj.SetSequence,
                        deref_vtk(arg))
        self.trait_property_changed('sequence', old_val, arg)
    sequence = traits.Property(_get_sequence, _set_sequence, desc=\
        """
        
        """
    )

    size = traits.Trait(0, traits.Range(0, 9223372036854775807, enter_set=True, auto_set=False), desc=\
        """
        Methods to set and get the size of the pool. The size must be
        specified before invoking generate_pool(). Note the number of
        components will affect the total size (allocated memory is
        Size*number_of_components).
        """
    )

    def _size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSize,
                        self.size)

    def _get_pool(self):
        return self._vtk_obj.GetPool()
    pool = traits.Property(_get_pool, desc=\
        """
        
        """
    )

    def _get_total_size(self):
        return self._vtk_obj.GetTotalSize()
    total_size = traits.Property(_get_total_size, desc=\
        """
        This convenience method returns the total size of the memory
        pool, i.e., Size*number_of_components.
        """
    )

    def get_value(self, *args):
        """
        get_value(self, i:int) -> float
        C++: double get_value(IdType i)
        get_value(self, i:int, compNum:int) -> float
        C++: double get_value(IdType i, int compNum)"""
        ret = self._wrap_call(self._vtk_obj.GetValue, *args)
        return ret

    def generate_pool(self):
        """
        generate_pool(self) -> Pointer
        C++: const double *generate_pool()
        These methods provide access to the raw random pool as a double
        array. The size of the array is Size*number_of_components. Each x
        value ranges between (0<=x<=1). The class will generate the pool
        as necessary (a modified time for generation is maintained). Also
        a method is available for getting the value at the ith pool
        position and compNum component. Finally, note that the get_value()
        method uses modulo reduction to ensure that the request remains
        inside of the pool. Two forms are provided, the first assumes
        number_of_components=1; the second allows access to a particular
        component. The get_pool() and get_value() methods should only be
        called after generate_pool() has been invoked;
        """
        ret = self._vtk_obj.GeneratePool()
        return ret
        

    def populate_data_array(self, *args):
        """
        populate_data_array(self, da:DataArray, minRange:float,
            maxRange:float) -> None
        C++: void populate_data_array(DataArray *da, double minRange,
            double maxRange)
        populate_data_array(self, da:DataArray, compNumber:int,
            minRange:float, maxRange:float) -> None
        C++: void populate_data_array(DataArray *da, int compNumber,
            double minRange, double maxRange)
        Methods to populate data arrays of various types with values
        within a specified (min,max) range. Note that compNumber is used
        to specify the range for a particular component; otherwise all
        generated components are within the (min,max) range specified.
        (Thus it is possible to make multiple calls to generate random
        numbers for each component with different ranges.) Internally the
        type of the data array passed in is used to cast to the
        appropriate type. Also the size and number of components of the
        DataArray controls the total number of random numbers
        generated; so the input data array should be pre-allocated with
        (set_number_of_components, set_number_of_tuples).
        """
        my_args = deref_array(args, [('vtkDataArray', 'float', 'float'), ('vtkDataArray', 'int', 'float', 'float')])
        ret = self._wrap_call(self._vtk_obj.PopulateDataArray, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('chunk_size', 'GetChunkSize'),
    ('number_of_components', 'GetNumberOfComponents'), ('size',
    'GetSize'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'chunk_size',
    'number_of_components', 'size'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(RandomPool, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit RandomPool properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['chunk_size', 'number_of_components', 'size']),
            title='Edit RandomPool properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit RandomPool properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

