# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class GroupDataSetsFilter(DataObjectAlgorithm):
    """
    GroupDataSetsFilter - groups inputs into a chosen composite
    dataset.
    
    Superclass: DataObjectAlgorithm
    
    GroupDataSetsFilter is a filter that can combine multiple input
    datasets into a MultBlockDataSet, PartitionedDataSet, or a
    PartitionedDataSetCollection.
    
    The inputs are added a individual blocks in the output and can be
    named assigned block-names using `set_input_name`.
    
    This is a more generic version of `vtkmulti_block_data_group_filter` and
    should be preferred.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGroupDataSetsFilter, obj, update, **traits)
    
    output_type = tvtk_base.RevPrefixMap({'partitioned_data_set_collection': 38, 'multi_block_data_set': 13, 'partitioned_data_set': 37}, default_value='partitioned_data_set_collection', desc=\
        """
        Get/Set the output type. Supported values are
        `VTK_PARTITIONED_DATA_SET_COLLECTION`,
        `VTK_PARTITIONED_DATA_SET`, and `VTK_MULTIBLOCK_DATA_SET`.
        
        Default it VTK_PARTITIONED_DATA_SET_COLLECTION.
        """
    )

    def _output_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputType,
                        self.output_type_)

    def get_input_name(self, *args):
        """
        get_input_name(self, index:int) -> str
        C++: const char *get_input_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetInputName, *args)
        return ret

    def set_input_name(self, *args):
        """
        set_input_name(self, index:int, name:str) -> None
        C++: void set_input_name(int index, const char *name)
        API to assign names for inputs. If not specified, the filter
        automatically creates sensible names based on the chosen output
        type.
        
        Names are not useful or relevant if output type is
        `VTK_PARTITIONED_DATA_SET` and hence are ignored for that type.
        """
        ret = self._wrap_call(self._vtk_obj.SetInputName, *args)
        return ret

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def clear_input_names(self):
        """
        clear_input_names(self) -> None
        C++: void clear_input_names()
        Clears all assigned input names.
        """
        ret = self._vtk_obj.ClearInputNames()
        return ret
        

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('output_type',
    'GetOutputType'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'output_type', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GroupDataSetsFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GroupDataSetsFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], ['output_type'], []),
            title='Edit GroupDataSetsFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GroupDataSetsFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

